/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.common.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.LinkedList;
import java.util.List;

public class FieldReflectionUtility {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EXP (c) Copyright IBM Corp. 2009, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public static <T> List<T> getBetaAwareFieldValuesList(Class<?> classWithFields, Class<T> fieldType) {
        LinkedList<Object> result = new LinkedList<Object>();
        Field[] fields = classWithFields.getFields();
        int i = 0;
        while (i < fields.length) {
            Field field = fields[i];
            int modifiers = field.getModifiers();
            if (Modifier.isStatic(modifiers) && Modifier.isPublic(modifiers) && fieldType.isAssignableFrom(field.getType())) {
                try {
                    field.setAccessible(true);
                    Object value = field.get(null);
                    if (value == null) {
                        throw new RuntimeException("Circular classloading dependency problem, null field " + field.getName());
                    }
                    result.add(value);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
            ++i;
        }
        return result;
    }
}

