/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.connections;

import com.ibm.cics.core.comm.IConnectionCategory;
import com.ibm.cics.core.comm.IConnectionDescriptor;
import com.ibm.cics.eclipse.common.ui.QueryCompositeImageDescriptor;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ConnectionsImages {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EXP (c) Copyright IBM Corp. 2011, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static ImageRegistry imageRegistry;
    public static final String ACTIVE_CONNECTION = "ACTIVE_CONNECTION";
    public static final String ACTIVE_CONNECTION_DISABLED = "ACTIVE_CONNECTION_DISABLED";
    public static final String ACTIVE_SECURE_CONNECTION = "ACTIVE_SECURE_CONNECTION";
    public static final String CONNECTION_WARNING = "CONNECTION_WARNING";
    public static final String COPY_CON = "COPY_CON";
    public static final String DELETE_CON = "DELETE_CON";
    public static final String ERROR = "ERROR";
    public static final String ERROR_OVERLAY = "ERROR_OVERLAY";
    public static final String IN_ACTIVE_CONNECTION = "IN_ACTIVE_CONNECTION";
    public static final String IN_ACTIVE_SECURE_CONNECTION = "IN_ACTIVE_SECURE_CONNECTION";
    public static final String IN_PROGRESS_CONNECTION = "IN_PROGRESS_CONNECTION";
    public static final String LOCKED_OVERLAY = "LOCKED_OVERLAY";
    public static final String NEW_CON = "NEW_CON";
    public static final String PASSWORD_WIZ_BAN = "PASSWORD_WIZ_BAN";
    public static final String WARNING_OVERLAY = "WARNING_OVERLAY";
    public static final String LINKED_OVERLAY = "LINKED_OVERLAY";
    public static final String CREATE_OVERLAY = "CREATE_OVERLAY";
    public static final String USER_OVERLAY = "USER_OVERLAY";
    public static final String WARNING = "WARNING";
    public static final String TICK_OVERLAY = "TICK_OVERLAY";
    public static final String STOP_CONNECTION = "STOP_CONNECTION";
    public static final String STOP_CONNECTION_DISABLED = "STOP_CONNECTION_DISABLED";
    public static final String CONNECTION_PROVIDER = "CONNECTION_PROVIDER";
    public static final String CONNECTION_PROVIDER_ADD = "CONNECTION_PROVIDER_ADD";
    public static final String CONNECTIONS_EXPORT = "CONNECTIONS_EXPORT";
    public static final String PRESET_CONNECTIONS = "PRESET_CONNECTIONS";
    public static final String MANAGE_CONNECTIONS = "MANAGE_CONNECTIONS";
    public static final String CONNECTION_WIZ_BAN = "CONNECTION_WIZ_BAN";
    public static final String CONNECTIONS_IMPORT_WIZ_BAN = "CONNECTIONS_IMPORT_WIZ_BAN";
    public static final String CREDENTIAL = "CREDENTIAL";
    public static final String ACTIVE_CREDENTIAL = "ACTIVE_CREDENTIAL";
    public static final String BAD_CREDENTIAL = "BAD_CREDENTIAL";
    public static final String CONNECTION_DEFAULT = "CONNECTION_DEFAULT";
    public static final String CERTIFICATE_IMPORT_WIZ_BAN = "CERTIFICATE_IMPORT_WIZ_BAN";
    public static final String SECURITY_QUESTION_WIZ_BAN = "SECURITY_QUESTION_WIZ_BAN";
    private static Map<Image, Image> linkedOverlays;
    private static Map<Image, Image> errorOverlays;
    private static Map<Image, Image> warningOverlays;
    private static Map<Image, Image> userOverlays;

    static {
        linkedOverlays = new HashMap<Image, Image>();
        errorOverlays = new HashMap<Image, Image>();
        warningOverlays = new HashMap<Image, Image>();
        userOverlays = new HashMap<Image, Image>();
    }

    public static Image register(URL aURL) {
        try {
            Image newImage = new Image(null, aURL.openStream());
            ConnectionsImages.getImageRegistry().put(aURL.toExternalForm(), newImage);
            return newImage;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static ImageRegistry initializeImageRegistry() {
        imageRegistry = new ImageRegistry(Display.getDefault());
        imageRegistry.put(WARNING_OVERLAY, ConnectionsImages.createImageDescriptor("icons/full/elcl16/warning_overlay.gif"));
        imageRegistry.put(ERROR_OVERLAY, ConnectionsImages.createImageDescriptor("icons/full/elcl16/error_ovr.gif"));
        imageRegistry.put(LOCKED_OVERLAY, ConnectionsImages.createImageDescriptor("icons/statusLocked_obj10.gif"));
        imageRegistry.put(LINKED_OVERLAY, ConnectionsImages.createImageDescriptor("icons/full/ovr16/link_overlay.gif"));
        imageRegistry.put(TICK_OVERLAY, ConnectionsImages.createImageDescriptor("icons/full/ovr16/tick_overlay.gif"));
        imageRegistry.put(CREATE_OVERLAY, ConnectionsImages.createImageDescriptor("icons/full/ovr16/add_overlay.gif"));
        imageRegistry.put(USER_OVERLAY, ConnectionsImages.createImageDescriptor("icons/full/ovr16/user.gif"));
        imageRegistry.put(ACTIVE_CONNECTION, ConnectionsImages.createImageDescriptor("icons/full/elcl16/public_co.gif"));
        imageRegistry.put(ACTIVE_CONNECTION_DISABLED, ConnectionsImages.createImageDescriptor("icons/full/dlcl16/active_connection.gif"));
        imageRegistry.put(COPY_CON, ConnectionsImages.createImageDescriptor("icons/full/elcl16/copy_edit_co.gif"));
        imageRegistry.put(DELETE_CON, ConnectionsImages.createImageDescriptor("icons/full/elcl16/delete_config.gif"));
        imageRegistry.put(ERROR, ConnectionsImages.createImageDescriptor("icons/full/elcl16/error.gif"));
        imageRegistry.put(IN_ACTIVE_CONNECTION, ConnectionsImages.createImageDescriptor("icons/full/elcl16/private_co.gif"));
        imageRegistry.put(IN_PROGRESS_CONNECTION, ConnectionsImages.createImageDescriptor("icons/full/elcl16/protected_co.gif"));
        imageRegistry.put(NEW_CON, ConnectionsImages.createImageDescriptor("icons/full/elcl16/new_connection.gif"));
        imageRegistry.put(WARNING, ConnectionsImages.createImageDescriptor("icons/full/elcl16/warn.gif"));
        imageRegistry.put(CREDENTIAL, ConnectionsImages.createImageDescriptor("icons/full/elcl16/password.gif"));
        imageRegistry.put(CONNECTION_DEFAULT, ConnectionsImages.createImageDescriptor("icons/full/elcl16/connections_view.gif"));
        imageRegistry.put(STOP_CONNECTION, ConnectionsImages.createImageDescriptor("icons/full/elcl16/stop_connection.gif"));
        imageRegistry.put(STOP_CONNECTION_DISABLED, ConnectionsImages.createImageDescriptor("icons/full/dlcl16/stop_connection.gif"));
        imageRegistry.put(CONNECTION_PROVIDER, ConnectionsImages.createImageDescriptor("icons/full/elcl16/connection_provider.gif"));
        imageRegistry.put(PRESET_CONNECTIONS, ConnectionsImages.createImageDescriptor("icons/full/elcl16/default_connection_provider.gif"));
        imageRegistry.put(CONNECTION_PROVIDER_ADD, ConnectionsImages.createImageDescriptor("icons/full/elcl16/import_connections.gif"));
        imageRegistry.put(CONNECTIONS_EXPORT, ConnectionsImages.createImageDescriptor("icons/full/elcl16/export_connections.gif"));
        imageRegistry.put(MANAGE_CONNECTIONS, ConnectionsImages.createImageDescriptor("icons/full/elcl16/connections_view.gif"));
        imageRegistry.put(PASSWORD_WIZ_BAN, ConnectionsImages.createImageDescriptor("icons/full/wizban/password_wiz.gif"));
        imageRegistry.put(CONNECTION_WIZ_BAN, ConnectionsImages.createImageDescriptor("icons/full/wizban/connection_user_wiz.gif"));
        imageRegistry.put(CONNECTIONS_IMPORT_WIZ_BAN, ConnectionsImages.createImageDescriptor("icons/full/wizban/import_connections_wiz.gif"));
        imageRegistry.put(CERTIFICATE_IMPORT_WIZ_BAN, ConnectionsImages.createImageDescriptor("icons/full/wizban/import_cert_wiz.gif"));
        imageRegistry.put(SECURITY_QUESTION_WIZ_BAN, ConnectionsImages.createImageDescriptor("icons/full/wizban/security_query.gif"));
        imageRegistry.put(CONNECTION_WARNING, (ImageDescriptor)new QueryCompositeImageDescriptor(imageRegistry.get(ACTIVE_CONNECTION), imageRegistry.get(ERROR_OVERLAY), 3));
        imageRegistry.put(ACTIVE_SECURE_CONNECTION, (ImageDescriptor)new QueryCompositeImageDescriptor(imageRegistry.get(ACTIVE_CONNECTION), imageRegistry.get(LOCKED_OVERLAY), 3));
        imageRegistry.put(IN_ACTIVE_SECURE_CONNECTION, (ImageDescriptor)new QueryCompositeImageDescriptor(imageRegistry.get(IN_ACTIVE_CONNECTION), imageRegistry.get(LOCKED_OVERLAY), 3));
        imageRegistry.put(ACTIVE_CREDENTIAL, (ImageDescriptor)new QueryCompositeImageDescriptor(imageRegistry.get(CREDENTIAL), imageRegistry.get(TICK_OVERLAY), 0));
        imageRegistry.put(BAD_CREDENTIAL, (ImageDescriptor)new QueryCompositeImageDescriptor(imageRegistry.get(CREDENTIAL), imageRegistry.get(ERROR_OVERLAY), 0));
        return imageRegistry;
    }

    private static ImageDescriptor createImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.ibm.cics.core.connections", (String)path);
    }

    public static ImageDescriptor getImageDescriptor(String key) {
        return ConnectionsImages.getImageRegistry().getDescriptor(key);
    }

    public static Image getImage(String key) {
        return ConnectionsImages.getImageRegistry().get(key);
    }

    public static ImageRegistry getImageRegistry() {
        if (imageRegistry == null) {
            ConnectionsImages.initializeImageRegistry();
        }
        return imageRegistry;
    }

    public static Image getWithLinkedOverlay(Image image) {
        Image linkedOverlayImage = linkedOverlays.get(image);
        if (linkedOverlayImage == null) {
            QueryCompositeImageDescriptor imageDescriptor = new QueryCompositeImageDescriptor(image, ConnectionsImages.getImage(LINKED_OVERLAY), 0);
            linkedOverlayImage = imageDescriptor.createImage();
            linkedOverlays.put(image, linkedOverlayImage);
        }
        return linkedOverlayImage;
    }

    public static Image getWithErrorOverlay(Image image) {
        Image errorOverlayImage = errorOverlays.get(image);
        if (errorOverlayImage == null) {
            QueryCompositeImageDescriptor imageDescriptor = new QueryCompositeImageDescriptor(image, ConnectionsImages.getImage(ERROR_OVERLAY), 0);
            errorOverlayImage = imageDescriptor.createImage();
            errorOverlays.put(image, errorOverlayImage);
        }
        return errorOverlayImage;
    }

    public static Image getWithWarningOverlay(Image image) {
        Image warningOverlayImage = warningOverlays.get(image);
        if (warningOverlayImage == null) {
            QueryCompositeImageDescriptor imageDescriptor = new QueryCompositeImageDescriptor(image, ConnectionsImages.getImage(WARNING_OVERLAY), 0);
            warningOverlayImage = imageDescriptor.createImage();
            warningOverlays.put(image, warningOverlayImage);
        }
        return warningOverlayImage;
    }

    public static Image getWithUserOverlay(Image image) {
        Image errorOverlayImage = userOverlays.get(image);
        if (errorOverlayImage == null) {
            QueryCompositeImageDescriptor imageDescriptor = new QueryCompositeImageDescriptor(image, ConnectionsImages.getImage(USER_OVERLAY), 2);
            errorOverlayImage = imageDescriptor.createImage();
            userOverlays.put(image, errorOverlayImage);
        }
        return errorOverlayImage;
    }

    public static Image getImage(IConnectionDescriptor connectionDescriptor) {
        return ConnectionsImages.getImageRegistry().get(NEW_CON);
    }

    public static Image getCreateConnectionImage(IConnectionCategory aConnectionCategory) {
        String imageKey = String.valueOf(aConnectionCategory.getId()) + ".create";
        Image image = ConnectionsImages.getImageRegistry().get(imageKey);
        if (image == null) {
            Image rawImage = ConnectionsImages.getImage(aConnectionCategory);
            if (rawImage == null) {
                return null;
            }
            ConnectionsImages.getImageRegistry().put(imageKey, (ImageDescriptor)new QueryCompositeImageDescriptor(rawImage, ConnectionsImages.getImage(CREATE_OVERLAY), 2));
            return ConnectionsImages.getImage(imageKey);
        }
        return image;
    }

    public static ImageDescriptor getCreateConnectionImageDescriptor(IConnectionCategory aConnectionCategory) {
        String imageKey = String.valueOf(aConnectionCategory.getId()) + ".create";
        ImageDescriptor imageDescriptor = ConnectionsImages.getImageRegistry().getDescriptor(imageKey);
        if (imageDescriptor == null) {
            Image rawImage = ConnectionsImages.getImage(aConnectionCategory);
            ConnectionsImages.getImageRegistry().put(imageKey, (ImageDescriptor)new QueryCompositeImageDescriptor(rawImage, ConnectionsImages.getImage(CREATE_OVERLAY), 2));
            return ConnectionsImages.getImageDescriptor(imageKey);
        }
        return imageDescriptor;
    }

    public static Image getImage(IConnectionCategory aConnectionCategory) {
        URL iconPath = aConnectionCategory.getIconPath();
        if (iconPath != null) {
            String key = iconPath.toExternalForm();
            Image image = ConnectionsImages.getImage(key);
            if (image == null) {
                image = ConnectionsImages.register(iconPath);
            }
            return image;
        }
        return ConnectionsImages.getImage(CONNECTION_DEFAULT);
    }
}

