/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.connections.internal;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.connections.internal.DebugOptions;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class ConnectionPreferences
implements Preferences {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EXP (c) Copyright IBM Corp. 2011, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(ConnectionPreferences.class);
    private static final String REMOVED = "removed";
    private Preferences instancePrefs;
    private Preferences defaultPrefs;

    public ConnectionPreferences(String qualifier) {
        if ("com.ibm.cics.core.ui".equals(qualifier)) {
            qualifier = "com.ibm.cics.core.connections";
        }
        this.instancePrefs = InstanceScope.INSTANCE.getNode(qualifier).node("connections");
        this.defaultPrefs = DefaultScope.INSTANCE.getNode(qualifier).node("connections");
    }

    private ConnectionPreferences(Preferences instancePreferences, Preferences defaultPreferences) {
        this.instancePrefs = instancePreferences;
        this.defaultPrefs = defaultPreferences;
        instancePreferences.remove(REMOVED);
    }

    public String absolutePath() {
        throw new UnsupportedOperationException();
    }

    public String[] childrenNames() throws BackingStoreException {
        HashSet<String> nameSet = new HashSet<String>();
        String[] defaultNames = this.defaultPrefs.childrenNames();
        int i = 0;
        while (i < defaultNames.length) {
            String name = defaultNames[i];
            Preferences node = this.defaultPrefs.node(name);
            if (node.keys().length > 0) {
                nameSet.add(name);
            }
            ++i;
        }
        String[] instanceNames = this.instancePrefs.childrenNames();
        int i2 = 0;
        while (i2 < instanceNames.length) {
            String name = instanceNames[i2];
            Preferences node = this.instancePrefs.node(name);
            boolean removed = node.getBoolean(REMOVED, false);
            if (removed) {
                nameSet.remove(name);
            } else {
                nameSet.add(name);
            }
            ++i2;
        }
        String[] childrenNames = new String[nameSet.size()];
        nameSet.toArray(childrenNames);
        if (DebugOptions.DEBUG_PREFERENCES) {
            debug.event("childrenNames", Arrays.asList(childrenNames));
        }
        return childrenNames;
    }

    public String[] defaultChildrenNames() throws BackingStoreException {
        HashSet<String> nameSet = new HashSet<String>();
        String[] defaultNames = this.defaultPrefs.childrenNames();
        int i = 0;
        while (i < defaultNames.length) {
            String name = defaultNames[i];
            Preferences node = this.defaultPrefs.node(name);
            if (node.keys().length > 0) {
                nameSet.add(name);
            }
            ++i;
        }
        String[] childrenNames = new String[nameSet.size()];
        nameSet.toArray(childrenNames);
        if (DebugOptions.DEBUG_PREFERENCES) {
            debug.event("defaultChildrenNames", Arrays.asList(childrenNames));
        }
        return childrenNames;
    }

    public void clear() throws BackingStoreException {
        throw new UnsupportedOperationException();
    }

    public void flush() throws BackingStoreException {
        this.instancePrefs.flush();
    }

    public String get(String key, String def) {
        String defaultValue = this.defaultPrefs.get(key, def);
        String value = this.instancePrefs.get(key, defaultValue);
        return value;
    }

    public boolean getBoolean(String key, boolean def) {
        Boolean defaultValue = this.defaultPrefs.getBoolean(key, def);
        Boolean value = this.instancePrefs.getBoolean(key, defaultValue.booleanValue());
        return value;
    }

    public byte[] getByteArray(String key, byte[] def) {
        throw new UnsupportedOperationException();
    }

    public double getDouble(String key, double def) {
        throw new UnsupportedOperationException();
    }

    public float getFloat(String key, float def) {
        throw new UnsupportedOperationException();
    }

    public int getInt(String key, int def) {
        int defaultValue = this.defaultPrefs.getInt(key, def);
        int value = this.instancePrefs.getInt(key, defaultValue);
        return value;
    }

    public long getLong(String key, long def) {
        throw new UnsupportedOperationException();
    }

    public String[] keys() throws BackingStoreException {
        throw new UnsupportedOperationException();
    }

    public String name() {
        return this.instancePrefs.name();
    }

    public Preferences node(String pathName) {
        return new ConnectionPreferences(this.instancePrefs.node(pathName), this.defaultPrefs.node(pathName));
    }

    public boolean nodeExists(String pathName) throws BackingStoreException {
        boolean instanceExists = this.instancePrefs.nodeExists(pathName);
        boolean defaultRemoved = instanceExists && this.instancePrefs.node(pathName).getBoolean(REMOVED, false);
        boolean defaultOnly = !this.instancePrefs.nodeExists(pathName) && this.defaultPrefs.nodeExists(pathName);
        boolean exists = instanceExists || defaultOnly && !defaultRemoved;
        return exists;
    }

    public Preferences parent() {
        throw new UnsupportedOperationException();
    }

    public void put(String key, String value) {
        String defaultValue = this.defaultPrefs.get(key, "");
        if (defaultValue.equals(value)) {
            this.instancePrefs.remove(key);
        } else {
            this.instancePrefs.put(key, value);
        }
    }

    public void putBoolean(String key, boolean value) {
        Boolean defaultValue = this.defaultPrefs.getBoolean(key, false);
        if (defaultValue.equals(value)) {
            this.instancePrefs.remove(key);
        } else {
            this.instancePrefs.putBoolean(key, value);
        }
    }

    public void putByteArray(String key, byte[] value) {
        throw new UnsupportedOperationException();
    }

    public void putDouble(String key, double value) {
        throw new UnsupportedOperationException();
    }

    public void putFloat(String key, float value) {
        throw new UnsupportedOperationException();
    }

    public void putInt(String key, int value) {
        int defaultValue = this.defaultPrefs.getInt(key, 0);
        if (defaultValue == value) {
            this.instancePrefs.remove(key);
        } else {
            this.instancePrefs.putInt(key, value);
        }
    }

    public void putLong(String key, long value) {
        throw new UnsupportedOperationException();
    }

    public void remove(String key) {
        this.instancePrefs.remove(key);
    }

    public void removeNode() throws BackingStoreException {
        if (this.defaultPrefs.keys().length == 0) {
            this.defaultPrefs.removeNode();
            this.instancePrefs.removeNode();
        } else {
            this.instancePrefs.putBoolean(REMOVED, true);
        }
    }

    public void sync() throws BackingStoreException {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return this.instancePrefs.toString();
    }

    public Preferences getDefaultPreferences() {
        return this.defaultPrefs;
    }
}

