/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui;

import com.ibm.cics.core.ui.Debug;
import com.ibm.cics.core.ui.properties.AttributePropertyHelper;
import com.ibm.cics.core.ui.properties.CICSObjectPropertyDescriptor;
import com.ibm.cics.core.ui.properties.IAttributePropertyDescriptor;
import com.ibm.cics.core.ui.properties.ICICSObjectPropertyDescriptor;
import com.ibm.cics.core.ui.properties.IDescriptionProvider;
import com.ibm.cics.model.Descriptions;
import com.ibm.cics.model.ICICSAttribute;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.model.meta.IType;
import java.util.logging.Logger;
import org.eclipse.core.runtime.Platform;

public class CICSTypePropertySource
extends AttributePropertyHelper {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(CICSTypePropertySource.class.getPackage().getName());
    private IDescriptionProvider descriptionProvider;
    private String typeHelpContextId;

    public CICSTypePropertySource(ICICSType<?> cicsType) {
        this(cicsType, cicsType.getInterfaceType());
    }

    public CICSTypePropertySource(ICICSType<?> cicsType, Class<?> modelInterfaceType) {
        super((IType<?>)cicsType, modelInterfaceType);
        this.typeHelpContextId = String.valueOf(this.getDescriptionProvider().getHelpContextIdPrefix()) + ".type_" + cicsType.getResourceTableName();
    }

    public CICSTypePropertySource(ICICSType<?> cicsType, IAttribute<?> ... attributesToDecorate) {
        this(cicsType);
        IAttribute<?>[] iAttributeArray = attributesToDecorate;
        int n = attributesToDecorate.length;
        int n2 = 0;
        while (n2 < n) {
            IAttribute<?> attributeToDecorate = iAttributeArray[n2];
            IAttributePropertyDescriptor propertyDescriptor = (IAttributePropertyDescriptor)this.descriptorMap.get(attributeToDecorate.getPropertyId());
            if (propertyDescriptor instanceof ICICSObjectPropertyDescriptor) {
                ((ICICSObjectPropertyDescriptor)propertyDescriptor).setDecorateImage(true);
            }
            ++n2;
        }
    }

    @Deprecated
    public ICICSType<?> getCICSType() {
        return this.getType();
    }

    public ICICSType<?> getType() {
        return (ICICSType)super.getType();
    }

    @Override
    protected IAttributePropertyDescriptor createPropertyDescriptor(IType<?> aType, IAttribute<?> attribute, String simpleClassName, boolean mutable) {
        return new CICSObjectPropertyDescriptor((ICICSType)aType, (ICICSAttribute)attribute, simpleClassName, this.getDescriptionProvider());
    }

    public String getTypeHelpContextId() {
        return this.typeHelpContextId;
    }

    protected IDescriptionProvider getDescriptionProvider() {
        if (this.descriptionProvider == null) {
            this.descriptionProvider = (IDescriptionProvider)Platform.getAdapterManager().loadAdapter((Object)this.type, IDescriptionProvider.class.getName());
            if (this.descriptionProvider == null) {
                this.descriptionProvider = new IDescriptionProvider(){

                    @Override
                    public String getString(String key) {
                        return Descriptions.getMissingString(key);
                    }

                    @Override
                    public String getHelpContextIdPrefix() {
                        return "com.ibm.cics.core.ui";
                    }
                };
            }
            if (Debug.DEBUG_PROPERTIES) {
                Debug.event((Logger)logger, (String)CICSTypePropertySource.class.getName(), (String)"getDescriptionProvider", (Object)(" type=" + this.type + ", provider=" + this.descriptionProvider));
            }
        }
        return this.descriptionProvider;
    }
}

