/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.actions;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.model.extra.IWLMActiveRuleEditorSource;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.IWorkload;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IActionDelegate;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;

public class OpenRelevantActiveRuleEditorAction
extends Action
implements IActionDelegate {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(OpenRelevantActiveRuleEditorAction.class);
    private IWLMActiveRuleEditorSource objectToActOn;

    public void run(IAction action) {
        if (this.objectToActOn != null) {
            this.reflectivelyRunEditRoutingRuleAction(this.objectToActOn);
        }
    }

    public void runTriggeredByDoubleClick(DoubleClickEvent event) {
        this.grabObjectToActOnFromSelection(event.getSelection());
        this.run((IAction)this);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.grabObjectToActOnFromSelection(selection);
    }

    private void grabObjectToActOnFromSelection(ISelection selection) {
        if (selection == null || selection.isEmpty()) {
            this.objectToActOn = null;
        } else {
            final Object firstElement = ((IStructuredSelection)selection).getFirstElement();
            if (firstElement instanceof IWLMActiveRuleEditorSource) {
                this.objectToActOn = (IWLMActiveRuleEditorSource)firstElement;
            } else if (firstElement instanceof IWorkload) {
                this.objectToActOn = new IWLMActiveRuleEditorSource(){

                    public String getEditorOpeningPage() {
                        return "wlm.activeWorkloadDefinitionTargets";
                    }

                    public ICICSObject getEditorInputObject() {
                        return (IWorkload)firstElement;
                    }
                };
            }
        }
    }

    private void reflectivelyRunEditRoutingRuleAction(IWLMActiveRuleEditorSource aCICSObject) {
        try {
            Bundle editorsBundle = Platform.getBundle((String)"com.ibm.cics.core.ui.editors");
            Class editAction = editorsBundle.loadClass("com.ibm.cics.core.ui.editors.actions.EditRoutingRuleAction");
            IObjectActionDelegate editResourceDefinitionAction = (IObjectActionDelegate)editAction.newInstance();
            editResourceDefinitionAction.setActivePart(null, PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart());
            editResourceDefinitionAction.selectionChanged(null, (ISelection)new StructuredSelection((Object)aCICSObject));
            editResourceDefinitionAction.run(null);
        }
        catch (Exception ex) {
            debug.error("reflectivelyRunEditRoutingRuleAction", (Throwable)ex);
        }
    }
}

