/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.internal.cloud;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.model.CICSRegionGroupDefinitionType;
import com.ibm.cics.core.model.CICSSystemManagerException;
import com.ibm.cics.core.model.EqualityHelper;
import com.ibm.cics.core.model.FilteredContext;
import com.ibm.cics.core.model.ManagementPartType;
import com.ibm.cics.core.ui.internal.cloud.AbstractRegionTypesNodeDeferredWorkbenchAdapter;
import com.ibm.cics.core.ui.internal.cloud.ApplicationRegionTypeDeferredWorkbenchAdapter;
import com.ibm.cics.core.ui.internal.cloud.CloudInput;
import com.ibm.cics.core.ui.internal.cloud.ErrorWrapper;
import com.ibm.cics.model.IApplication;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICICSRegionGroupDefinition;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.model.IManagementPart;
import com.ibm.cics.sm.comm.IContext;
import java.util.ArrayList;
import java.util.List;

public class ApplicationRegionTypesNodeDeferredWorkbenchAdapter
extends AbstractRegionTypesNodeDeferredWorkbenchAdapter {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2012, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private final IApplication application;
    private static Debug DEBUG = new Debug(ApplicationRegionTypesNodeDeferredWorkbenchAdapter.class);

    public ApplicationRegionTypesNodeDeferredWorkbenchAdapter(CloudInput aCloudInput, IApplication application) {
        super(aCloudInput);
        this.application = application;
    }

    @Override
    public Object[] getDataChildren(Object o) {
        DEBUG.enter("getDataChildren", (Object)this, o);
        Object[] children = new Object[]{};
        try {
            List<ICICSRegionGroupDefinition> listRegionTypes = this.getApplicationRegionTypes();
            children = new Object[listRegionTypes.size()];
            int i = 0;
            while (i < listRegionTypes.size()) {
                DEBUG.event("getDataChildren", String.valueOf(listRegionTypes.size()) + " application region types");
                ICICSRegionGroupDefinition regionType = listRegionTypes.get(i);
                children[i] = new ApplicationRegionTypeDeferredWorkbenchAdapter(this.getCloudInput(), regionType, this.application);
                ++i;
            }
        }
        catch (CICSSystemManagerException e) {
            if (e.getCause() != null) {
                DEBUG.event("getDataChildren", (Object)e);
                children = new Object[]{new ErrorWrapper(e.getCause())};
            }
            DEBUG.error("getDataChildren", (Throwable)e);
        }
        DEBUG.exit("getDataChildren", (Object)children);
        return children;
    }

    private List<ICICSRegionGroupDefinition> getApplicationRegionTypes() throws CICSSystemManagerException {
        DEBUG.enter("getApplicationRegionTypes", (Object)this);
        ArrayList<ICICSRegionGroupDefinition> regionTypes = new ArrayList<ICICSRegionGroupDefinition>();
        List<IManagementPart> applicationManagementParts = this.getApplicationManagementParts();
        for (IManagementPart applicationManagementPart : applicationManagementParts) {
            DEBUG.event("getApplicationRegionTypes", String.valueOf(applicationManagementParts.size()) + " management parts");
            FilteredContext filteredContext = this.getFilteredContextForAttribute(this.getContext(), CICSRegionGroupDefinitionType.REGIONTYPE, applicationManagementPart.getRegionType());
            filteredContext.setAttributeValue(CICSRegionGroupDefinitionType.PLATDEF, (Object)applicationManagementPart.getPlatformDefinitionName());
            ICICSObject[] results = this.getCICSObjectsWithoutListeners((ICICSType<?>)CICSRegionGroupDefinitionType.getInstance(), (IContext)filteredContext);
            DEBUG.event("getApplicationRegionTypes", String.valueOf(results.length) + " CICS region groups");
            ICICSObject[] iCICSObjectArray = results;
            int n = results.length;
            int n2 = 0;
            while (n2 < n) {
                ICICSObject result = iCICSObjectArray[n2];
                ICICSRegionGroupDefinition regionType = (ICICSRegionGroupDefinition)result;
                boolean alreadyExists = false;
                for (ICICSRegionGroupDefinition listRegionType : regionTypes) {
                    if (!listRegionType.getName().equals(regionType.getName())) continue;
                    alreadyExists = true;
                    break;
                }
                if (!alreadyExists) {
                    regionTypes.add((ICICSRegionGroupDefinition)result);
                }
                ++n2;
            }
        }
        DEBUG.exit("getApplicationRegionTypes", regionTypes);
        return regionTypes;
    }

    private List<IManagementPart> getApplicationManagementParts() throws CICSSystemManagerException {
        ICICSObject[] results;
        DEBUG.enter("getApplicationManagementParts", (Object)this);
        FilteredContext filteredContext = this.getFilteredContextForAttribute(this.getContext(), ManagementPartType.APPLICATION_DEFINITION_NAME, this.application.getApplicationDefinitionName());
        filteredContext.setAttributeValue(ManagementPartType.PLATFORM_DEFINITION_NAME, (Object)this.application.getPlatformDefinitionName());
        ArrayList<IManagementPart> managementParts = new ArrayList<IManagementPart>();
        ICICSObject[] iCICSObjectArray = results = this.getCICSObjectsWithoutListeners((ICICSType<?>)ManagementPartType.getInstance(), (IContext)filteredContext);
        int n = results.length;
        int n2 = 0;
        while (n2 < n) {
            ICICSObject result = iCICSObjectArray[n2];
            managementParts.add((IManagementPart)result);
            ++n2;
        }
        DEBUG.exit("getApplicationManagementParts", managementParts);
        return managementParts;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.application == null ? 0 : this.application.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ApplicationRegionTypesNodeDeferredWorkbenchAdapter other = (ApplicationRegionTypesNodeDeferredWorkbenchAdapter)obj;
        return !(this.application == null ? other.application != null : !EqualityHelper.equals((ICICSObject)this.application, (ICICSObject)other.application));
    }
}

