/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.internal.cloud;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.model.ManagementPartType;
import com.ibm.cics.core.ui.UIPlugin;
import com.ibm.cics.core.ui.internal.cloud.AbstractCPSMDeferredWorkbenchAdapter;
import com.ibm.cics.core.ui.internal.cloud.CloudInput;
import com.ibm.cics.model.IManagementPart;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IDecorationContext;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.progress.IElementCollector;

final class ManagementPartDeferredWorkbenchAdapter
extends AbstractCPSMDeferredWorkbenchAdapter {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2012, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static Debug DEBUG = new Debug(ManagementPartDeferredWorkbenchAdapter.class);
    private final IManagementPart managepart;

    ManagementPartDeferredWorkbenchAdapter(CloudInput anInput, IManagementPart part) {
        super(anInput);
        this.managepart = part;
    }

    public Object getParent(Object o) {
        return null;
    }

    public String getLabel(Object o) {
        StringBuilder appBuilder = new StringBuilder();
        appBuilder.append(this.managepart.getBundleID());
        appBuilder.append(" (");
        appBuilder.append(this.managepart.getBundleMajorVersion());
        appBuilder.append('.');
        appBuilder.append(this.managepart.getBundleMinorVersion());
        appBuilder.append('.');
        appBuilder.append(this.managepart.getBundleMicroVersion());
        appBuilder.append(")");
        return appBuilder.toString();
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        ImageDescriptor imageDesc = ImageDescriptor.createFromImage((Image)UIPlugin.getTableImage(ManagementPartType.getInstance().getResourceTableName()));
        if (this.managepart.getEnableStatus() != IManagementPart.EnableStatusValue.ENABLED) {
            imageDesc = ImageDescriptor.createWithFlags((ImageDescriptor)imageDesc, (int)1);
        }
        return imageDesc;
    }

    @Override
    public Object[] getDataChildren(Object inputElement) {
        DEBUG.enter("getDataChildren", (Object)this, inputElement);
        Object[] results = new Object[]{};
        DEBUG.exit("getDataChildren", (Object)results);
        return results;
    }

    public boolean isContainer() {
        return false;
    }

    public ISchedulingRule getRule(Object object) {
        return null;
    }

    @Override
    public void fetchDeferredChildren(Object object, IElementCollector collector, IProgressMonitor monitor) {
    }

    @Override
    public String getDecorateText(IDecorationContext context) {
        boolean enablementSupported;
        StringBuilder decorationBuilder = new StringBuilder();
        IManagementPart.AvailabilityValue availability = this.managepart.getAvailability();
        IManagementPart.EnableStatusValue enableStatus = this.managepart.getEnableStatus();
        boolean bl = enablementSupported = !((IManagementPart.EnableStatusValue)ManagementPartType.ENABLE_STATUS.getUnsupportedValue()).equals((Object)enableStatus);
        if (enablementSupported) {
            decorationBuilder.append(enableStatus.toString());
        }
        if (!((IManagementPart.AvailabilityValue)ManagementPartType.AVAILABILITY.getUnsupportedValue()).equals((Object)availability) && !availability.equals((Object)IManagementPart.AvailabilityValue.NONE)) {
            if (enablementSupported) {
                decorationBuilder.append(",");
            }
            decorationBuilder.append(availability.toString());
        }
        return decorationBuilder.toString();
    }

    @Override
    protected String getFetchingName() {
        return "";
    }
}

