/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.properties;

import com.ibm.cics.core.ui.properties.IAttributePropertyDescriptor;
import com.ibm.cics.core.ui.properties.ITypedObjectPropertySource;
import com.ibm.cics.model.meta.IType;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractFilteredTypedObjectPropertySource
implements ITypedObjectPropertySource {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private ITypedObjectPropertySource delegate;
    private Map<Object, IAttributePropertyDescriptor> propertyDescriptorsMap;
    private IAttributePropertyDescriptor[] propertyDescriptors;

    public AbstractFilteredTypedObjectPropertySource(ITypedObjectPropertySource delegate) {
        this.delegate = delegate;
    }

    public Object getEditableValue() {
        return this.delegate.getEditableValue();
    }

    protected abstract boolean isVisible(IAttributePropertyDescriptor var1);

    protected abstract boolean isMutable(IAttributePropertyDescriptor var1);

    @Override
    public IAttributePropertyDescriptor[] getPropertyDescriptors() {
        if (this.propertyDescriptors == null) {
            IAttributePropertyDescriptor[] delegatePropertyDescriptors = this.delegate.getPropertyDescriptors();
            this.propertyDescriptorsMap = new HashMap<Object, IAttributePropertyDescriptor>();
            IAttributePropertyDescriptor[] iAttributePropertyDescriptorArray = delegatePropertyDescriptors;
            int n = delegatePropertyDescriptors.length;
            int n2 = 0;
            while (n2 < n) {
                IAttributePropertyDescriptor descriptor = iAttributePropertyDescriptorArray[n2];
                if (this.isVisible(descriptor)) {
                    if (!this.isMutable(descriptor)) {
                        descriptor = AbstractFilteredTypedObjectPropertySource.createImmutableAttributePropertyDescriptor(descriptor);
                    }
                    this.propertyDescriptorsMap.put(descriptor.getId(), descriptor);
                }
                ++n2;
            }
            this.propertyDescriptors = this.propertyDescriptorsMap.values().toArray(new IAttributePropertyDescriptor[this.propertyDescriptorsMap.size()]);
        }
        return this.propertyDescriptors;
    }

    public Object getPropertyValue(Object id) {
        if (this.propertyDescriptorsMap.containsKey(id)) {
            return this.delegate.getPropertyValue(id);
        }
        return null;
    }

    public boolean isPropertySet(Object id) {
        if (this.propertyDescriptorsMap.containsKey(id)) {
            return this.delegate.isPropertySet(id);
        }
        return false;
    }

    public void resetPropertyValue(Object id) {
        if (this.propertyDescriptorsMap.containsKey(id)) {
            this.delegate.resetPropertyValue(id);
        }
    }

    public void setPropertyValue(Object id, Object value) {
        if (this.propertyDescriptorsMap.containsKey(id)) {
            this.delegate.setPropertyValue(id, value);
        }
    }

    @Override
    public IType getObjectType() {
        return this.delegate.getObjectType();
    }

    private static IAttributePropertyDescriptor createImmutableAttributePropertyDescriptor(final IAttributePropertyDescriptor propertyDescriptor) {
        return (IAttributePropertyDescriptor)Proxy.newProxyInstance(propertyDescriptor.getClass().getClassLoader(), new Class[]{IAttributePropertyDescriptor.class}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if ("isMutable".equals(method.getName()) && args == null) {
                    return false;
                }
                try {
                    return method.invoke((Object)propertyDescriptor, args);
                }
                catch (InvocationTargetException ex) {
                    throw ex.getCause();
                }
            }
        });
    }
}

