/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.viewers;

import com.ibm.cics.core.model.IDescribable;
import com.ibm.cics.core.ui.UIPlugin;
import com.ibm.cics.core.ui.views.Messages;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IDecoratorManager;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.DeferredTreeContentManager;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.PendingUpdateAdapter;

public class CICSObjectTreeViewer {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private final TreeViewer viewer;

    public CICSObjectTreeViewer(TreeViewer viewer) {
        this(viewer, null);
    }

    public CICSObjectTreeViewer(TreeViewer viewer, IFilter childFilter) {
        this(viewer, childFilter, null);
    }

    public CICSObjectTreeViewer(TreeViewer viewer, IFilter childFilter, IFilter mayHaveChildrenFilter) {
        this.viewer = viewer;
        viewer.setContentProvider((IContentProvider)new ExplorerContentProvider(childFilter, mayHaveChildrenFilter));
        IDecoratorManager decoratorManager = PlatformUI.getWorkbench().getDecoratorManager();
        ILabelDecorator labelDecorator = decoratorManager.getLabelDecorator();
        DecoratingLabelProvider labelProvider = new DecoratingLabelProvider((ILabelProvider)new ExplorerLabelProvider(), labelDecorator);
        viewer.setLabelProvider((IBaseLabelProvider)labelProvider);
    }

    protected class ExplorerContentProvider
    implements ITreeContentProvider {
        private DeferredTreeContentManager manager;

        public ExplorerContentProvider() {
            this(null);
        }

        public ExplorerContentProvider(IFilter childFilter) {
            this(childFilter, null);
        }

        public ExplorerContentProvider(IFilter childFilter, IFilter mayHaveChildrenFilter) {
            this.manager = childFilter == null ? new DeferredTreeContentManager((AbstractTreeViewer)CICSObjectTreeViewer.this.viewer) : new FilteredDeferredTreeContentManager(CICSObjectTreeViewer.this.viewer, childFilter, mayHaveChildrenFilter);
        }

        public Object[] getChildren(Object parentElement) {
            return this.manager.getChildren(parentElement);
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return this.manager.mayHaveChildren(element);
        }

        public Object[] getElements(Object inputElement) {
            return this.manager.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (oldInput != null) {
                this.manager.cancel(oldInput);
            }
        }
    }

    protected class ExplorerLabelProvider
    extends CellLabelProvider
    implements ILabelProvider {
        protected ExplorerLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof PendingUpdateAdapter) {
                return Messages.getString("pending", new Object[0]);
            }
            IDeferredWorkbenchAdapter adapter = this.getAdapter(element);
            if (adapter != null) {
                return adapter.getLabel(element);
            }
            return element.toString();
        }

        public Image getImage(Object element) {
            if (element instanceof PendingUpdateAdapter) {
                return UIPlugin.getImage(UIPlugin.IMGD_WAITING);
            }
            Image image = null;
            IDeferredWorkbenchAdapter adapter = this.getAdapter(element);
            if (adapter != null) {
                image = UIPlugin.getImage(adapter.getImageDescriptor(element));
            }
            return image;
        }

        private IDeferredWorkbenchAdapter getAdapter(Object adaptable) {
            String adapterTypeName = IDeferredWorkbenchAdapter.class.getName();
            IDeferredWorkbenchAdapter adapter = (IDeferredWorkbenchAdapter)Platform.getAdapterManager().loadAdapter(adaptable, adapterTypeName);
            return adapter;
        }

        public String getToolTipText(Object element) {
            if (element instanceof IDescribable) {
                return ((IDescribable)element).getDescription();
            }
            return super.getToolTipText(element);
        }

        public Point getToolTipShift(Object object) {
            return new Point(5, 10);
        }

        public int getToolTipDisplayDelayTime(Object object) {
            return 500;
        }

        public int getToolTipTimeDisplayed(Object object) {
            return 5000;
        }

        public void update(ViewerCell cell) {
            cell.setText(this.getText(cell.getElement()));
            cell.setImage(this.getImage(cell.getElement()));
        }
    }

    private static class FilteredDeferredTreeContentManager
    extends DeferredTreeContentManager {
        private IFilter childFilter;
        private final IFilter mayHaveChildrenFilter;

        public FilteredDeferredTreeContentManager(TreeViewer viewer, IFilter childFilter, IFilter mayHaveChildrenFilter) {
            super((AbstractTreeViewer)viewer);
            this.childFilter = childFilter;
            this.mayHaveChildrenFilter = mayHaveChildrenFilter;
        }

        public boolean mayHaveChildren(Object element) {
            return this.mayHaveChildrenFilter == null || this.mayHaveChildrenFilter.select(element) ? super.mayHaveChildren(element) : false;
        }

        protected void addChildren(Object parent, Object[] children, IProgressMonitor monitor) {
            super.addChildren(parent, this.filterNoPermission(children), monitor);
        }

        private Object[] filterNoPermission(Object[] elements) {
            if (this.childFilter != null) {
                ArrayList<Object> filteredElements = new ArrayList<Object>();
                Object[] objectArray = elements;
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    if (this.childFilter.select(object)) {
                        filteredElements.add(object);
                    }
                    ++n2;
                }
                return filteredElements.toArray();
            }
            return elements;
        }
    }
}

