/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.viewers;

import com.ibm.cics.common.util.CNXCode;
import com.ibm.cics.core.model.CICSSystemManagerException;
import com.ibm.cics.core.model.IModelListener;
import com.ibm.cics.core.model.IResourcesModel;
import com.ibm.cics.core.model.ModelStatus;
import com.ibm.cics.core.model.UnsupportedTypeException;
import com.ibm.cics.core.ui.Debug;
import com.ibm.cics.core.ui.ExceptionMessageHelper;
import com.ibm.cics.core.ui.Messages;
import com.ibm.cics.core.ui.UIPlugin;
import com.ibm.cics.core.ui.views.ResourcesTable;
import com.ibm.cics.core.ui.views.ResourcesViewJobs;
import com.ibm.cics.eclipse.common.ViewHelper;
import com.ibm.cics.eclipse.common.ops.OperationUtils;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.IDefinitionContext;
import com.ibm.cics.sm.comm.IFilteredContext;
import com.ibm.cics.sm.comm.IScopedContext;
import com.ibm.cics.sm.comm.SystemManagerConnectionException;
import com.ibm.cics.sm.comm.context.IAssociationContext;
import com.ibm.icu.text.DateFormat;
import com.ibm.icu.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.viewers.ILazyContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;

public class ResourcesTableContentProvider
implements ILazyContentProvider,
IModelListener {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private final ResourcesTable resourcesTable;
    protected IResourcesModel model;
    protected int lastTopIndex = -1;
    protected int lastBottomIndex = -1;
    protected DateFormat dateTimeFormat = SimpleDateFormat.getDateTimeInstance();
    private static final Logger logger = Logger.getLogger(ResourcesTableContentProvider.class.getPackage().getName());
    private static final com.ibm.cics.common.util.Debug debug = new com.ibm.cics.common.util.Debug(ResourcesTableContentProvider.class);

    public ResourcesTableContentProvider(ResourcesTable resourcesTable, ICICSType<?> type) {
        this(resourcesTable);
    }

    public ResourcesTableContentProvider(ResourcesTable resourcesTable) {
        this.resourcesTable = resourcesTable;
    }

    public void refresh() {
        Debug.enter((Logger)logger, (String)ResourcesTableContentProvider.class.getName(), (String)"refresh", (Object)this);
        if (this.model != null) {
            this.lastTopIndex = -1;
            this.lastBottomIndex = -1;
            this.resourcesTable.getTableViewer().getTable().removeAll();
            this.maybeFetch(true);
        }
        Debug.exit((Logger)logger, (String)ResourcesTableContentProvider.class.getName(), (String)"refresh");
    }

    private void refreshSelection() {
        ISelection selection = this.resourcesTable.getTableViewer().getSelection();
        Debug.event((Logger)logger, (String)ResourcesTableContentProvider.class.getName(), (String)"refreshSelection", (Object)this, (Object)selection);
        if (!selection.isEmpty()) {
            this.resourcesTable.getTableViewer().setSelection(selection);
        }
    }

    public void updateElement(int index) {
        if (this.model != null) {
            ICICSObject object;
            if (index < this.model.size() && (object = this.model.get(index)) != null) {
                this.resourcesTable.getTableViewer().replace((Object)object, index);
            }
            this.maybeFetch(false);
        }
    }

    public void dispose() {
        Debug.enter((Logger)logger, (String)ResourcesTableContentProvider.class.getName(), (String)"dispose", (Object)this);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        ResourcesViewJobs.ResourcesModelJob job;
        Debug.enter((Logger)logger, (String)ResourcesTableContentProvider.class.getName(), (String)"inputChanged", (Object)this, (Object)viewer, (Object)oldInput, (Object)newInput);
        if (this.model != null) {
            IResourcesModel model = this.model;
            this.model = null;
            model.removeListener((IModelListener)this);
            this.resourcesTable.getTableViewer().getTable().removeAll();
            this.lastTopIndex = -1;
            this.lastBottomIndex = -1;
            job = new ResourcesViewJobs.DisposeJob(model);
            Debug.event((Logger)logger, (String)ResourcesTableContentProvider.class.getName(), (String)"inputChanged", (Object)((Object)job));
            this.schedule(job);
            this.resourcesTable.setContentDescription(com.ibm.cics.core.ui.views.Messages.getString("ResourcesView.status.disconnected", new Object[0]));
        }
        if (newInput != null) {
            IResourcesModel newModel;
            this.resourcesTable.setContentDescription(com.ibm.cics.core.ui.views.Messages.getString("ResourcesView.status.connecting", new Object[0]));
            this.model = newModel = (IResourcesModel)newInput;
            this.model.addListener((IModelListener)this);
            job = new ResourcesViewJobs.ActivateJob(this.model);
            Debug.event((Logger)logger, (String)ResourcesTableContentProvider.class.getName(), (String)"inputChanged", (Object)((Object)job));
            job.setUser(false);
            this.schedule(job);
        } else {
            this.model = null;
        }
        Debug.exit((Logger)logger, (String)ResourcesTableContentProvider.class.getName(), (String)"inputChanged");
    }

    private void schedule(ResourcesViewJobs.ResourcesModelJob job) {
        job.setRule(new ResourcesTableContentProviderSchedulingRule(job.getModel()));
        IWorkbenchPartSite site = this.resourcesTable.getSite();
        if (site != null) {
            IWorkbenchSiteProgressService siteService = (IWorkbenchSiteProgressService)site.getAdapter(IWorkbenchSiteProgressService.class);
            siteService.schedule((Job)job, 0L, true);
        } else {
            job.schedule();
        }
    }

    public void contentsChanged(final int firstIndex, final int lastIndex) {
        Debug.enter((Logger)logger, (String)ResourcesTableContentProvider.class.getName(), (String)"contentsChanged", (Object)this, (Object)firstIndex, (Object)lastIndex);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!ResourcesTableContentProvider.this.resourcesTable.getTableViewer().getTable().isDisposed()) {
                    int[] indices = ResourcesTableContentProvider.this.resourcesTable.getTableViewer().getTable().getSelectionIndices();
                    Debug.event((Logger)logger, (String)ResourcesTableContentProvider.class.getName(), (String)"contentsChanged", (Object)indices);
                    int i = firstIndex;
                    while (i <= lastIndex) {
                        try {
                            ICICSObject object = ResourcesTableContentProvider.this.model.get(i);
                            ResourcesTableContentProvider.this.resourcesTable.getTableViewer().replace((Object)object, i);
                        }
                        catch (Exception e) {
                            if (!Debug.DEBUG_RESOURCES) break;
                            logger.log(Level.SEVERE, "tableViewer.replace failed at index " + i, e);
                            break;
                        }
                        ++i;
                    }
                    ResourcesTableContentProvider.this.refreshSelection();
                }
            }
        });
        Debug.exit((Logger)logger, (String)ResourcesTableContentProvider.class.getName(), (String)"contentsChanged");
    }

    public void contentsInvalid() {
        Debug.enter((Logger)logger, (String)ResourcesTableContentProvider.class.getName(), (String)"contentsInvalid", (Object)this);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ResourcesTableContentProvider.this.refresh();
            }
        });
        Debug.exit((Logger)logger, (String)ResourcesTableContentProvider.class.getName(), (String)"contentsInvalid");
    }

    public void contentsRemoved(final ICICSObject element) {
        debug.enter("contentsRemoved", (Object)this, (Object)element);
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                ResourcesTableContentProvider.this.resourcesTable.getTableViewer().remove((Object)element);
                ISelection selection = ResourcesTableContentProvider.this.resourcesTable.getTableViewer().getSelection();
                if (selection instanceof IStructuredSelection) {
                    IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                    LinkedList selectedElements = new LinkedList(structuredSelection.toList());
                    debug.event("contentsRemoved", selectedElements);
                    selectedElements.remove(element);
                    ResourcesTableContentProvider.this.resourcesTable.getTableViewer().setSelection((ISelection)new StructuredSelection(selectedElements));
                }
            }
        });
        debug.exit("contentsRemoved");
    }

    public void exceptionOccured(Exception exception) {
        Debug.enter((Logger)logger, (String)ResourcesTableContentProvider.class.getName(), (String)"exceptionOccured", (Object)this, (Object)exception);
        IStatus errorStatus = this.createErrorStatus(exception);
        ICICSType<?> iType = this.resourcesTable.getElementTypeService().getElementType();
        String tableDescription = iType.toString();
        if (iType instanceof ICICSType) {
            tableDescription = Messages.getTableDescription(iType.getResourceTableName());
        }
        String contextDescription = ExceptionMessageHelper.getContextOrScopeNameFor(this.model.getContext());
        String message = OperationUtils.getOperationFailureDescription((String)CNXCode.getCNXError((int)623), (String)com.ibm.cics.core.ui.views.Messages.getString("ResourcesView.get.description", tableDescription, contextDescription));
        MultiStatus wrappedStatus = new MultiStatus("com.ibm.cics.core.ui", 0, new IStatus[]{errorStatus}, message, null);
        Display.getDefault().asyncExec(new Runnable((IStatus)wrappedStatus, errorStatus){
            private final /* synthetic */ IStatus val$wrappedStatus;
            private final /* synthetic */ IStatus val$errorStatus;
            {
                this.val$wrappedStatus = iStatus;
                this.val$errorStatus = iStatus2;
            }

            @Override
            public void run() {
                ViewHelper.log((IStatus)this.val$wrappedStatus);
                IStatusLineManager statusLine = ResourcesTableContentProvider.this.resourcesTable.getStatusLineManager();
                if (statusLine != null) {
                    statusLine.setErrorMessage(null);
                    statusLine.setErrorMessage(UIPlugin.getImage(UIPlugin.IMGD_ERROR), this.val$errorStatus.getMessage());
                }
                ResourcesTableContentProvider.this.resourcesTable.setContentDescription(this.val$errorStatus.getMessage());
            }
        });
        Debug.exit((Logger)logger, (String)ResourcesTableContentProvider.class.getName(), (String)"exceptionOccured");
    }

    @Deprecated
    protected IStatus createErrorStatus(Exception exception, ICICSType<?> type) {
        return this.createErrorStatus(exception);
    }

    protected IStatus createErrorStatus(Exception exception) {
        String message = null;
        if (exception instanceof CICSSystemManagerException && exception.getCause() instanceof SystemManagerConnectionException) {
            SystemManagerConnectionException wrappedException = (SystemManagerConnectionException)exception.getCause();
            if (1335 == wrappedException.getReason() && 1035 == wrappedException.getResponse()) {
                if (this.model != null) {
                    String resourceTableName = this.model.getResourceName();
                    message = com.ibm.cics.core.ui.views.Messages.getString("ResourcesView.error.csd.unsupported", resourceTableName);
                }
            } else if (1041 == wrappedException.getResponse() && 1299 == wrappedException.getReason()) {
                message = com.ibm.cics.core.ui.views.Messages.getString("ResourcesView.error.filter", new Object[0]);
            }
        } else if (exception instanceof UnsupportedTypeException) {
            String resourceTableName = ((UnsupportedTypeException)exception).getResourceTableName();
            String displayName = Messages.getTableDescription(resourceTableName);
            message = com.ibm.cics.core.ui.views.Messages.getString("ResourcesView.error.unsupported", displayName, resourceTableName);
        }
        if (message == null) {
            if (exception.getCause() instanceof SystemManagerConnectionException) {
                return ExceptionMessageHelper.getStatus((SystemManagerConnectionException)exception.getCause(), this.resourcesTable.getElementTypeService().getElementType(), 2);
            }
            Object[] inserts = new Object[]{exception.getMessage()};
            message = com.ibm.cics.core.ui.views.Messages.getString("ResourcesView.error", inserts);
            return new Status(2, "com.ibm.cics.core.ui", message);
        }
        return new Status(2, "com.ibm.cics.core.ui", message);
    }

    public void sizeChanged(final int newSize, int newTotalSize) {
        Debug.enter((Logger)logger, (String)ResourcesTableContentProvider.class.getName(), (String)"sizeChanged", (Object)this, (Object)newSize, (Object)newTotalSize);
        IResourcesModel localModel = this.model;
        if (localModel != null) {
            IResourcesModel model = localModel;
            final String description = this.getDescription(newSize, model);
            Debug.event((Logger)logger, (String)ResourcesTableContentProvider.class.getName(), (String)"sizeChanged", (Object)description);
            final String errorMessage = this.getErrorMessage(newSize, model);
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    ResourcesTableContentProvider.this.resourcesTable.setContentDescription(errorMessage != null ? errorMessage : description);
                    if (!ResourcesTableContentProvider.this.resourcesTable.getTableViewer().getTable().isDisposed()) {
                        ResourcesTableContentProvider.this.resourcesTable.getTableViewer().setItemCount(newSize);
                    }
                    IStatusLineManager statusLine = ResourcesTableContentProvider.this.resourcesTable.getStatusLineManager();
                    if (errorMessage != null) {
                        if (statusLine != null) {
                            statusLine.setErrorMessage(errorMessage);
                        }
                        MultiStatus operationStatus = new MultiStatus("com.ibm.cics.core.ui", -1, description, null);
                        operationStatus.add((IStatus)new Status(2, "com.ibm.cics.core.ui", errorMessage));
                        UIPlugin.log((IStatus)operationStatus);
                    } else if (statusLine != null) {
                        statusLine.setErrorMessage(null);
                    }
                }
            });
        }
        Debug.exit((Logger)logger, (String)ResourcesTableContentProvider.class.getName(), (String)"sizeChanged");
    }

    private String getErrorMessage(int newSize, IResourcesModel model) {
        String errorMessage = model.getStatus().equals(ModelStatus.UNSUPPORTED) ? com.ibm.cics.core.ui.views.Messages.getString("ResourcesView.error.unsupported", model.getResourceName()) : (model.getStatus().equals(ModelStatus.LIMITED) ? com.ibm.cics.core.ui.views.Messages.getString("ResourcesView.error.threshold", newSize) : null);
        return errorMessage;
    }

    private String getDescription(int newSize, IResourcesModel model) {
        Date now = new Date();
        String dateString = this.dateTimeFormat.format(now);
        String filtered = "";
        if (model.getContext() instanceof IFilteredContext) {
            filtered = com.ibm.cics.core.ui.views.Messages.getString("ResourcesTableContentProvider.ResourcesView.status.content.filtered", new Object[0]);
        }
        String description = com.ibm.cics.core.ui.views.Messages.getString("ResourcesView.status.content", this.getContextName(), model.getResourceName(), new Integer(newSize), filtered, dateString);
        return description;
    }

    private String getContextName() {
        String contextName = null;
        IContext context = this.model.getContext();
        if (context instanceof IFilteredContext && ((IFilteredContext)context).getParentContext() instanceof IDefinitionContext) {
            contextName = ((IDefinitionContext)((IFilteredContext)context).getParentContext()).getResourceGroup();
        } else if (context instanceof IAssociationContext) {
            contextName = ((IAssociationContext)context).getResourceName();
        } else if (context instanceof IDefinitionContext) {
            contextName = ((IDefinitionContext)context).getResourceGroup();
        } else if (context instanceof IScopedContext) {
            contextName = ((IScopedContext)context).getScope();
        }
        if (contextName == null) {
            contextName = context.getContext();
        }
        return contextName;
    }

    private void maybeFetch(boolean reactivate) {
        int topIndex = this.resourcesTable.getTableViewer().getTable().getTopIndex();
        int bottomIndex = this.getPageSize();
        int count = 3 * bottomIndex - 2;
        if (topIndex != this.lastTopIndex || bottomIndex != this.lastBottomIndex) {
            this.lastTopIndex = topIndex;
            this.lastBottomIndex = bottomIndex;
            ResourcesViewJobs.GetJob getJob = new ResourcesViewJobs.GetJob(this.model, reactivate, topIndex, count);
            this.schedule(getJob);
        }
    }

    protected int getPageSize() {
        Table table = this.resourcesTable.getTableViewer().getTable();
        int height = table.getSize().y;
        int itemHeight = table.getItemHeight();
        return (height + itemHeight - 1) / itemHeight;
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[" + this.model + "]";
    }

    private static class ResourcesTableContentProviderSchedulingRule
    implements ISchedulingRule {
        private final IResourcesModel model;

        public ResourcesTableContentProviderSchedulingRule(IResourcesModel model) {
            this.model = model;
        }

        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return rule instanceof ResourcesTableContentProviderSchedulingRule && ((ResourcesTableContentProviderSchedulingRule)rule).model == this.model;
        }
    }
}

