/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.sm.comm.sm.internal;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.sm.comm.ICICSAction;
import com.ibm.cics.sm.comm.ICICSOperation;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.IGenResourceTables;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import com.ibm.cics.sm.comm.sm.SMRecord;
import com.ibm.cics.sm.comm.sm.SMResponse;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class VSEConnectionBehaviour
implements IGenResourceTables {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(VSEConnectionBehaviour.class);
    private static final String[] CICSRGN_UNSUPPORTED_ATTRIBUTES = new String[]{"CURAUXDS", "GTFSTATUS", "LOADHWMC", "LOADHWMW", "LOADPNIU", "LOADREQS", "LOADRNIU", "LOADTIME", "LOADTNIU", "LOADWAIT", "LOADWCNT", "MVSSYSID", "MVSSYSNAME", "PAGEIN", "PAGEOUT", "PLASTRESET", "PRGMRCMP", "PRGMUCNT", "PRGMWAIT", "RDEBRBLD", "REALSTG", "SDMPSUPP", "SDMPTOTL", "TCEXITSTATUS", "TDMPSUPP", "VTMACBDOPE", "VTMRPLMAX", "VTMRPLPOST", "VTMSOSCNT"};
    private static final String[] CONNECT_UNSUPPORTED_ATTRIBUTES = new String[]{"EXITTRACING", "MAXPRIMARIES"};
    private static final String[] LOCFILE_UNSUPPORTED_ATTRIBUTES = new String[]{"DISPOSITION", "TIMECLOSE", "TIMEOPEN"};
    private static final String[] REMFILE_UNSUPPORTED_ATTRIBUTES = new String[]{"ENABLESTATUS", "CHANGEUSRID", "CHANGEAGENT", "CHANGEAGREL", "INSTALLAGENT", "CHANGETIME", "DEFINESOURCE", "DEFINETIME", "INSTALLUSRID", "INSTALLTIME", "BASDEFINEVER"};
    private static final String[] REMTDQ_UNSUPPORTED_ATTRIBUTES = new String[]{"CHANGEUSRID", "CHANGEAGENT", "CHANGEAGREL", "INSTALLAGENT", "CHANGETIME", "DEFINESOURCE", "DEFINETIME", "INSTALLUSRID", "INSTALLTIME", "BASDEFINEVER"};
    private static final String[] REMTRAN_UNSUPPORTED_ATTRIBUTES = new String[]{"REMSTARTCNT", "CHANGEUSRID", "CHANGEAGENT", "CHANGEAGREL", "INSTALLAGENT", "CHANGETIME", "DEFINESOURCE", "DEFINETIME", "INSTALLUSRID", "INSTALLTIME", "BASDEFINEVER"};
    private static final String[] TASK_UNSUPPORTED_ATTRIBUTES = new String[]{"BTECOMP", "CDSAGETM", "CDSAPSHWM", "CDSASHWM", "CDSASOCC", "DETTRANTYPE", "ECDSAGETM", "ECDSAPSHWM", "ECDSASHWM", "ECDSASOCC", "EXECOMP", "EXWAIT", "INDOUBT", "INDOUBTMINS", "INDOUBTWAIT", "INDOUBTFAIL", "LUNAME", "ORIGINTYPE", "PCLOADTM", "PSTG24HWM", "PSTG31HWM", "RECTYPE", "RESOLVEACT", "ROFAIL", "ROPS31HWM", "SHUNTED", "SUBEXECOMP", "TDIOTIME", "TERMID", "UNSHUNTED", "USRPS24HWM", "USRPS31HWM", "USTG31CNT", "USTG31HWM", "USTG31OCC", "WAITTIME", "WLMSRVCNAME", "WLMRPTRCNAME"};
    private static final String[] TRMNL_UNSUPPORTED_ATTRIBUTES = new String[]{"EXITTRACING", "PMSGCNT", "PMSGCONSEC", "PMSGGRPCNT", "POLLCNT", "STGVCNT", "TCAMCONTROL", "TRACING"};
    protected Map<String, String[]> vseUnsupportedAttributesByResource = new HashMap<String, String[]>();
    protected Map<String, String[]> vseSupportedActionsByResource = new HashMap<String, String[]>();
    protected List<String> vseSupportedDeleteResources = new ArrayList<String>();

    public VSEConnectionBehaviour() {
        this.setUpCommonUnsupportedAttributesByResource();
    }

    private void setUpCommonUnsupportedAttributesByResource() {
        this.vseUnsupportedAttributesByResource.put("CICSRGN", CICSRGN_UNSUPPORTED_ATTRIBUTES);
        this.vseUnsupportedAttributesByResource.put("CONNECT", CONNECT_UNSUPPORTED_ATTRIBUTES);
        this.vseUnsupportedAttributesByResource.put("LOCFILE", LOCFILE_UNSUPPORTED_ATTRIBUTES);
        this.vseUnsupportedAttributesByResource.put("REMFILE", REMFILE_UNSUPPORTED_ATTRIBUTES);
        this.vseUnsupportedAttributesByResource.put("REMTDQ", REMTDQ_UNSUPPORTED_ATTRIBUTES);
        this.vseUnsupportedAttributesByResource.put("REMTRAN", REMTRAN_UNSUPPORTED_ATTRIBUTES);
        this.vseUnsupportedAttributesByResource.put("TASK", TASK_UNSUPPORTED_ATTRIBUTES);
        this.vseUnsupportedAttributesByResource.put("TERMNL", TRMNL_UNSUPPORTED_ATTRIBUTES);
    }

    public boolean checkOperation(String resourceType, IContext context, ICICSOperation operation) {
        debug.enter("checkOperation", (Object)this, (Object)resourceType, (Object)context, (Object)operation);
        boolean supported = false;
        debug.exit("checkOperation", (Object)supported);
        return supported;
    }

    protected boolean checkPerformOperation(String resourceType, IContext context, ICICSOperation operation) {
        debug.enter("checkPerformOperation", (Object)this, (Object)resourceType, (Object)context, (Object)operation);
        boolean result = false;
        if (operation instanceof ICICSAction && this.vseSupportedActionsByResource.containsKey(resourceType)) {
            String[] supportedOperations;
            ICICSAction action = (ICICSAction)operation;
            String operationName = action.getActionName();
            String[] stringArray = supportedOperations = this.vseSupportedActionsByResource.get(resourceType);
            int n = supportedOperations.length;
            int n2 = 0;
            while (n2 < n) {
                String supportedOperation = stringArray[n2];
                if (supportedOperation.equals(operationName)) {
                    result = true;
                    break;
                }
                ++n2;
            }
        }
        debug.exit("checkPerformOperation", (Object)result);
        return result;
    }

    protected boolean checkDeleteOperation(String resourceType) {
        debug.enter("checkDeleteOperation", (Object)this, (Object)resourceType);
        boolean result = this.vseSupportedDeleteResources.contains(resourceType);
        debug.exit("checkDeleteOperation", (Object)result);
        return result;
    }

    public String getActions(String resourceName, IContext context) {
        debug.enter("getActions", (Object)this);
        String actions = "";
        debug.exit("getActions", (Object)actions);
        return actions;
    }

    public void modifyRecords(SMResponse response) {
        String resourceType = response.getResourceType();
        int index = 0;
        while (index < response.getRecordCount()) {
            SMConnectionRecord record = response.getRecord(index);
            if (record instanceof SMRecord && this.vseUnsupportedAttributesByResource.containsKey(resourceType)) {
                VSEConnectionBehaviour.forceRecordAttributesUnsupported((SMRecord)record, this.vseUnsupportedAttributesByResource.get(resourceType));
            }
            ++index;
        }
    }

    private static void forceRecordAttributesUnsupported(SMRecord record, String[] unsupportedForVSE) {
        String[] stringArray = unsupportedForVSE;
        int n = unsupportedForVSE.length;
        int n2 = 0;
        while (n2 < n) {
            String fieldName = stringArray[n2];
            record.put(fieldName, "FORCE_ATTRIBUTE_UNSUPPORTED");
            ++n2;
        }
    }
}

