/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.comm;

import com.ibm.cics.common.util.Debug;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

class SSLProtocolEnablerDecorator
extends SSLSocketFactory {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EXP (c) Copyright IBM Corp. 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private final SSLSocketFactory sslSocketFactory;
    private boolean enableProtocols;
    private static final Debug debug = new Debug(SSLProtocolEnablerDecorator.class);

    SSLProtocolEnablerDecorator(SSLSocketFactory sslSocketFactory, boolean enableProtocols) {
        this.sslSocketFactory = sslSocketFactory;
        this.enableProtocols = enableProtocols;
    }

    @Override
    public Socket createSocket(Socket arg0, String arg1, int arg2, boolean arg3) throws IOException {
        SSLSocket socket = (SSLSocket)this.sslSocketFactory.createSocket(arg0, arg1, arg2, arg3);
        if (this.enableProtocols) {
            socket.setEnabledProtocols(SSLProtocolEnablerDecorator.addMissingProtocols(socket.getEnabledProtocols(), "TLSv1", "TLSv1.1", "TLSv1.2"));
            debug.event("setUpSSlContextAndInitialiseHostnameVerifier.SSLSocketFactory.createSocket", SSLProtocolEnablerDecorator.getPrintableEnabledProtocols(socket));
        }
        return socket;
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.sslSocketFactory.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.sslSocketFactory.getSupportedCipherSuites();
    }

    @Override
    public Socket createSocket(String arg0, int arg1) throws IOException, UnknownHostException {
        return this.sslSocketFactory.createSocket(arg0, arg1);
    }

    @Override
    public Socket createSocket(InetAddress arg0, int arg1) throws IOException {
        return this.sslSocketFactory.createSocket(arg0, arg1);
    }

    @Override
    public Socket createSocket(String arg0, int arg1, InetAddress arg2, int arg3) throws IOException, UnknownHostException {
        return this.sslSocketFactory.createSocket(arg0, arg1, arg2, arg3);
    }

    @Override
    public Socket createSocket(InetAddress arg0, int arg1, InetAddress arg2, int arg3) throws IOException {
        return this.sslSocketFactory.createSocket(arg0, arg1, arg2, arg3);
    }

    private static String getPrintableEnabledProtocols(SSLSocket socket) {
        StringBuffer sb = new StringBuffer();
        sb.append("Enabled protocols for this socket: [");
        String[] stringArray = socket.getEnabledProtocols();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String pro = stringArray[n2];
            sb.append(String.valueOf(pro) + ", ");
            ++n2;
        }
        sb.append("]");
        return sb.toString();
    }

    private static String[] addMissingProtocols(String[] currentProtocols, String ... additionalProtocols) {
        ArrayList<String> protocols = new ArrayList<String>(Arrays.asList(currentProtocols));
        String[] stringArray = additionalProtocols;
        int n = additionalProtocols.length;
        int n2 = 0;
        while (n2 < n) {
            String protocol = stringArray[n2];
            if (!protocols.contains(protocol)) {
                protocols.add(protocol);
            }
            ++n2;
        }
        return protocols.toArray(new String[0]);
    }
}

