/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.sm.comm;

import com.ibm.cics.common.CICSRelease;
import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.comm.AbstractConnection;
import com.ibm.cics.core.comm.ConnectionConfiguration;
import com.ibm.cics.core.comm.ConnectionException;
import com.ibm.cics.core.comm.ExplorerSecurityHelper;
import com.ibm.cics.sm.comm.ICICSAction;
import com.ibm.cics.sm.comm.ICICSOperation;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.IFilteredContext;
import com.ibm.cics.sm.comm.IOrderedContext;
import com.ibm.cics.sm.comm.IScopedContext;
import com.ibm.cics.sm.comm.ISystemManagerConnection;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import com.ibm.cics.sm.comm.SMConnectionResponse;
import com.ibm.cics.sm.comm.SystemManagerConnectionException;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import javax.net.ssl.SSLContext;

public abstract class AbstractSystemManagerConnection
extends AbstractConnection
implements ISystemManagerConnection {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String CONNECTION_CONFIG_READ_TIMEOUT = "READ_TIMEOUT";
    protected boolean ssl;
    private CICSRelease modelVersion = CICSRelease.e690;
    private SSLContext sslContext;
    private static final String ESCAPED_CHARS = " $@#%&?!:=+\u00a2\u00ac";
    private static final Debug debug = new Debug(AbstractSystemManagerConnection.class);

    protected AbstractSystemManagerConnection() {
        this(false);
    }

    protected AbstractSystemManagerConnection(boolean secure) {
        this.ssl = secure;
    }

    protected boolean isCICSVersionSupported(CICSRelease release) {
        return release != null && this.modelVersion.compareTo((Enum)release) >= 0 && release.compareTo((Enum)CICSRelease.e640) >= 0;
    }

    public void setConfiguration(ConnectionConfiguration connectionConfiguration) {
        super.setConfiguration(connectionConfiguration);
        if (connectionConfiguration != null) {
            this.ssl = connectionConfiguration.getSecureHint();
            debug.event("setConfiguration", (Object)this, (Object)this.ssl);
        }
    }

    public void connect() throws ConnectionException {
        throw new UnsupportedOperationException(this.toString());
    }

    @Override
    public SMConnectionResponse create(String resourceType, IContext context, SMConnectionRecord record) throws ConnectionException {
        throw new UnsupportedOperationException(this.toString());
    }

    @Override
    public SMConnectionResponse install(String resourceType, IFilteredContext definition, IScopedContext target) throws ConnectionException {
        throw new UnsupportedOperationException(this.toString());
    }

    @Override
    public SMConnectionResponse add(String resourceType, IFilteredContext definition, IFilteredContext group) throws ConnectionException {
        throw new UnsupportedOperationException("add");
    }

    @Override
    public SMConnectionResponse remove(String resourceType, IFilteredContext definition, IFilteredContext group) throws SystemManagerConnectionException {
        throw new UnsupportedOperationException("remove");
    }

    @Override
    public SMConnectionResponse get(String resourceType, String context, String scope) throws ConnectionException {
        throw new UnsupportedOperationException(this.toString());
    }

    @Override
    public SMConnectionResponse get(String resourceType, IContext context) throws ConnectionException {
        if (context instanceof IScopedContext) {
            IScopedContext scopedContext = (IScopedContext)context;
            return this.get(resourceType, scopedContext.getContext(), scopedContext.getScope());
        }
        return this.get(resourceType, context.getContext(), context.getContext());
    }

    @Override
    public SMConnectionResponse fetch(String stub, int position, int count) throws ConnectionException {
        throw new UnsupportedOperationException(this.toString());
    }

    @Override
    public SMConnectionResponse getResources(String resourceName, String context, String scope) throws ConnectionException {
        throw new UnsupportedOperationException(this.toString());
    }

    @Override
    public SMConnectionResponse getResources(String resourceName, IContext context) throws ConnectionException {
        if (context instanceof IScopedContext) {
            IScopedContext scopedContext = (IScopedContext)context;
            return this.getResources(resourceName, scopedContext.getContext(), scopedContext.getScope());
        }
        return this.getResources(resourceName, context.getContext(), context.getContext());
    }

    @Override
    public void discard(String stub) throws ConnectionException {
        throw new UnsupportedOperationException(this.toString());
    }

    @Override
    public SMConnectionResponse update(String resourceType, IContext context, SMConnectionRecord record) throws ConnectionException {
        throw new UnsupportedOperationException(this.toString());
    }

    @Override
    public SMConnectionResponse perform(String resourceType, IContext context, ICICSAction action) throws SystemManagerConnectionException, ConnectionException {
        throw new UnsupportedOperationException(action.getActionName());
    }

    @Override
    public SMConnectionResponse delete(String resourceType, IContext context) throws SystemManagerConnectionException {
        throw new UnsupportedOperationException(this.toString());
    }

    public void disconnect() throws ConnectionException {
        throw new UnsupportedOperationException(this.toString());
    }

    @Override
    public String getServerApplID() {
        throw new UnsupportedOperationException(this.toString());
    }

    @Override
    public String getVersion() {
        return "";
    }

    public boolean isConnected() {
        throw new UnsupportedOperationException(this.toString());
    }

    public boolean isSecure() {
        return this.getConfiguration() != null ? this.getConfiguration().getSecureHint() : this.ssl;
    }

    @Override
    public String getActions(String resourceName, IContext context) {
        return "read";
    }

    @Override
    public boolean checkOperation(String resourceType, IContext context, ICICSOperation operation) {
        boolean supported;
        debug.enter("checkOperation", (Object)this, (Object)resourceType, (Object)context, (Object)operation);
        String actions = this.getActions(resourceType, context);
        switch (operation.getOperationType()) {
            case CREATE: {
                supported = actions.indexOf("create") != -1;
                break;
            }
            case GET: {
                supported = actions.indexOf("read") != -1;
                break;
            }
            case UPDATE: {
                supported = actions.indexOf("update") != -1;
                break;
            }
            case DELETE: {
                supported = actions.indexOf("delete") != -1;
                break;
            }
            case PERFORM: {
                supported = actions.indexOf("perform") != -1;
                break;
            }
            default: {
                supported = false;
            }
        }
        if (context instanceof IOrderedContext) {
            supported = false;
        }
        debug.exit("checkOperation", (Object)supported);
        return supported;
    }

    protected URL createURL(String file) throws MalformedURLException {
        URL url = new URL(this.isSecure() ? "https" : "http", this.getConfiguration().getHost(), this.getConfiguration().getPort(), file);
        debug.event("createURL", (Object)url);
        return url;
    }

    protected HttpURLConnection openConnection(URL url) throws IOException {
        debug.enter("openConnection", (Object)this, (Object)url);
        if (this.isSecure() && this.sslContext == null) {
            this.sslContext = ExplorerSecurityHelper.setUpSSlContextAndInitialiseHostnameVerifier((String)this.getConfiguration().getName(), (String)this.getConfiguration().getHost());
        }
        HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
        debug.exit("openConnection", (Object)urlConnection);
        return urlConnection;
    }

    @Deprecated
    protected boolean isCICSDefinition(String resourceType) {
        boolean result = false;
        String fieldName = "DEFINITION_" + resourceType;
        try {
            this.getClass().getField(fieldName);
            result = true;
        }
        catch (Exception exception) {}
        return result;
    }

    protected static String escape(String in) {
        StringBuffer out = new StringBuffer();
        int i = 0;
        while (i < in.length()) {
            char ch = in.charAt(i);
            int index = ESCAPED_CHARS.indexOf(ch);
            if (index != -1) {
                out.append("%").append(Integer.toString(ch, 16).toUpperCase(Locale.ENGLISH));
            } else {
                out.append(ch);
            }
            ++i;
        }
        return out.toString();
    }

    protected static String formatVersionAsCICSTSLevel(String input) throws ConnectionException {
        if (input == null || input.length() != 4) {
            throw new ConnectionException("Unexpected version format : '" + input + "'");
        }
        StringBuilder builder = new StringBuilder(input);
        builder.insert(2, "0");
        builder.insert(4, "0");
        return builder.toString();
    }
}

