/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.sm.comm;

import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.IDefinitionContext;
import com.ibm.cics.sm.comm.IScopedContext;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Queue;

public class ContextHelper {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public static String findScope(IContext context) {
        String scope = null;
        while (scope == null && context != null) {
            scope = ContextHelper.getScopeFrom(context);
            context = ContextHelper.getParentContext(context);
        }
        return scope;
    }

    public static String getScopeFrom(IContext context) {
        IScopedContext scopedContext;
        if (context instanceof IScopedContext && (scopedContext = (IScopedContext)context).getScope() != null && !scopedContext.getScope().equals("")) {
            return scopedContext.getScope();
        }
        return null;
    }

    public static <T extends IContext> T getContextFrom(IContext baseContext, Class<T> targetContext) {
        if (targetContext.isInstance(baseContext)) {
            return (T)((IContext)targetContext.cast(baseContext));
        }
        return baseContext == null ? null : (T)ContextHelper.getContextFrom(ContextHelper.getParentContext(baseContext), targetContext);
    }

    public static IContext getParentContext(IContext context) {
        LinkedList<Class> classesToCheck = new LinkedList<Class>();
        classesToCheck.add(context.getClass());
        classesToCheck.addAll(Arrays.asList(context.getClass().getInterfaces()));
        return ContextHelper.getParentContext(context, classesToCheck);
    }

    private static IContext getParentContext(Object object, Queue<Class> classesToCheck) {
        IContext parentContext = null;
        while (parentContext == null && classesToCheck.peek() != null) {
            Class toCheck = classesToCheck.poll();
            if (toCheck.getSuperclass() != null) {
                classesToCheck.add(toCheck.getSuperclass());
            }
            try {
                Method getParentMethod = toCheck.getMethod("getParentContext", new Class[0]);
                Object o = getParentMethod.invoke(object, new Object[0]);
                if (!(o instanceof IContext) || o == object) continue;
                parentContext = (IContext)o;
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        }
        return parentContext;
    }

    public static String findGroup(IContext context) {
        IDefinitionContext groupContext = ContextHelper.getContextFrom(context, IDefinitionContext.class);
        return groupContext != null ? groupContext.getResourceGroup() : null;
    }
}

