/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.sm.comm.sm.internal;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.comm.AuthenticationException;
import com.ibm.cics.core.comm.ConnectionException;
import com.ibm.cics.model.IRepository;
import com.ibm.cics.sm.comm.ICICSOperation;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.IResourceTables;
import com.ibm.cics.sm.comm.IScopedContext;
import com.ibm.cics.sm.comm.ISystemManagerConnection;
import com.ibm.cics.sm.comm.ISystemManagerConnection2;
import com.ibm.cics.sm.comm.RepositoryDiscoverer;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import com.ibm.cics.sm.comm.SMConnectionResponse;
import com.ibm.cics.sm.comm.SystemManagerConnectionException;
import com.ibm.cics.sm.comm.sm.SMRecord;
import com.ibm.cics.sm.comm.sm.SMResponse;
import com.ibm.cics.sm.comm.sm.internal.SMCPSMConnection;
import java.util.List;

public class SMCICSConnection
extends SMCPSMConnection
implements ISystemManagerConnection2 {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String CICSRGN_ATTRIBUTE_SYSID = "SYSID";
    private static final String CICSRGN_ATTRIBUTE_CTSLEVEL = "CTSLEVEL";
    public static final String FILE = "/CICSSystemManagement/";
    public static final String DATA_ENCODING_CHARSET = "UTF-8";
    public static final String URLENCODING_CHARSET = "UTF-8";
    public static final String COMMAND_GET = "/DATA/GET";
    protected SMConnectionRecord regionRecord;
    private String cicsSystemId;
    private String version;
    private static final Debug debug = new Debug(SMCICSConnection.class);

    public SMCICSConnection() {
        debug.event("<init>", (Object)this);
    }

    @Override
    public String getActions(String resourceType, IContext context) {
        debug.enter("getActions", (Object)this, (Object)resourceType, (Object)context);
        String actions = String.valueOf(super.getActions(resourceType, context)) + "," + "update";
        if (this.isCICSDefinition(resourceType)) {
            actions = "read";
            if (context == IContext.ANY_CONTEXT || context instanceof IScopedContext) {
                actions = String.valueOf(actions) + ",create,update,perform,install,delete";
            }
        } else if (IResourceTables.Helper.isCPSMDefinition((String)resourceType)) {
            actions = "read";
        }
        debug.exit("getActions", (Object)actions);
        return actions;
    }

    @Override
    public boolean checkOperation(String resourceType, IContext context, ICICSOperation operation) {
        if ("PLATFORM".equals(resourceType)) {
            return false;
        }
        return super.checkOperation(resourceType, context, operation);
    }

    @Override
    public void connect() throws ConnectionException {
        debug.enter("connect", (Object)this, (Object)this.getConfiguration().getHost(), (Object)this.getConfiguration().getPort(), (Object)this.getConfiguration().getUserID());
        this.regionRecord = this.getRegionRecord();
        this.cicsSystemId = this.regionRecord.get(CICSRGN_ATTRIBUTE_SYSID);
        this.version = this.getVersionFromRegionRecord();
        this.connected = true;
        this.checkVersion();
        this.getSupportedResources();
        debug.exit("connect", (Object)("connected=" + Boolean.toString(this.connected) + " version=" + this.version));
    }

    protected String getVersionFromRegionRecord() {
        return this.regionRecord.get(CICSRGN_ATTRIBUTE_CTSLEVEL);
    }

    private SMConnectionRecord getRegionRecord() throws SystemManagerConnectionException, AuthenticationException {
        SMConnectionResponse response = this.getResources("CICSRGN", IContext.NULL_CONTEXT);
        if (response.getRecordCount() > 0) {
            return response.getRecord(0);
        }
        throw new SystemManagerConnectionException("Missing regionRecord ");
    }

    @Override
    public String getServerApplID() {
        return this.cicsSystemId;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public SMConnectionResponse getResources(String resourceName, IContext context) throws SystemManagerConnectionException, AuthenticationException {
        debug.enter("getResources", (Object)this, (Object)resourceName, (Object)context);
        CICSplexRecord cicsPlexRecord = new CICSplexRecord(this.regionRecord, context);
        ManagedRegionRecord managedRegionRecord = new ManagedRegionRecord(this.regionRecord, context);
        CICSRegionDefinitionRecord cicsRegionDefinitionRecord = new CICSRegionDefinitionRecord(this.regionRecord, context);
        SMResponse response = resourceName.equals("CICSPLEX") ? new SMResponse(resourceName, resourceName, new SMRecord[]{cicsPlexRecord}, context) : (resourceName.equals("MAS") ? new SMResponse(resourceName, resourceName, new SMRecord[]{managedRegionRecord}, context) : (resourceName.equals("CSYSDEF") ? new SMResponse(resourceName, resourceName, new SMRecord[]{cicsRegionDefinitionRecord}, context) : super.getResources(resourceName, context)));
        debug.exit("getResources", (Object)response);
        return response;
    }

    @Override
    public SMConnectionResponse get(String resourceType, IContext context) throws SystemManagerConnectionException, AuthenticationException {
        if ("CMASLIST".equals(resourceType)) {
            return this.createLocalResponse(resourceType, new SMConnectionRecord[0], context);
        }
        return super.get(resourceType, context);
    }

    @Override
    public List<IRepository> getRepositories() {
        return RepositoryDiscoverer.getSingleServerRepositories((ISystemManagerConnection)this);
    }

    private class CICSRegionDefinitionRecord
    extends SMRecord {
        private final SMConnectionRecord record;

        public CICSRegionDefinitionRecord(SMConnectionRecord record, IContext context) {
            super("CSYSDEF", "", context);
            this.record = record;
        }

        @Override
        public String get(String attributeName) {
            if (attributeName.equalsIgnoreCase("name")) {
                return this.record.get("EYU_CICSNAME");
            }
            if (attributeName.equalsIgnoreCase("desc")) {
                return this.record.get("EYU_CICSNAME");
            }
            return "FORCE_ATTRIBUTE_UNSUPPORTED";
        }

        @Override
        public String toExternalForm() {
            return "";
        }
    }

    private class CICSplexRecord
    extends SMRecord {
        private final SMConnectionRecord record;

        protected CICSplexRecord(SMConnectionRecord regionRecord, IContext context) {
            super("CICSPLEX", "", context);
            this.record = regionRecord;
        }

        @Override
        public String get(String attributeName) {
            if (attributeName.equalsIgnoreCase("plexname")) {
                return this.record.get("EYU_CICSNAME");
            }
            if (attributeName.equalsIgnoreCase("mpstatus")) {
                return "YES";
            }
            if (attributeName.equalsIgnoreCase("status")) {
                return "ACTIVE";
            }
            return "FORCE_ATTRIBUTE_UNSUPPORTED";
        }

        @Override
        public String toExternalForm() {
            return "";
        }
    }

    private class ManagedRegionRecord
    extends SMRecord {
        private final SMConnectionRecord record;

        protected ManagedRegionRecord(SMConnectionRecord regionRecord, IContext context) {
            super("MAS", "", context);
            this.record = regionRecord;
        }

        @Override
        public String get(String attributeName) {
            if (attributeName.equalsIgnoreCase("cicsname")) {
                return this.record.get("EYU_CICSNAME");
            }
            if (attributeName.equalsIgnoreCase("cicsstate")) {
                return "ACTIVE";
            }
            if (attributeName.equalsIgnoreCase("desc")) {
                return this.record.get("GMMTEXT");
            }
            return "FORCE_ATTRIBUTE_UNSUPPORTED";
        }

        @Override
        public String toExternalForm() {
            return "";
        }
    }
}

