/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.connections.internal;

import com.ibm.cics.common.util.StringUtil;
import com.ibm.cics.core.comm.CredentialsConfiguration;
import com.ibm.cics.core.connections.ConnectionsImages;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.core.connections.ICredentialsManager;
import com.ibm.cics.core.connections.internal.CredentialsMode;
import com.ibm.cics.core.connections.internal.Messages;
import com.ibm.cics.core.connections.internal.PasswordComposite;
import com.ibm.cics.eclipse.common.editor.TitleAreaDialogErrorStateManager;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ChangePasswordDialog
extends TitleAreaDialog {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EXP (c) Copyright IBM Corp. 2012, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String CHANGE_PASSWORD_DIALOG_HELP_CTX_ID = "com.ibm.cics.core.ui.changepassworddetails_dialog";
    private CredentialsConfiguration credentialsConfiguration;
    private ICredentialsManager credentialsManager = ConnectionsPlugin.getDefault().getConnectionService().getConnectionManager().getCredentialsManager();
    private TitleAreaDialogErrorStateManager errorStateManager = new TitleAreaDialogErrorStateManager((TitleAreaDialog)this);
    private PasswordComposite passwordComposite;
    private IRunnableWithProgress runnable;
    private ProgressMonitorPart progressMonitorPart;
    private boolean cancelled;

    public ChangePasswordDialog(Shell parentShell) {
        super(parentShell);
    }

    protected boolean isResizable() {
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitleImage(ConnectionsImages.getImage("PASSWORD_WIZ_BAN"));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, CHANGE_PASSWORD_DIALOG_HELP_CTX_ID);
        this.getShell().setText(Messages.ChangePasswordDialog_title);
        this.setTitle(Messages.ChangePasswordDialog_title);
        Composite c = (Composite)super.createDialogArea(parent);
        Composite childArea = new Composite(c, 0);
        GridData data = new GridData(1808);
        childArea.setLayoutData((Object)data);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginRight = 5;
        gridLayout.marginLeft = 5;
        childArea.setLayout((Layout)gridLayout);
        this.passwordComposite = new PasswordComposite(childArea, 0, true, this.credentialsManager.isPasswordSaveable(), CredentialsMode.CHANGE_PASSWORD, this.credentialsManager);
        this.passwordComposite.userIDText.setEnabled(false);
        this.passwordComposite.credentialsText.setEnabled(false);
        if (this.credentialsConfiguration != null) {
            this.passwordComposite.credentialsText.setText(this.credentialsConfiguration.getName());
            this.passwordComposite.userIDText.setText(this.credentialsConfiguration.getUserID());
            this.passwordComposite.passwordText.setText(this.credentialsConfiguration.getPassword());
            this.passwordComposite.newPasswordOrPassPhrase.setFocus();
        }
        this.passwordComposite.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ChangePasswordDialog.this.validateData();
            }
        });
        this.progressMonitorPart = new ProgressMonitorPart(childArea, null);
        this.progressMonitorPart.setLayoutData((Object)new GridData(4, 0, true, false));
        this.progressMonitorPart.setVisible(false);
        this.setMessage(Messages.ChangePasswordDialog_message);
        return c;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(false);
    }

    private void validateData() {
        String oldPassword = this.passwordComposite.getPassword();
        if (StringUtil.isEmpty((String)oldPassword)) {
            this.errorStateManager.recordSevereError(Messages.Password_mandatory, (Control)this.passwordComposite.passwordText);
            return;
        }
        String newPassword = this.passwordComposite.getNewPassword();
        if (StringUtil.isEmpty((String)newPassword)) {
            this.errorStateManager.recordSevereError(Messages.Password_new_mandatory, (Control)this.passwordComposite.newPasswordOrPassPhrase);
            return;
        }
        String newConfirmedPassword = this.passwordComposite.confirmNewPasswordOrPassPhrase.getText();
        if (StringUtil.isEmpty((String)newConfirmedPassword)) {
            this.errorStateManager.recordSevereError(Messages.Passowrd_new_confirm_mandatory, (Control)this.passwordComposite.confirmNewPasswordOrPassPhrase);
            return;
        }
        if (!newPassword.trim().equals(newConfirmedPassword.trim())) {
            this.errorStateManager.recordSevereError(Messages.Passowrd_new_confirm_mismatch, new Control[]{this.passwordComposite.confirmNewPasswordOrPassPhrase, this.passwordComposite.newPasswordOrPassPhrase});
            return;
        }
        this.errorStateManager.clearErrors();
        if (this.getButton(0) != null) {
            this.getButton(0).setEnabled(StringUtil.isEmpty((String)this.getErrorMessage()));
        }
    }

    protected void okPressed() {
        if (this.runnable != null) {
            try {
                this.progressMonitorPart.attachToCancelComponent((Control)this.getButton(1));
                this.progressMonitorPart.setVisible(true);
                this.setControlsEnabled(false);
                this.cancelled = false;
                ModalContext.run((IRunnableWithProgress)this.runnable, (boolean)true, (IProgressMonitor)this.progressMonitorPart, (Display)this.getShell().getDisplay());
                this.credentialsConfiguration.setSavePassword(true);
                this.credentialsConfiguration.setPassword(this.passwordComposite.newPasswordOrPassPhrase.getText().trim());
                this.credentialsManager.update(this.credentialsConfiguration, true);
            }
            catch (InvocationTargetException e) {
                this.setErrorMessage(e.getLocalizedMessage());
                this.setControlsEnabled(true);
                this.cancelled = true;
            }
            catch (InterruptedException e) {
                this.setErrorMessage(e.getLocalizedMessage());
                this.setControlsEnabled(true);
                this.cancelled = true;
            }
        }
        if (!this.cancelled) {
            super.okPressed();
        }
    }

    protected void cancelPressed() {
        super.cancelPressed();
    }

    private void setControlsEnabled(boolean controlsEnabled) {
        this.passwordComposite.confirmNewPasswordOrPassPhrase.setEnabled(controlsEnabled);
        this.passwordComposite.newPasswordOrPassPhrase.setEnabled(controlsEnabled);
        this.passwordComposite.passwordText.setEnabled(controlsEnabled);
        this.getButton(0).setEnabled(controlsEnabled);
    }

    public void setCredentialsConfiguration(CredentialsConfiguration credentialsConfiguration) {
        this.credentialsConfiguration = credentialsConfiguration;
    }

    public void setChangePasswordRunnable(IRunnableWithProgress aRunnable) {
        this.runnable = aRunnable;
    }
}

