/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.connections.internal.views;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.common.util.StringUtil;
import com.ibm.cics.core.comm.ConnectionRegistry;
import com.ibm.cics.core.connections.ConnectionParameters;
import com.ibm.cics.core.connections.ConnectionProfile;
import com.ibm.cics.core.connections.IConnectionManager;
import com.ibm.cics.core.connections.internal.CollectionUtils;
import com.ibm.cics.core.connections.internal.ConnectionParametersExporter;
import com.ibm.cics.core.connections.internal.FileConnectionXMLSerializer;
import com.ibm.cics.core.connections.internal.Function;
import com.ibm.cics.core.connections.internal.InternalConnectionsPlugin;
import com.ibm.cics.core.connections.internal.views.Messages;
import com.ibm.cics.eclipse.common.ui.TextInput;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class ExportConnectionsDialog
extends TitleAreaDialog {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EXP (c) Copyright IBM Corp. 2012, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static String LAST_CONNECTIONS_FILE = "LAST_CONNECTIONS_FILE";
    Text locationText;
    private static final Debug DEBUG = new Debug(ExportConnectionsDialog.class);
    private final IConnectionManager connectionManager;

    ExportConnectionsDialog(Shell shell, IConnectionManager connectionManager) {
        super(shell);
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        this.connectionManager = connectionManager;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.ExportConnectionsDialog_text);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setEnabled(true);
    }

    protected Control createDialogArea(Composite parent) {
        Composite c = (Composite)super.createDialogArea(parent);
        this.setTitle(Messages.ExportConnectionsDialog_title);
        this.setMessage(Messages.ExportConnectionsDialog_msg);
        Composite childArea = new Composite(c, 0);
        GridData data = new GridData(1808);
        childArea.setLayoutData((Object)data);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginRight = 10;
        gridLayout.marginLeft = 10;
        gridLayout.marginTop = 10;
        childArea.setLayout((Layout)gridLayout);
        Label l = new Label(childArea, 0);
        l.setText(Messages.AddProviderDialog_Location_lbl);
        data = new GridData(4, 0x1000000, false, false);
        l.setLayoutData((Object)data);
        this.locationText = new Text(childArea, 2048);
        TextInput.setAccessibleLabel((Text)this.locationText, (Label)l);
        data = new GridData(4, 0x1000000, true, false);
        this.locationText.setLayoutData((Object)data);
        Button browseButton = new Button(childArea, 8);
        browseButton.setText(Messages.AddProviderDialog_Browse_btn);
        data = new GridData(4, 0x1000000, false, false);
        browseButton.setLayoutData((Object)data);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog fd = new FileDialog(ExportConnectionsDialog.this.getShell(), 8192);
                fd.setOverwrite(true);
                fd.setFilterExtensions(new String[]{"*.pref"});
                String file = fd.open();
                if (file != null) {
                    ExportConnectionsDialog.this.locationText.setText(file);
                }
            }
        });
        String lastFile = InternalConnectionsPlugin.getDefault().getPreferenceStore().getString(LAST_CONNECTIONS_FILE);
        if (StringUtil.hasContent((String)lastFile)) {
            this.locationText.setText(lastFile);
        } else {
            Location instanceLocation = Platform.getInstanceLocation();
            URL workspaceURL = instanceLocation.getURL();
            String absolutePath = workspaceURL.getPath();
            String fileNamePlaceholder = "my_connections";
            File exportLocation = new File(String.valueOf(absolutePath) + fileNamePlaceholder + ".pref");
            this.locationText.setText(exportLocation.getAbsolutePath());
        }
        this.locationText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExportConnectionsDialog.this.getButton(0).setEnabled(StringUtil.hasContent((String)ExportConnectionsDialog.this.locationText.getText()));
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.cics.explorer.connection_export_dialog");
        return c;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            boolean confirmed;
            this.setErrorMessage(null);
            String fileName = this.locationText.getText();
            if (!fileName.endsWith(".pref")) {
                fileName = fileName.concat(".pref");
            }
            if (new File(fileName).exists() && !(confirmed = MessageDialog.openQuestion((Shell)this.getShell(), (String)Messages.ExportConnectionsDialog_FileExistsDialog_title, (String)Messages.ExportConnectionsDialog_FileExistDialog_message))) {
                return;
            }
            this.exportPreferencesTo(fileName);
            if (this.getErrorMessage() == null) {
                super.buttonPressed(buttonId);
                InternalConnectionsPlugin.getDefault().getPreferenceStore().setValue(LAST_CONNECTIONS_FILE, fileName);
            }
        } else {
            super.buttonPressed(buttonId);
        }
    }

    private void exportPreferencesTo(String filePath) {
        List<ConnectionProfile> connectionProfiles = this.connectionManager.getConnectionProfiles();
        List<ConnectionParameters> parametersList = CollectionUtils.transform(connectionProfiles, new Function<ConnectionProfile, ConnectionParameters>(){

            @Override
            public ConnectionParameters evaluate(ConnectionProfile v) {
                return v.getConnectionParameters();
            }
        });
        ConnectionParametersExporter exporter = new ConnectionParametersExporter(parametersList, ConnectionRegistry.getConnectionRegistry());
        List<ConnectionParameters> connections = exporter.getConnections();
        try {
            new FileConnectionXMLSerializer((IPath)new Path(filePath)).save(connections);
        }
        catch (IOException e) {
            this.setErrorMessage(String.valueOf(Messages.Connection_export_failed_msg) + " " + e.getLocalizedMessage());
            DEBUG.event("exportPreferencesTo", (Object)filePath, (Object)e);
        }
    }
}

