/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.common.util;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.common.util.IStaleableEventListener;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;

public class EventManager<T> {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EXP (c) Copyright IBM Corp. 2011, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug DEBUG = new Debug(EventManager.class);
    private CopyOnWriteArrayList<IStaleableEventListener<T>> listeners = new CopyOnWriteArrayList();

    public void addListener(IStaleableEventListener<T> listener) {
        DEBUG.enter("addListener", listener);
        if (listener != null) {
            this.listeners.add(listener);
        } else {
            DEBUG.error("addListener", new Throwable("Added null listener"));
        }
        DEBUG.exit("addListener", this.listeners);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyListeners(T event) {
        DEBUG.enter("notifyListeners", event);
        Iterator<IStaleableEventListener<T>> iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            IStaleableEventListener<T> listener;
            IStaleableEventListener<T> iStaleableEventListener = listener = iterator.next();
            synchronized (iStaleableEventListener) {
                if (listener.isStale()) {
                    DEBUG.event("notifyListeners", "Removing stale listener: " + listener);
                    this.listeners.remove(listener);
                } else {
                    try {
                        DEBUG.event("notifyListeners", "Notifying: " + listener);
                        listener.event(event);
                    }
                    catch (Exception ex) {
                        DEBUG.error("notifyListeners", "Exception occurred processing listener '" + listener + "'. Listener has been disabled", ex);
                        listener.makeStale();
                    }
                }
            }
        }
        DEBUG.exit("notifyListeners");
    }

    public void dispose() {
        this.listeners.clear();
    }
}

