/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.actions;

import com.ibm.cics.core.model.CSDGroupDefinitionType;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.ResourceGroupDefinitionType;
import com.ibm.cics.core.ui.actions.Messages;
import com.ibm.cics.core.ui.actions.RemoveFromCSDListAction;
import com.ibm.cics.core.ui.actions.RemoveFromResourceDescriptionAction;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.sm.comm.ICICSOperation;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SystemManagerActions;
import com.ibm.cics.sm.comm.context.IAssociationContext;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;

public final class RemoveGroupFromListAction
extends Action {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private final IAssociationContext associationContext;
    private final IStructuredSelection selection;
    private ICICSType<? extends ICICSObject> type;

    public RemoveGroupFromListAction(ICPSM cpsm, IAssociationContext associationContext, IStructuredSelection selection) {
        super(Messages.getString("RemoveListFromGroupAction.removeFromList"));
        this.associationContext = associationContext;
        this.selection = selection;
        this.type = ((ICICSObject)selection.getFirstElement()).getObjectType();
        this.setEnabled(cpsm.checkPermission((ICICSOperation)SystemManagerActions.Remove, this.type, (IContext)associationContext));
    }

    public void run() {
        if (this.type == ResourceGroupDefinitionType.getInstance()) {
            new RemoveFromResourceDescriptionAction(this.associationContext, this.selection.toList()).run((IAction)this);
        } else if (this.type == CSDGroupDefinitionType.getInstance()) {
            new RemoveFromCSDListAction(this.associationContext, this.selection.toList()).run((IAction)this);
        }
    }
}

