/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.adapters;

import com.ibm.cics.core.ui.Debug;
import com.ibm.cics.core.ui.properties.IDescriptionProvider;
import com.ibm.cics.model.Descriptions;
import com.ibm.cics.model.ICICSType;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IAdapterFactory;

public class AdapterFactory
implements IAdapterFactory {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(AdapterFactory.class.getPackage().getName());
    private IDescriptionProvider cicsTypeDescriptionProvider = new IDescriptionProvider(){

        @Override
        public String getString(String key) {
            return Descriptions.getTrimmedString(key);
        }

        public String toString() {
            return "IDescriptionProvider[cicsTypeDescriptionProvider]";
        }

        @Override
        public String getHelpContextIdPrefix() {
            return "com.ibm.cics.core.ui";
        }
    };

    public AdapterFactory() {
        if (Debug.DEBUG_ADAPTERS) {
            Debug.event((Logger)logger, (String)AdapterFactory.class.getName(), (String)"AdapterFactory.<init>()");
        }
    }

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (Debug.DEBUG_ADAPTERS) {
            Debug.enter((Logger)logger, (String)AdapterFactory.class.getName(), (String)"getAdapter", (Object)(" object=" + adaptableObject + ", type=" + adapterType));
        }
        IDescriptionProvider adapter = null;
        if (adapterType == IDescriptionProvider.class && adaptableObject instanceof ICICSType) {
            adapter = this.cicsTypeDescriptionProvider;
        }
        if (Debug.DEBUG_ADAPTERS) {
            Debug.exit((Logger)logger, (String)AdapterFactory.class.getName(), (String)"getAdapter", (Object)("adapter=" + adapter));
        }
        return adapter;
    }

    public Class[] getAdapterList() {
        return new Class[]{IDescriptionProvider.class};
    }
}

