/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.internal.cloud;

import com.ibm.cics.core.model.CICSSystemManagerException;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.ICoreObject;
import com.ibm.cics.core.ui.ExceptionMessageHelper;
import com.ibm.cics.core.ui.internal.cloud.CloudMessages;
import com.ibm.cics.eclipse.common.ops.ExecutionFailedException;
import com.ibm.cics.eclipse.common.ops.IOperationExecutionDelegate;
import com.ibm.cics.model.CICSActionException;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICICSRegionGroupDefinition;
import com.ibm.cics.model.IPlatform;
import com.ibm.cics.sm.comm.ICICSAction;
import com.ibm.cics.sm.comm.IPrimaryKey;
import com.ibm.cics.sm.comm.SystemManagerActions;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;

public class AddNewRegionToRegionTypeExecutionDelegate<T>
implements IOperationExecutionDelegate<T> {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private ICICSRegionGroupDefinition group;
    private IPlatform platform;
    private ICICSAction action;
    private String regionName;

    public AddNewRegionToRegionTypeExecutionDelegate(IPlatform platform, ICICSRegionGroupDefinition group, String regionName, String applid, String sysid, String primaryCMAS, String description) {
        this.group = group;
        this.platform = platform;
        this.regionName = regionName;
        this.action = new SystemManagerActions.AddNewRegionToRegionTypeAction(regionName, this.group.getRegiontype(), applid, sysid, primaryCMAS, description);
    }

    public void execute(T target) throws ExecutionFailedException {
        try {
            ICPSM cpsm = ((ICoreObject)this.platform).getCPSM();
            cpsm.perform(new ICICSObject[]{this.platform}, this.action);
        }
        catch (CICSSystemManagerException ex) {
            IStatus status = ExceptionMessageHelper.getStatus((CICSActionException)((Object)ex), this.platform.getObjectType(), 2);
            throw new ExecutionFailedException(status);
        }
    }

    public String getOperationDescription(T target) {
        String context = "";
        IPrimaryKey key = (IPrimaryKey)((ICoreObject)this.platform).getAdapter(IPrimaryKey.class);
        if (key != null) {
            context = key.getContext();
        }
        return NLS.bind((String)CloudMessages.AddNewRegionToRegionTypeDelegate_operation, (Object[])new Object[]{this.regionName, this.group.getRegiontype(), this.platform.getName(), context});
    }

    public String getOperationName() {
        return this.action.getActionName();
    }

    public int getID() {
        return 611;
    }
}

