/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.internal.cloud;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.model.ApplicationDefinitionType;
import com.ibm.cics.core.model.ApplicationType;
import com.ibm.cics.core.model.CICSRegionGroupDefinitionType;
import com.ibm.cics.core.model.PlatformDefinitionType;
import com.ibm.cics.core.model.PlatformType;
import com.ibm.cics.core.ui.OperationTypesWrapper;
import com.ibm.cics.core.ui.UIPlugin;
import com.ibm.cics.core.ui.internal.cloud.AbstractApplicationDeferredWorkbenchAdapter;
import com.ibm.cics.core.ui.internal.cloud.AbstractCPSMDeferredWorkbenchAdapter;
import com.ibm.cics.core.ui.internal.cloud.ApplicationStyleApplicationDeferredWorkbenchAdapter;
import com.ibm.cics.core.ui.internal.cloud.CloudMessages;
import com.ibm.cics.core.ui.internal.cloud.ErrorWrapper;
import com.ibm.cics.core.ui.internal.cloud.HierarchyStyle;
import com.ibm.cics.core.ui.internal.cloud.ManagedRegionDeferredWorkbenchAdapter;
import com.ibm.cics.core.ui.internal.cloud.ManagementPartDeferredWorkbenchAdapter;
import com.ibm.cics.core.ui.internal.cloud.PlatformStyleApplicationDeferredWorkbenchAdapter;
import com.ibm.cics.core.ui.views.Messages;
import com.ibm.cics.model.IApplication;
import com.ibm.cics.model.IApplicationDefinition;
import com.ibm.cics.model.ICICSRegionGroupDefinition;
import com.ibm.cics.model.IManagedRegion;
import com.ibm.cics.model.IManagementPart;
import com.ibm.cics.model.IPlatform;
import com.ibm.cics.model.IPlatformDefinition;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.PendingUpdateAdapter;

public class CloudLabelProvider
extends LabelProvider {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2012, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static Debug DEBUG = new Debug(CloudLabelProvider.class);

    public String getText(Object element) {
        String text;
        DEBUG.enter("getText", (Object)this, element);
        if (element instanceof AbstractCPSMDeferredWorkbenchAdapter) {
            AbstractCPSMDeferredWorkbenchAdapter adapter = (AbstractCPSMDeferredWorkbenchAdapter)element;
            text = adapter.getLabel(element);
        } else if (element instanceof PendingUpdateAdapter) {
            text = Messages.getString("pending", new Object[0]);
        } else if (element instanceof IPlatform) {
            text = ((IPlatform)element).getName();
        } else if (element instanceof IPlatformDefinition) {
            text = ((IPlatformDefinition)element).getName();
        } else if (element instanceof IApplication) {
            AbstractApplicationDeferredWorkbenchAdapter adapter;
            switch (HierarchyStyle.getPreferenceHierarchyStyle(true)) {
                case APPLICATION: {
                    adapter = new ApplicationStyleApplicationDeferredWorkbenchAdapter(null, (IApplication)element);
                    break;
                }
                default: {
                    adapter = new PlatformStyleApplicationDeferredWorkbenchAdapter(null, (IApplication)element);
                }
            }
            text = adapter.getLabel(element);
        } else if (element instanceof IApplicationDefinition) {
            StringBuilder appBuilder = new StringBuilder();
            appBuilder.append(((IApplicationDefinition)element).getName());
            appBuilder.append(" (");
            appBuilder.append(((IApplicationDefinition)element).getMajorVersion());
            appBuilder.append('.');
            appBuilder.append(((IApplicationDefinition)element).getMinorVersion());
            appBuilder.append('.');
            appBuilder.append(((IApplicationDefinition)element).getMicroVersion());
            appBuilder.append(")");
            text = appBuilder.toString();
        } else if (element instanceof IManagementPart) {
            ManagementPartDeferredWorkbenchAdapter adapter = new ManagementPartDeferredWorkbenchAdapter(null, (IManagementPart)element);
            text = adapter.getLabel(element);
        } else if (element instanceof IManagedRegion) {
            ManagedRegionDeferredWorkbenchAdapter adapter = new ManagedRegionDeferredWorkbenchAdapter(null, (IManagedRegion)element);
            text = adapter.getLabel(element);
        } else {
            text = element instanceof OperationTypesWrapper ? ((OperationTypesWrapper)element).getOperationName() : (element instanceof ICICSRegionGroupDefinition ? ((ICICSRegionGroupDefinition)element).getRegiontype() : (element instanceof ErrorWrapper ? NLS.bind((String)CloudMessages.CloudLabelProvider_requestFailedNode, null) : element.toString()));
        }
        DEBUG.exit("getText", (Object)text);
        return text;
    }

    public Image getImage(Object element) {
        DEBUG.enter("getImage", (Object)this, element);
        Image image = null;
        if (element instanceof AbstractCPSMDeferredWorkbenchAdapter) {
            AbstractCPSMDeferredWorkbenchAdapter adapter = (AbstractCPSMDeferredWorkbenchAdapter)element;
            ImageDescriptor imageDescriptor = adapter.getImageDescriptor(element);
            image = UIPlugin.getImage(imageDescriptor);
        } else if (element instanceof IPlatform) {
            image = UIPlugin.getTableImage(PlatformType.getInstance().getResourceTableName());
        } else if (element instanceof IPlatformDefinition) {
            image = UIPlugin.getTableImage(PlatformDefinitionType.getInstance().getResourceTableName());
        } else if (element instanceof IApplication) {
            image = UIPlugin.getTableImage(ApplicationType.getInstance().getResourceTableName());
        } else if (element instanceof IApplicationDefinition) {
            image = UIPlugin.getTableImage(ApplicationDefinitionType.getInstance().getResourceTableName());
        } else if (element instanceof ICICSRegionGroupDefinition) {
            image = UIPlugin.getTableImage(CICSRegionGroupDefinitionType.getInstance().getResourceTableName());
        } else if (element instanceof IManagementPart) {
            ManagementPartDeferredWorkbenchAdapter adapter = new ManagementPartDeferredWorkbenchAdapter(null, (IManagementPart)element);
            image = UIPlugin.getImage(adapter.getImageDescriptor(element));
        } else if (element instanceof IManagedRegion) {
            ManagedRegionDeferredWorkbenchAdapter adapter = new ManagedRegionDeferredWorkbenchAdapter(null, (IManagedRegion)element);
            image = UIPlugin.getImage(adapter.getImageDescriptor(element));
        } else if (element instanceof OperationTypesWrapper) {
            image = UIPlugin.getImage(UIPlugin.IMGD_OPERATION);
        } else if (element instanceof PendingUpdateAdapter) {
            image = UIPlugin.getImage(UIPlugin.IMGD_WAITING);
        } else if (element instanceof ErrorWrapper) {
            image = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
        }
        DEBUG.exit("getImage", (Object)image);
        return image;
    }
}

