/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.properties.internal;

import com.ibm.cics.common.util.StringUtil;
import com.ibm.cics.eclipse.common.ui.EnsureUppercaseListener;
import com.ibm.cics.model.ICICSAttribute;
import com.ibm.cics.model.ICICSAttributeHint;
import com.ibm.cics.model.IllegalCICSAttributeException;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class CICSTextCellEditor
extends TextCellEditor {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private ICICSAttribute<?> attribute;
    private Object modelValue;
    private final boolean allowUnspecified;

    public CICSTextCellEditor(Composite parent, ICICSAttribute<?> cicsAttribute) {
        this(parent, cicsAttribute, false);
    }

    public CICSTextCellEditor(Composite parent, ICICSAttribute<?> cicsAttribute, boolean allowUnspecified) {
        super(parent);
        this.attribute = cicsAttribute;
        this.allowUnspecified = allowUnspecified;
        ICICSAttributeHint valuesHint = this.attribute.getValuesHint();
        if (valuesHint != null && valuesHint.getSpecialValues() != null && valuesHint.getSpecialValues().size() > 0) {
            EnsureUppercaseListener.attach((Text)((Text)this.getControl()));
        }
    }

    public void fireApplyEditorValue() {
        super.fireApplyEditorValue();
    }

    /*
     * Unable to fully structure code
     */
    protected void editOccured(ModifyEvent e) {
        block16: {
            block17: {
                oldValidState = this.isValueValid();
                try {
                    this.modelValue = this.attribute.externalToInternal(this.text.getText());
                    newValidState = this.isCorrect(this.modelValue);
                    break block16;
                }
                catch (IllegalCICSAttributeException ex) {
                    newValidState = false;
                    buffer = new StringBuffer();
                    if (this.attribute.getType() != Long.class || this.attribute.getValuesHint() == null) break block17;
                    if (this.attribute.getValuesHint().hasNumericRange()) {
                        buffer.append(" between " + this.attribute.getValuesHint().getNumericRange()[0] + " to " + this.attribute.getValuesHint().getNumericRange()[1]);
                    }
                    if (this.attribute.getValuesHint().hasMaxLength()) {
                        if (buffer.toString().length() > 0) {
                            buffer.append(",");
                        }
                        buffer.append(" lower than " + this.attribute.getValuesHint().getMaxLength());
                    }
                    if (!this.attribute.getValuesHint().hasSpecialValues()) break block17;
                    hasNonEmptySpecialValue = false;
                    i = 0;
                    size = this.attribute.getValuesHint().getSpecialValues().size();
                    keySet = this.attribute.getValuesHint().getSpecialValues().keySet();
                    if (keySet.contains("")) {
                        --size;
                        hasNonEmptySpecialValue = true;
                    }
                    if (buffer.toString().length() > 0) {
                        buffer.append(", ");
                        if (size > 1) {
                            if (hasNonEmptySpecialValue) {
                                buffer.append("one of (");
                            } else {
                                buffer.append("or one of (");
                            }
                        }
                    }
                    ** for (specialValue : keySet)
                }
lbl-1000:
                // 1 sources

                {
                    ++i;
                    if (!StringUtil.hasContent((String)specialValue)) continue;
                    buffer.append(specialValue);
                    if (i > size && buffer.toString().contains("one of")) {
                        buffer.append("), ");
                        continue;
                    }
                    buffer.append(", ");
                    continue;
                }
lbl49:
                // 1 sources

                if (hasNonEmptySpecialValue) {
                    buffer.append("or unspecified.");
                } else {
                    buffer.append(".");
                }
            }
            if (buffer.toString().isEmpty()) {
                this.setErrorMessage(ex.getMessage());
            } else {
                this.setErrorMessage(String.valueOf(ex.getMessage()) + ". Value must be" + buffer.toString());
            }
        }
        this.valueChanged(oldValidState, newValidState);
    }

    protected Object doGetValue() {
        if (this.allowUnspecified && this.modelValue != null && this.modelValue instanceof String && ((String)this.modelValue).isEmpty()) {
            return null;
        }
        return this.modelValue;
    }

    protected void doSetValue(Object value) {
        String stringValue;
        try {
            stringValue = this.allowUnspecified && value == null ? "" : this.attribute.internalToExternal(value);
            this.modelValue = value;
        }
        catch (IllegalCICSAttributeException illegalCICSAttributeException) {
            stringValue = "";
            this.modelValue = null;
        }
        super.doSetValue((Object)stringValue);
    }
}

