/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.views;

import com.ibm.cics.common.util.EventManager;
import com.ibm.cics.common.util.IStaleableEventListener;
import com.ibm.cics.core.ui.views.IElementTypeService;
import com.ibm.cics.model.ICICSType;

public class ElementTypeServiceImpl
implements IElementTypeService {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private EventManager<IElementTypeService.Event> eventManager = new EventManager();
    private ICICSType<?> elementType;

    public ElementTypeServiceImpl(ICICSType<?> elementType) {
        this.elementType = elementType;
    }

    @Override
    public ICICSType<?> getElementType() {
        return this.elementType;
    }

    public void setElementType(ICICSType<?> elementType) {
        IElementTypeService.ElementTypeChangedEvent event = new IElementTypeService.ElementTypeChangedEvent(this.elementType, elementType);
        this.elementType = elementType;
        this.eventManager.notifyListeners((Object)event);
    }

    @Override
    public void addElementTypeServiceListener(IElementTypeService.ElementTypeServiceListener listener) {
        this.eventManager.addListener((IStaleableEventListener)listener);
    }
}

