/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.connections.internal;

import com.ibm.cics.core.comm.CredentialsConfiguration;
import com.ibm.cics.core.connections.ICredentialsManager;
import com.ibm.cics.core.connections.internal.OldCredentialsReader;
import java.util.List;

public class CredentialsPreferenceMigrator {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EXP (c) Copyright IBM Corp. 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private final ICredentialsManager credentialsManager;
    private final OldCredentialsReader credentialsReader;
    private final boolean removeOldPrefs;

    public CredentialsPreferenceMigrator(ICredentialsManager credentialsManager, OldCredentialsReader credentialsReader, boolean removeOldPrefs) {
        this.credentialsManager = credentialsManager;
        this.credentialsReader = credentialsReader;
        this.removeOldPrefs = removeOldPrefs;
    }

    public void migrate() {
        List<CredentialsConfiguration> credentialsConfigurations = this.credentialsReader.getCredentialsConfigurations();
        for (CredentialsConfiguration credentialsConfiguration : credentialsConfigurations) {
            this.credentialsManager.update(credentialsConfiguration);
        }
        if (this.removeOldPrefs) {
            this.credentialsReader.clear();
        }
    }
}

