/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.connections.internal;

import com.ibm.cics.core.comm.ConnectionException;
import com.ibm.cics.core.comm.EnhancedConnectionException;
import com.ibm.cics.core.comm.internal.ConnectionExceptionUtils;
import com.ibm.cics.core.connections.ConfigurationUtils;
import com.ibm.cics.core.connections.ConnectionParameters;
import com.ibm.cics.core.connections.IConnectionProvider;
import com.ibm.cics.core.connections.IWritableConnectionProvider;
import com.ibm.cics.core.connections.internal.AcceptSSLDialog;
import com.ibm.cics.core.connections.internal.Messages;
import java.net.SocketException;
import java.text.MessageFormat;
import javax.net.ssl.SSLException;

public class MisconfiguredSecurityResolver {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EXP (c) Copyright IBM Corp. 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public boolean handleSecurityAmbiguity(ConnectionException connectionEx, ConnectionParameters configuration, IConnectionProvider connectionProvider) throws ConnectionException {
        Exception securityEx = ConnectionExceptionUtils.getPossibleSSLException((ConnectionException)connectionEx);
        if (this.isMisconfiguredInsecure(securityEx) || this.isMisconfiguredSecure(securityEx)) {
            if (this.canAutoResolve(configuration, connectionProvider, securityEx)) {
                return true;
            }
            String msg = MessageFormat.format(Messages.SecurityException_SSLServer, ConfigurationUtils.isSecureHint(configuration), securityEx.getMessage());
            msg = MessageFormat.format(Messages.ConnectionExceptionMessageHelper_IZE0106E_failedWithError, msg, configuration.getName());
            throw new EnhancedConnectionException(msg, (Throwable)securityEx);
        }
        return false;
    }

    private boolean canAutoResolve(ConnectionParameters configuration, IConnectionProvider connectionProvider, Exception securityEx) {
        return this.unconfirmedSecurity(configuration) && this.isWritableProvider(connectionProvider) && AcceptSSLDialog.showSSLDialog(configuration, this.isMisconfiguredSecure(securityEx), (IWritableConnectionProvider)connectionProvider);
    }

    private boolean isMisconfiguredInsecure(Exception ex) {
        return ex instanceof SSLException;
    }

    private boolean isMisconfiguredSecure(Exception ex) {
        return ex instanceof SocketException;
    }

    private boolean unconfirmedSecurity(ConnectionParameters config) {
        return !Boolean.parseBoolean(config.getAttribute("ssl_confirmed"));
    }

    private boolean isWritableProvider(IConnectionProvider provider) {
        return provider instanceof IWritableConnectionProvider;
    }
}

