/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.model;

import com.ibm.cics.model.ICICSAttribute;
import java.util.HashMap;
import java.util.Map;

public class AttributeValue<E> {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private final ICICSAttribute<E> attribute;
    private final E value;

    public AttributeValue(ICICSAttribute<E> attribute, E value) {
        this.attribute = attribute;
        this.value = value;
    }

    public ICICSAttribute<E> getAttribute() {
        return this.attribute;
    }

    public E getValue() {
        return this.value;
    }

    public String getExternalValue() {
        return this.attribute.internalToExternal(this.value);
    }

    public static <E> AttributeValue<E> av(ICICSAttribute<E> attribute, E value) {
        return new AttributeValue<E>(attribute, value);
    }

    public static Map<ICICSAttribute<?>, Object> mapify(AttributeValue<?> ... attributeValues) {
        HashMap map = new HashMap();
        AttributeValue<?>[] attributeValueArray = attributeValues;
        int n = attributeValues.length;
        int n2 = 0;
        while (n2 < n) {
            AttributeValue<?> attributeValue = attributeValueArray[n2];
            map.put(attributeValue.getAttribute(), attributeValue.getValue());
            ++n2;
        }
        return map;
    }

    public String toString() {
        return "[" + this.attribute + ", " + this.value + "]";
    }
}

