/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.connections;

import com.ibm.cics.core.comm.CredentialsConfiguration;
import com.ibm.cics.core.comm.IConnectable;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.core.connections.ICredentialsManager;

public class ConnectionUtilities {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EXP (c) Copyright IBM Corp. 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    public static String getPassword(IConnectable connectable) {
        CredentialsConfiguration credentials = ConnectionUtilities.getCredentialsConfiguration(connectable);
        if (credentials != null) {
            return credentials.getPassword();
        }
        return "";
    }

    public static String getUserID(IConnectable connectable) {
        CredentialsConfiguration credentials = ConnectionUtilities.getCredentialsConfiguration(connectable);
        if (credentials != null) {
            return credentials.getUserID();
        }
        return "";
    }

    public static CredentialsConfiguration getCredentialsConfiguration(IConnectable connectable) {
        ICredentialsManager credentialsManager = ConnectionsPlugin.getDefault().getCredentialsManager();
        if (credentialsManager != null) {
            return credentialsManager.findCredentialsConfigurationByID(connectable.getConnection().getConfiguration().getCredentialsID());
        }
        return null;
    }
}

