/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.connections.internal;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.common.util.StringUtil;
import com.ibm.cics.core.comm.CredentialsConfiguration;
import com.ibm.cics.core.comm.IConnectionDescriptor;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.core.connections.IConnectionProvider;
import com.ibm.cics.core.connections.ICredentialsManager;
import java.util.Set;
import java.util.TreeSet;

public class ConnectionUtils {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EXP (c) Copyright IBM Corp. 2011, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static Debug debug = new Debug(ConnectionUtils.class);
    private static final String ALLOW_BLANK_USER_IDS = "ALLOW_BLANK_USER_IDS";
    private static final String ALLOW_MULTIPLE_CONNECTIONS = "ALLOW_MULTIPLE_CONNECTIONS";

    public static boolean connectionTypeUsesCredentials(IConnectionDescriptor descriptor) {
        return descriptor.getExtendedAttribute(ALLOW_BLANK_USER_IDS) == null;
    }

    public static boolean supportsMultipleConnections(IConnectionDescriptor descriptor) {
        return descriptor != null && descriptor.getExtendedAttribute(ALLOW_MULTIPLE_CONNECTIONS) != null;
    }

    public static String createNewNamesAgainst(Set<String> names, String newName) {
        String testName = newName;
        int i = 2;
        while (names.contains(testName)) {
            testName = String.valueOf(newName) + " (" + i + ")";
            ++i;
        }
        return testName;
    }

    public static String createNewNameAgainst(String userName) {
        ICredentialsManager credentialsManager = ConnectionsPlugin.getDefault().getCredentialsManager();
        TreeSet<String> existingCredentialNames = new TreeSet<String>();
        for (CredentialsConfiguration credentialConfiguration : credentialsManager.getAllCredentials()) {
            existingCredentialNames.add(credentialConfiguration.getUserID());
        }
        return ConnectionUtils.createNewNamesAgainst(existingCredentialNames, userName);
    }

    public static String generateName(String host, String userID) {
        StringBuffer result = new StringBuffer();
        if (StringUtil.hasContent((String)userID)) {
            result.append(ConnectionUtils.createNewNameAgainst(userID));
        }
        if (StringUtil.hasContent((String)host)) {
            result.append("@");
            int indexOfPeriod = host.indexOf(46);
            if (indexOfPeriod == -1) {
                result.append(host);
            } else {
                result.append(host.substring(0, indexOfPeriod));
            }
        }
        return result.toString();
    }

    public static String getInternalId(String externalId) {
        debug.enter("getInternalId", (Object)externalId);
        String internalId = externalId.substring(0, externalId.lastIndexOf(64));
        debug.exit("getInternalId", (Object)internalId);
        return internalId;
    }

    public static boolean isProviderId(String id, IConnectionProvider connectionProvider) {
        return id.endsWith(String.valueOf('@') + connectionProvider.getId());
    }

    public static boolean isIdReference(IConnectionDescriptor descriptor, String attribute) {
        IConnectionDescriptor.ExtendedAttribute extendedAttribute = descriptor.getExtendedAttribute(attribute);
        return extendedAttribute != null && extendedAttribute.getType() == IConnectionDescriptor.ExtendedAttributeType.CONNECTION_ID;
    }

    public static boolean isInternalId(String id) {
        return StringUtil.hasContent((String)id) && !id.contains("@");
    }
}

