/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.connections.internal;

import com.ibm.cics.core.connections.ConnectionParameters;
import com.ibm.cics.core.connections.IWritableConnectionProvider;
import com.ibm.cics.core.connections.internal.AbstractConfigurationOperation;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class UpdateConfigurationCommand
extends AbstractConfigurationOperation {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655EXP (c) Copyright IBM Corp. 2012, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private ConnectionParameters oldConfiguration;
    private ConnectionParameters newConfiguration;
    private IWritableConnectionProvider connectionProvider;

    public UpdateConfigurationCommand(ConnectionParameters oldConfiguration, ConnectionParameters newConfiguration, IWritableConnectionProvider connectionProvider) {
        super("Update configuration");
        this.connectionProvider = connectionProvider;
        this.oldConfiguration = oldConfiguration;
        this.newConfiguration = newConfiguration;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.connectionProvider.updateConnectionParameters(this.newConfiguration);
        return Status.OK_STATUS;
    }

    public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        return this.execute(monitor, info);
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        this.connectionProvider.updateConnectionParameters(this.oldConfiguration);
        return Status.OK_STATUS;
    }

    @Override
    public String getConfigurationId() {
        return this.oldConfiguration.getId();
    }
}

