/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.sm.comm;

import com.ibm.cics.sm.comm.ErrorCodes;
import com.ibm.cics.sm.comm.IResourceErrorCode;
import com.ibm.cics.sm.comm.SMUpdateException;
import java.util.List;

public class CreateException
extends SMUpdateException {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final long serialVersionUID = 1L;
    private final IResourceErrorCode feedbackErrorCode;

    public CreateException(String resourceType, int response, int reason, String resp, int resp2, IResourceErrorCode feedbackErrorCode, List<String> attributeNames) {
        super(attributeNames + ": " + feedbackErrorCode.getErrorCode() + ": " + feedbackErrorCode.getLabel());
        this.feedbackErrorCode = feedbackErrorCode;
        this.resp = resp;
        this.resp2 = resp2;
        for (String attributeName : attributeNames) {
            SMUpdateException.Error error = this.createError();
            error.addAttributeName(attributeName, resourceType);
            error.setServerResponse(feedbackErrorCode.getLabel());
        }
    }

    public CreateException(String resourceType, int response, int reason, IResourceErrorCode feedbackErrorCode, List<String> attributeNames) {
        this(resourceType, response, reason, null, -1, feedbackErrorCode, attributeNames);
    }

    @Deprecated
    public CreateException(String resourceType, int response, int reason, int feedbackErrorCode, List<String> attributeNames) {
        this(resourceType, response, reason, ErrorCodes.findErrorCodeByNumber(resourceType, feedbackErrorCode), attributeNames);
    }

    @Deprecated
    public int getErrorCode() {
        return this.feedbackErrorCode.getErrorCode();
    }

    public IResourceErrorCode getFeedbackErrorCode() {
        return this.feedbackErrorCode;
    }
}

