/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui;

import com.ibm.cics.core.comm.ConnectionRegistry;
import com.ibm.cics.core.comm.IConnectable;
import com.ibm.cics.core.connections.ConnectionServiceListener;
import com.ibm.cics.core.connections.ConnectionsPlugin;
import com.ibm.cics.core.connections.IConnectionService;
import com.ibm.cics.core.connections.ICredentialsManager;
import com.ibm.cics.core.connections.internal.ConnectionManager;
import com.ibm.cics.core.connections.internal.ConnectionParameterImporter;
import com.ibm.cics.core.connections.internal.ConnectionProviderRegistry;
import com.ibm.cics.core.connections.internal.CredentialsPreferenceMigrator;
import com.ibm.cics.core.connections.internal.IConnectionDeserializer;
import com.ibm.cics.core.connections.internal.InternalConnectionsPlugin;
import com.ibm.cics.core.connections.internal.OldConnectionReader;
import com.ibm.cics.core.connections.internal.OldCredentialsReader;
import com.ibm.cics.core.connections.internal.WritableConnectionProvider;
import com.ibm.cics.core.model.CICSCore;
import com.ibm.cics.core.model.IContextProvider;
import com.ibm.cics.core.ui.Debug;
import com.ibm.cics.core.ui.WizardBannerImageDescriptor;
import com.ibm.cics.core.ui.internal.ConnectionContextManager;
import com.ibm.cics.eclipse.common.Activator;
import com.ibm.cics.eclipse.common.IConnectionPasswordStorage;
import com.ibm.cics.eclipse.common.ui.EmptyEditorAreaHider;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICMASList;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.context.ICMASContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IActionFilter;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.service.prefs.Preferences;

public class UIPlugin
extends AbstractUIPlugin {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String PLUGIN_ID = "com.ibm.cics.core.ui";
    public static final String CICS_SM_ACTIVITY = "com.ibm.cics.sm.activity";
    public static final String CICS_ZOS_ACTIVITY = "com.ibm.cics.zos.activity";
    public static final String KEY = "KEY";
    public static final int CONNECTED = 2;
    public static final int IS_CONNECTING = 1;
    public static final int DISCONNECTED = 0;
    public static final String SERVER_NAMES = "SERVER_NAMES";
    public static final String DEFAULT_SYSTEM = "DEFAULT_SYSTEM";
    public static String TRANSID = "TRANSID";
    public static String CREATE_TRAN_DEF = "CREATE_TRAN_DEF";
    public static String CONTENT_ASSIST_CUE = "CONTENT_ASSIST_CUE";
    public static String NEW_WIZARD_BANNER = "NEW_WIZARD_BANNER";
    public static String ERROR_WIZARD_BANNER = "ERROR_WIZARD_BANNER";
    public static String WARNING_WIZARD_BANNER = "WARNING_WIZARD_BANNER";
    public static String QUESTION_WIZARD_BANNER = "QUESTION_WIZARD_BANNER";
    public static String RESOURCE_GROUP = "RESOURCE_GROUP";
    public static String WARNING = "WARNING";
    public static String UNENABLED = "UNENABLED";
    public static String DROP_DOWN_ARROW = "DROP_DOWN_ARROW";
    public static String IN_ACTIVE_CONNECTION_ERROR = "IN_ACTIVE_CONNECTION_ERROR";
    public static String WARNING_OVERLAY = "WARNING_OVERLAY";
    public static String ERROR_OVERLAY = "ERROR_OVERLAY";
    public static String ERROR = "ERROR";
    public static String CONNECTED_OVERLAY = "CONNECTED_OVERLAY";
    public static String ENABLED = "ENABLED";
    public static String DISABLED = "DISABLED";
    public static String ACTIVE = "ACTIVE";
    public static String TRUE = "true";
    public static String FALSE = "false";
    public static String LOCKED_OVERLAY = "LOCKED_OVERLAY";
    public static String INSERVICE = "INSERVICE";
    public static String RUNNING = "RUNNING";
    public static String DISPATCHABLE = "DISPATCHABLE";
    public static String SUSPENDED = "SUSPENDED";
    public static String RUN_FILTER = "RUN_FILTER";
    public static String CLEAR_FILTER = "CLEAR_FILTER";
    public static String NEW_CONFIG = "NEW_CONFIG";
    public static String DELETE_CONFIG = "DELETE_CONFIG";
    public static String COPY_CONFIG = "COPY_CONFIG";
    public static String IPIC = "IPIC";
    public static String EXCI = "EXCI";
    public static String TCP = "TCPIP";
    public static String SNA = "SNA";
    public static String BUNDLE = "BUNDLE";
    public static final ImageDescriptor IMGD_ARROW_UP = UIPlugin.getImageDescriptor("icons/full/elcl16/arrow_up.gif");
    public static final ImageDescriptor IMGD_ARROW_UP_DISABLED = UIPlugin.getImageDescriptor("icons/full/dlcl16/arrow_up.gif");
    public static final ImageDescriptor IMGD_ARROW_DOWN = UIPlugin.getImageDescriptor("icons/full/elcl16/arrow_down.gif");
    public static final ImageDescriptor IMGD_ARROW_DOWN_DISABLED = UIPlugin.getImageDescriptor("icons/full/dlcl16/arrow_down.gif");
    public static final ImageDescriptor IMGD_WAITING = UIPlugin.getImageDescriptor("icons/full/elcl16/waiting_16.gif");
    public static final ImageDescriptor IMGD_CICSPLEX = UIPlugin.getImageDescriptor("icons/CICSPLEX.GIF");
    public static final ImageDescriptor IMGD_DISABLED_CICSPLEX = UIPlugin.getImageDescriptor("icons/CICSPLEX.GIF", 1);
    public static final ImageDescriptor IMGD_WORKLOAD_GROUP = UIPlugin.getImageDescriptor("icons/group_workload.gif");
    public static final ImageDescriptor IMGD_ACTIVE_WORKLOAD = UIPlugin.getImageDescriptor("icons/WLMAWORK.GIF");
    public static final ImageDescriptor IMGD_INACTIVE_WORKLOAD = UIPlugin.getImageDescriptor("icons/WLMAWORK.GIF", 1);
    public static final ImageDescriptor IMGD_ACTIVE_AOR = UIPlugin.getImageDescriptor("icons/WLMAWAOR.GIF");
    public static final ImageDescriptor IMGD_QUIESCED_ACTIVE_AOR = UIPlugin.getImageDescriptor("icons/WLMAWAOR.GIF", 1);
    public static final ImageDescriptor IMGD_WLMSPEC = UIPlugin.getImageDescriptor("icons/WLMSPEC.GIF");
    public static final ImageDescriptor IMGD_WLMDEF = UIPlugin.getImageDescriptor("icons/WLMDEF.GIF");
    public static final ImageDescriptor IMGD_WLMAWDEF = UIPlugin.getImageDescriptor("icons/WLMAWDEF.GIF");
    public static final ImageDescriptor IMGD_ACTIVE_WORKLOAD_TRANGROUP = UIPlugin.getImageDescriptor("icons/WLMATGRP.GIF");
    public static final ImageDescriptor IMGD_ACTIVE_TOR = UIPlugin.getImageDescriptor("icons/WLMAWTOR.GIF");
    public static final ImageDescriptor IMGD_MANAGED_REGION = UIPlugin.getImageDescriptor("icons/MAS.GIF");
    public static final ImageDescriptor IMGD_DISABLED_MANAGED_REGION = UIPlugin.getImageDescriptor("icons/MAS.GIF", 1);
    public static final ImageDescriptor IMGD_CMASLIST = UIPlugin.getImageDescriptor("icons/CMASLIST.GIF");
    public static final ImageDescriptor IMGD_DISABLED_CMASLIST = UIPlugin.getImageDescriptor("icons/CMASLIST.GIF", 1);
    public static final ImageDescriptor IMGD_CICSPLEX_DEFINITION = UIPlugin.getImageDescriptor("icons/CPLEXDEF.GIF");
    public static final ImageDescriptor IMGD_SYSTEM_GROUP_DEFINITION = UIPlugin.getImageDescriptor("icons/CSYSGRP.GIF");
    public static final ImageDescriptor IMGD_SYSTEM_DEFINITION = UIPlugin.getImageDescriptor("icons/CSYSDEF.GIF");
    public static final ImageDescriptor IMGD_RESOURCE_GROUP_DEFINITION = UIPlugin.getImageDescriptor("icons/RESGROUP.GIF");
    public static final ImageDescriptor IMGD_RESOURCE_DESCRIPTION_DEFINITION = UIPlugin.getImageDescriptor("icons/RESDESC.GIF");
    public static final ImageDescriptor IMGD_FILE_DEFINITION = UIPlugin.getImageDescriptor("icons/FILEDEF.GIF");
    public static final ImageDescriptor IMGD_PROGRAM_DEFINITION = UIPlugin.getImageDescriptor("icons/PROGDEF.GIF");
    public static final ImageDescriptor IMGD_TRANSACTION_DEFINITION = UIPlugin.getImageDescriptor("icons/TRANDEF.GIF");
    public static final ImageDescriptor IMGD_TDQ_DEFINITION = UIPlugin.getImageDescriptor("icons/TDQDEF.GIF");
    public static final ImageDescriptor IMGD_CICSPLEX_REPOSITORY = UIPlugin.getImageDescriptor("icons/repository_rep.gif");
    public static final ImageDescriptor IMGD_INACTIVE_CICSPLEX_REPOSITORY = UIPlugin.getImageDescriptor("icons/repository_rep.gif", 1);
    public static final ImageDescriptor IMGD_FILE = UIPlugin.getImageDescriptor("icons/FILE.GIF");
    public static final ImageDescriptor IMGD_TASK = UIPlugin.getImageDescriptor("icons/TASK.GIF");
    public static final ImageDescriptor IMGD_OPERATION = UIPlugin.getImageDescriptor("icons/OPERATION.GIF");
    public static final ImageDescriptor IMGD_PROGRAM = UIPlugin.getImageDescriptor("icons/PROGRAM.GIF");
    public static final ImageDescriptor IMGD_TRANSACTION = UIPlugin.getImageDescriptor("icons/TRAN.GIF");
    public static final ImageDescriptor IMGD_URIMAP = UIPlugin.getImageDescriptor("icons/URIMAP.GIF");
    public static final ImageDescriptor IMGD_APPLICATION_GROUP = UIPlugin.getImageDescriptor("icons/group_application.gif");
    public static final ImageDescriptor IMGD_REGION_TYPE_GROUP = UIPlugin.getImageDescriptor("icons/group_region_type.gif");
    public static final ImageDescriptor IMGD_OPERATION_GROUP = UIPlugin.getImageDescriptor("icons/group_operation.gif");
    public static final ImageDescriptor IMGD_RULES_SEARCH_HIT = UIPlugin.getImageDescriptor("icons/full/elcl16/occ_match.gif");
    public static final ImageDescriptor IMGD_CMTPMLNK = UIPlugin.getImageDescriptor("icons/CMTPMLNK.GIF");
    public static final ImageDescriptor IMGD_WUI = UIPlugin.getImageDescriptor("icons/current_co.gif");
    public static final ImageDescriptor IMGD_WLM_STATUS_ACTIVE = UIPlugin.getImageDescriptor("icons/methpri_obj.gif");
    public static final ImageDescriptor IMGD_REFRESH = UIPlugin.getImageDescriptor("icons/full/elcl16/refresh.gif");
    public static final ImageDescriptor IMGD_DELETE_SORT = UIPlugin.getImageDescriptor("icons/deletesort.gif");
    public static final ImageDescriptor IMGD_LINK_TO_SELECTION = UIPlugin.getImageDescriptor("icons/full/elcl16/synced.gif");
    public static final ImageDescriptor EXECUTE_WIZ_BAN = UIPlugin.getImageDescriptor("icons/full/wizban/execute.gif");
    public static final ImageDescriptor IMGD_ERROR = UIPlugin.getImageDescriptor("icons/full/elcl16/error.gif");
    public static final ImageDescriptor IMGD_ERROR_LARGE = UIPlugin.getImageDescriptor("icons/full/elcl16/error_large.gif");
    public static final ImageDescriptor IMGD_ERROR_OVERLAY = UIPlugin.getImageDescriptor("icons/full/elcl16/error_overlay.gif");
    public static final ImageDescriptor IMGD_ERROR_CONTENT_OVERLAY = UIPlugin.getImageDescriptor("icons/full/elcl16/error_ovr.gif");
    public static final ImageDescriptor IMGD_WARNING = UIPlugin.getImageDescriptor("icons/full/elcl16/warn.gif");
    public static final ImageDescriptor IMGD_WARNING_MEDIUM = UIPlugin.getImageDescriptor("icons/full/elcl16/warning_st_obj.gif");
    public static final ImageDescriptor IMGD_WARNING_OVERLAY = UIPlugin.getImageDescriptor("icons/full/elcl16/warning_overlay.gif");
    public static final ImageDescriptor IMGD_INFORMATION = UIPlugin.getImageDescriptor("icons/full/elcl16/information.gif");
    public static final ImageDescriptor IMGD_UPDATE_ERROR_OVERLAY = UIPlugin.getImageDescriptor("icons/full/elcl16/server_error_overlay.gif");
    public static final ImageDescriptor IMGD_ERROR_ARROW = UIPlugin.getImageDescriptor("icons/full/elcl16/right_arrow_err.gif");
    public static final ImageDescriptor IMGD_RIGHT_ARROW = UIPlugin.getImageDescriptor("icons/full/elcl16/right_arrow_nav.gif");
    public static final ImageDescriptor IMGD_DOWN_ARROW = UIPlugin.getImageDescriptor("icons/down_arrow.png");
    public static final ImageDescriptor IMGD_RESET_PROPERTY = UIPlugin.getImageDescriptor("icons/full/elcl16/default_ps.gif");
    public static final ImageDescriptor IMGD_RESET_PROPERTY_DISABLED = UIPlugin.getImageDescriptor("icons/full/dlcl16/default_ps.gif.gif");
    public static final ImageDescriptor IMGD_EDITABLE_PROPERTY = UIPlugin.getImageDescriptor("icons/full/elcl16/edit_obj.gif");
    public static final ImageDescriptor IMGD_SAVE = UIPlugin.getImageDescriptor("icons/full/elcl16/save.gif");
    public static final ImageDescriptor IMGD_SAVE_DISABLED = UIPlugin.getImageDescriptor("icons/full/dlcl16/save.gif");
    public static final ImageDescriptor IMGD_EXPAND_ALL = UIPlugin.getImageDescriptor("icons/expandall.gif");
    public static final ImageDescriptor IMGD_COLLAPSE_ALL = UIPlugin.getImageDescriptor("icons/collapseall.gif");
    public static final ImageDescriptor IMGD_CSYSGRP_PLATFROM = UIPlugin.getImageDescriptor("icons/CSYSGRP_Decorator.gif");
    public static final ImageDescriptor IMGD_CSD_REP = UIPlugin.getImageDescriptor("icons/csd_repository.gif");
    public static final ImageDescriptor IMGD_DREP_REP = UIPlugin.getImageDescriptor("icons/drep_repository.gif");
    private static final Logger logger = Logger.getLogger(UIPlugin.class.getPackage().getName());
    @Deprecated
    public static final String SYSTEM_MANAGER_CONNECTION_ID = "com.ibm.cics.sm.connection";
    private static final String CONNECTIONS_NODE_NAME = "connections";
    public static Color COLOR_UNSUPPORTED_ATTRIBUTE;
    private static UIPlugin plugin;
    public static Color COLOR_LABEL_DECORATOR;
    private Map<ImageDescriptor, Image> imageTable = new HashMap<ImageDescriptor, Image>();
    private Map<Class<? extends IContext>, IContext> selectedContexts = new HashMap<Class<? extends IContext>, IContext>();
    private Map<Class<? extends IContext>, Object> selectedObjects = new HashMap<Class<? extends IContext>, Object>();
    private ConnectionContextManager connectionContextManager;
    private final IConnectionService connectionService;
    private EmptyEditorAreaHider editorAreaHider;
    private final List<IViewPart> transientViews = new ArrayList<IViewPart>();
    private IWorkbenchListener closeTransientViewsListener;
    private ConnectionServiceListener clearContextListener = new ConnectionServiceListener(){

        public void event(ConnectionServiceListener.ConnectionServiceEvent event) {
            if (event.getConnectionCategoryId().equals(UIPlugin.SYSTEM_MANAGER_CONNECTION_ID) && event instanceof ConnectionServiceListener.DisconnectedEvent) {
                UIPlugin.this.setContext(null);
                UIPlugin.this.setSelectedObject(null);
            }
        }
    };
    private String overriddenConnectionCategory = null;

    public UIPlugin() {
        this.connectionService = ConnectionsPlugin.getDefault().getConnectionService();
        this.connectionService.setConnectable(SYSTEM_MANAGER_CONNECTION_ID, (IConnectable)CICSCore.getCPSM());
    }

    void init(IWorkbenchWindow workbenchWindow) {
        COLOR_UNSUPPORTED_ATTRIBUTE = Display.getCurrent().getSystemColor(26);
        Debug.enter((Logger)logger, (String)UIPlugin.class.getName(), (String)"init", (Object)((Object)this), (Object)workbenchWindow);
        if (Debug.DEBUG_GENERAL) {
            logger.setLevel(Level.FINER);
        }
        this.editorAreaHider = new EmptyEditorAreaHider(workbenchWindow, new String[]{"com.ibm.cics.core.ui.sm", "com.ibm.cics.cm", "com.ibm.cics.ia", "com.ibm.cics.pa", "com.ibm.ctg.ui"});
        this.addSelectionService(workbenchWindow);
        this.connectionContextManager = new ConnectionContextManager(ConnectionsPlugin.getDefault().getConnectionService());
        COLOR_LABEL_DECORATOR = new Color((Device)Display.getDefault(), 148, 123, 66);
        Debug.exit((Logger)logger, (String)UIPlugin.class.getName(), (String)"init");
    }

    private void addSelectionService(IWorkbenchWindow workbenchWindow) {
        workbenchWindow.getSelectionService().addSelectionListener(new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                IStructuredSelection structuredSelection;
                Object firstElement;
                if (selection instanceof IStructuredSelection && (firstElement = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) != null) {
                    IContext newContext = UIPlugin.this.getContextFor(firstElement);
                    Debug.event((Logger)logger, (String)UIPlugin.class.getName(), (String)"selectionChanged", (Object)this, (Object)part, (Object)firstElement);
                    if (newContext != null) {
                        Class contextType = newContext instanceof ICMASContext ? ICMASContext.class : IContext.class;
                        UIPlugin.this.setContext(contextType, newContext);
                        UIPlugin.this.setSelectedObject(contextType, firstElement);
                    }
                }
            }
        });
    }

    private IContext getContextFor(Object element) {
        Object elementContext = null;
        String adapterTypeName = IContextProvider.class.getName();
        IContextProvider adapter = (IContextProvider)Platform.getAdapterManager().loadAdapter(element, adapterTypeName);
        if (adapter != null) {
            elementContext = adapter.getIContext();
        } else {
            if (element instanceof IContextProvider) {
                IContextProvider provider = (IContextProvider)element;
                return provider.getIContext();
            }
            if (element instanceof ICMASList) {
                final String cmasName = ((ICMASList)element).getName();
                elementContext = new ICMASContext(){

                    public String getContext() {
                        return cmasName;
                    }
                };
            }
        }
        return elementContext;
    }

    public static IEclipsePreferences getPluginInstancePreferences() {
        return InstanceScope.INSTANCE.getNode(PLUGIN_ID);
    }

    protected void initializeImageRegistry(final ImageRegistry reg) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                reg.put(TRANSID, UIPlugin.getImageDescriptor("icons/LOCTRAN.GIF"));
                reg.put(CREATE_TRAN_DEF, UIPlugin.getImageDescriptor("icons/create_tran_def.gif"));
                reg.put(CONTENT_ASSIST_CUE, UIPlugin.getImageDescriptor("icons/content_assist_cue.gif"));
                reg.put(NEW_WIZARD_BANNER, UIPlugin.getImageDescriptor("icons/full/wizban/new_wiz.png"));
                reg.put(RESOURCE_GROUP, UIPlugin.getImageDescriptor("icons/activity.gif"));
                reg.put(WARNING, UIPlugin.getImageDescriptor("icons/full/elcl16/warn.gif"));
                reg.put(LOCKED_OVERLAY, UIPlugin.getImageDescriptor("icons/statusLocked_obj10.gif"));
                reg.put(WARNING_OVERLAY, UIPlugin.getImageDescriptor("icons/full/elcl16/warning_overlay.gif"));
                reg.put(ERROR_OVERLAY, UIPlugin.getImageDescriptor("icons/full/elcl16/error_ovr.gif"));
                reg.put(CONNECTED_OVERLAY, UIPlugin.getImageDescriptor("icons/full/ovr16/connected_ovr.gif"));
                reg.put(DROP_DOWN_ARROW, UIPlugin.getImageDescriptor("icons/full/elcl16/dropdownarrow.gif"));
                reg.put(ERROR, UIPlugin.getImageDescriptor("icons/full/elcl16/error.gif"));
                reg.put(ENABLED, UIPlugin.getImageDescriptor("icons/ENABLED.GIF"));
                reg.put(DISABLED, UIPlugin.getImageDescriptor("icons/DISABLED.GIF"));
                reg.put(UNENABLED, UIPlugin.getImageDescriptor("icons/DISABLED.GIF"));
                reg.put(ACTIVE, UIPlugin.getImageDescriptor("icons/ENABLED.GIF"));
                reg.put(INSERVICE, UIPlugin.getImageDescriptor("icons/ENABLED.GIF"));
                reg.put(TRUE, UIPlugin.getImageDescriptor("icons/ENABLED.GIF"));
                reg.put(FALSE, UIPlugin.getImageDescriptor("icons/DISABLED.GIF"));
                reg.put(RUNNING, UIPlugin.getImageDescriptor("icons/running.gif"));
                reg.put(DISPATCHABLE, UIPlugin.getImageDescriptor("icons/dispatchable.gif"));
                reg.put(SUSPENDED, UIPlugin.getImageDescriptor("icons/suspended.gif"));
                reg.put(RUN_FILTER, UIPlugin.getImageDescriptor("icons/full/elcl16/run.gif"));
                reg.put(CLEAR_FILTER, UIPlugin.getImageDescriptor("icons/clear_filter.gif"));
                reg.put(EXCI, UIPlugin.getImageDescriptor("icons/full/elcl16/exci.gif"));
                reg.put(IPIC, UIPlugin.getImageDescriptor("icons/full/elcl16/ipic.gif"));
                reg.put(TCP, UIPlugin.getImageDescriptor("icons/full/elcl16/tcpip.gif"));
                reg.put(SNA, UIPlugin.getImageDescriptor("icons/full/elcl16/sna.gif"));
                reg.put(ERROR_WIZARD_BANNER, (ImageDescriptor)new WizardBannerImageDescriptor(ImageDescriptor.createFromImage((Image)Display.getCurrent().getSystemImage(1))));
                reg.put(WARNING_WIZARD_BANNER, (ImageDescriptor)new WizardBannerImageDescriptor(ImageDescriptor.createFromImage((Image)Display.getCurrent().getSystemImage(8))));
                reg.put(QUESTION_WIZARD_BANNER, (ImageDescriptor)new WizardBannerImageDescriptor(ImageDescriptor.createFromImage((Image)Display.getCurrent().getSystemImage(4))));
                reg.put(BUNDLE, UIPlugin.getImageDescriptor("icons/BUNDLE.GIF"));
            }
        };
        if (Display.getCurrent() == null) {
            Display.getDefault().syncExec(runnable);
        } else {
            runnable.run();
        }
    }

    public static Image getImage(String ID) {
        return UIPlugin.getDefault().getImageRegistry().get(ID);
    }

    public static Image getImage(ImageDescriptor descriptor) {
        Image image = UIPlugin.plugin.imageTable.get(descriptor);
        if (image == null) {
            image = descriptor.createImage();
            UIPlugin.plugin.imageTable.put(descriptor, image);
        }
        return image;
    }

    public void start(BundleContext context) throws Exception {
        Debug.enter((Logger)logger, (String)UIPlugin.class.getName(), (String)"start", (Object)context);
        super.start(context);
        plugin = this;
        this.closeTransientViewsListener = new IWorkbenchListener(){

            public boolean preShutdown(IWorkbench workbench, boolean forced) {
                UIPlugin.this.closeTransientViews();
                return true;
            }

            public void postShutdown(IWorkbench workbench) {
            }
        };
        PlatformUI.getWorkbench().addWorkbenchListener(this.closeTransientViewsListener);
        ConnectionManager connectionManager = InternalConnectionsPlugin.getDefault().getConnectionService().getConnectionManager();
        ICredentialsManager credentialsManager = connectionManager.getCredentialsManager();
        WritableConnectionProvider localConnectionProvider = ConnectionProviderRegistry.getDefault().getLocalConnectionProvider();
        this.connectionService.addConnectionServiceListener(this.clearContextListener);
        IConnectionPasswordStorage oldPasswordStorage = IConnectionPasswordStorage.Factory.create((String)PLUGIN_ID);
        IEclipsePreferences preferences = new InstanceScope().getNode(PLUGIN_ID);
        OldCredentialsReader credentialsReader = new OldCredentialsReader((Preferences)preferences, oldPasswordStorage);
        CredentialsPreferenceMigrator credMigrator = new CredentialsPreferenceMigrator(credentialsManager, credentialsReader, true);
        credMigrator.migrate();
        if (preferences.nodeExists(CONNECTIONS_NODE_NAME)) {
            Preferences connectionsNode = preferences.node(CONNECTIONS_NODE_NAME);
            OldConnectionReader connectionReader = new OldConnectionReader(connectionsNode, true);
            ConnectionParameterImporter migrator = new ConnectionParameterImporter(ConnectionRegistry.getConnectionRegistry(), localConnectionProvider);
            migrator.importConnections((IConnectionDeserializer)connectionReader, false);
            connectionsNode.removeNode();
        }
        Debug.exit((Logger)logger, (String)UIPlugin.class.getName(), (String)"start", (Object)context);
    }

    public void stop(BundleContext context) throws Exception {
        if (this.editorAreaHider != null) {
            this.editorAreaHider.dispose();
        }
        try {
            try {
                Bundle resPluginBundle = Platform.getBundle((String)"org.eclipse.core.resources");
                if (resPluginBundle != null && resPluginBundle.getState() == 32) {
                    IWorkspace workspace = ResourcesPlugin.getWorkspace();
                    workspace.save(true, (IProgressMonitor)new NullProgressMonitor());
                }
            }
            catch (Exception e) {
                this.getLog().log((IStatus)new Status(4, PLUGIN_ID, "Failed to save and stop the Workspace", (Throwable)e));
            }
            if (this.connectionContextManager != null) {
                this.connectionContextManager.dispose();
            }
            this.imageTable = null;
            plugin = null;
            if (this.closeTransientViewsListener != null) {
                PlatformUI.getWorkbench().removeWorkbenchListener(this.closeTransientViewsListener);
            }
        }
        finally {
            super.stop(context);
        }
    }

    public static UIPlugin getDefault() {
        return plugin;
    }

    public Handler getInMemoryHandler() {
        return Activator.getDefault().getInMemoryHandler();
    }

    public static void logInfo(String message) {
        UIPlugin.log(1, message, null);
    }

    public static void logWarning(String message) {
        UIPlugin.logWarning(message, null);
    }

    public static void showWarning(String message, ViewPart viewPart) {
        IActionBars actionBars = viewPart.getViewSite().getActionBars();
        actionBars.getStatusLineManager().setMessage(UIPlugin.getImage(IMGD_WARNING), message);
        actionBars.updateActionBars();
        UIPlugin.logWarning(message, null);
    }

    public static void logWarning(String message, Throwable t) {
        UIPlugin.log(2, message, t);
    }

    public static void logError(String message) {
        UIPlugin.logError(message, null);
    }

    public static void logError(Throwable t) {
        UIPlugin.logError(t.getLocalizedMessage(), t);
    }

    public static void logError(String message, Throwable t) {
        UIPlugin.log(4, message, t);
    }

    public static void log(IStatus status) {
        UIPlugin.getDefault().getLog().log(status);
    }

    private static void log(int severity, String message, Throwable t) {
        Status status = new Status(severity, PLUGIN_ID, severity, message, t);
        UIPlugin.getDefault().getLog().log((IStatus)status);
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return UIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public static ImageDescriptor getImageDescriptor(String path, int flag) {
        ImageDescriptor descriptor = UIPlugin.getImageDescriptor(path);
        descriptor = ImageDescriptor.createWithFlags((ImageDescriptor)descriptor, (int)flag);
        return descriptor;
    }

    public ConnectionContextManager getConnectionContextManager() {
        return this.connectionContextManager;
    }

    public IContext getContext(Class<? extends IContext> contextType) {
        IContext context = this.selectedContexts.get(contextType);
        Debug.event((Logger)logger, (String)UIPlugin.class.getName(), (String)"getContext", contextType, (Object)context);
        return context;
    }

    public IContext getContext() {
        return this.getContext(IContext.class);
    }

    private void setContext(Class<? extends IContext> contextType, IContext newContext) {
        Debug.event((Logger)logger, (String)UIPlugin.class.getName(), (String)"setContext", contextType, (Object)newContext);
        this.selectedContexts.put(contextType, newContext);
    }

    private void setContext(IContext newContext) {
        this.setContext(IContext.class, newContext);
    }

    public Object getSelectedObject() {
        return this.getSelectedObject(IContext.class);
    }

    public Object getSelectedObject(Class<? extends IContext> contextType) {
        Object object = this.selectedObjects.get(contextType);
        Debug.event((Logger)logger, (String)UIPlugin.class.getName(), (String)"getSelectedObject", contextType, (Object)object);
        return object;
    }

    private void setSelectedObject(Object newSelectedObject) {
        this.setSelectedObject(IContext.class, newSelectedObject);
    }

    private void setSelectedObject(Class<? extends IContext> contextType, Object newSelectedObject) {
        Debug.event((Logger)logger, (String)UIPlugin.class.getName(), (String)"setContext", contextType, (Object)newSelectedObject);
        this.selectedObjects.put(contextType, newSelectedObject);
    }

    public static void performDefaultViewAction(ICICSObject aCICSObject) {
        Debug.enter((Logger)logger, (String)UIPlugin.class.getName(), (String)"performDefaultViewAction", (Object)aCICSObject);
        IActionFilter actionFilter = (IActionFilter)Platform.getAdapterManager().getAdapter((Object)aCICSObject, IActionFilter.class);
        if (actionFilter != null && actionFilter.testAttribute((Object)aCICSObject, "mutable", "true")) {
            try {
                Bundle editorsBundle = Platform.getBundle((String)"com.ibm.cics.core.ui.editors");
                Class editCICSObjectAction = editorsBundle.loadClass("com.ibm.cics.core.ui.editors.actions.EditCICSObjectAction");
                IObjectActionDelegate editResourceDefinitionAction = (IObjectActionDelegate)editCICSObjectAction.newInstance();
                editResourceDefinitionAction.setActivePart(null, PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart());
                editResourceDefinitionAction.selectionChanged(null, (ISelection)new StructuredSelection((Object)aCICSObject));
                editResourceDefinitionAction.run(null);
            }
            catch (Exception ex) {
                Debug.error((Logger)logger, (String)UIPlugin.class.getName(), (String)"performDefaultViewAction", (Throwable)ex);
            }
        }
        Debug.exit((Logger)logger, (String)UIPlugin.class.getName(), (String)"performDefaultViewAction");
    }

    public static Image getTableImage(String resourceTableName) {
        ImageDescriptor imageDescriptor;
        if (UIPlugin.getDefault() == null) {
            return null;
        }
        Image image = UIPlugin.getImage("icons/" + resourceTableName + ".GIF");
        if (image == null && (image = UIPlugin.getDefault().getImageRegistry().get("icons/" + resourceTableName)) == null && (imageDescriptor = UIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)("icons/" + resourceTableName + ".GIF"))) != null) {
            image = UIPlugin.getImage(imageDescriptor);
            UIPlugin.getDefault().getImageRegistry().put("icons/" + resourceTableName, image);
        }
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTransientView(final IViewPart view) {
        List<IViewPart> list = this.transientViews;
        synchronized (list) {
            this.transientViews.add(view);
            view.getViewSite().getPage().addPartListener(new IPartListener2(){

                public void partVisible(IWorkbenchPartReference partRef) {
                }

                public void partOpened(IWorkbenchPartReference partRef) {
                }

                public void partInputChanged(IWorkbenchPartReference partRef) {
                }

                public void partHidden(IWorkbenchPartReference partRef) {
                }

                public void partDeactivated(IWorkbenchPartReference partRef) {
                }

                public void partClosed(IWorkbenchPartReference partRef) {
                    if (partRef.getPart(false).equals(view)) {
                        UIPlugin.this.transientViews.remove(view);
                    }
                }

                public void partBroughtToTop(IWorkbenchPartReference partRef) {
                }

                public void partActivated(IWorkbenchPartReference partRef) {
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeTransientViews() {
        List<IViewPart> list = this.transientViews;
        synchronized (list) {
            Iterator<IViewPart> iterator = this.transientViews.iterator();
            while (iterator.hasNext()) {
                IWorkbenchPage page;
                IViewPart view = iterator.next();
                iterator.remove();
                IViewSite viewSite = view.getViewSite();
                if (viewSite == null || (page = viewSite.getPage()) == null) continue;
                page.hideView(view);
            }
            this.transientViews.clear();
        }
    }

    @Deprecated
    public String getCurrentConnectionCategory() {
        if (this.overriddenConnectionCategory != null) {
            return this.overriddenConnectionCategory;
        }
        String activeConnectionCategory = ConnectionsPlugin.getDefault().getActiveConnectionCategoryService().getActiveConnectionCategory();
        return activeConnectionCategory != null ? activeConnectionCategory : SYSTEM_MANAGER_CONNECTION_ID;
    }

    @Deprecated
    public void setCurrentConnectionCategory(String connectionCategory) {
        this.overriddenConnectionCategory = connectionCategory;
    }

    @Deprecated
    public void signOff() {
        this.connectionService.signOff();
    }
}

