/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.actions;

import com.ibm.cics.core.ui.Debug;
import com.ibm.cics.eclipse.common.ViewHelper;
import com.ibm.cics.eclipse.common.ops.IOperationUIDelegate;
import com.ibm.cics.eclipse.common.ops.PerformActionDialog;
import java.util.List;
import java.util.logging.Logger;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionDelegate;

public abstract class AbstractPerformOperationActionDelegate<T>
extends ActionDelegate
implements IObjectActionDelegate {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2012 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(AbstractPerformOperationActionDelegate.class.getPackage().getName());
    protected ISelection selection;
    private IWorkbenchPart targetPart;

    protected abstract IOperationUIDelegate<? super T> getOperationUIDelegate() throws CICSObjectActionException;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.targetPart = targetPart;
    }

    public void run(IAction action) {
        block9: {
            Debug.enter((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"run", (Object)((Object)this));
            List<T> targets = this.getTargets(this.selection);
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            if (this.targetPart != null) {
                ViewHelper.setTargetPart((IWorkbenchPart)this.targetPart);
            }
            try {
                try {
                    IOperationUIDelegate<T> operationUIDelegate = this.getOperationUIDelegate();
                    PerformActionDialog wizard = new PerformActionDialog(shell, operationUIDelegate, targets);
                    wizard.setBlockOnOpen(true);
                    wizard.open();
                }
                catch (CICSObjectActionException ex) {
                    Debug.error((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"run", (Throwable)ex);
                    if (this.targetPart != null) {
                        ViewHelper.unsetTargetPart((IWorkbenchPart)this.targetPart);
                    }
                    break block9;
                }
            }
            catch (Throwable throwable) {
                if (this.targetPart != null) {
                    ViewHelper.unsetTargetPart((IWorkbenchPart)this.targetPart);
                }
                throw throwable;
            }
            if (this.targetPart != null) {
                ViewHelper.unsetTargetPart((IWorkbenchPart)this.targetPart);
            }
        }
        Debug.exit((Logger)logger, (String)((Object)((Object)this)).getClass().getName(), (String)"run");
    }

    protected abstract List<? extends T> getTargets(ISelection var1);

    public final void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }

    public static class CICSObjectActionException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public CICSObjectActionException(String errorMessage) {
            super(errorMessage);
        }

        public CICSObjectActionException(String errorMessage, Throwable th) {
            super(errorMessage, th);
        }
    }
}

