/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.actions;

import com.ibm.cics.core.model.CICSSystemManagerException;
import com.ibm.cics.core.model.ICoreObject;
import com.ibm.cics.core.ui.ExceptionMessageHelper;
import com.ibm.cics.core.ui.actions.AbstractPerformOperationActionDelegate;
import com.ibm.cics.core.ui.actions.Messages;
import com.ibm.cics.core.ui.adapters.WLMRuleAdapter;
import com.ibm.cics.core.ui.decorators.CICSObjectLabelProvider;
import com.ibm.cics.eclipse.common.ops.DefaultOperationUIDelegate;
import com.ibm.cics.eclipse.common.ops.ExecutionFailedException;
import com.ibm.cics.eclipse.common.ops.IOperationExecutionDelegate;
import com.ibm.cics.eclipse.common.ops.IOperationUIDelegate;
import com.ibm.cics.model.CICSActionException;
import com.ibm.cics.model.IActiveWorkloadDefinition;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.sm.comm.SystemManagerActions;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;

public class DiscardActiveWorkloadRuleAction
extends AbstractPerformOperationActionDelegate<IActiveWorkloadDefinition> {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";

    @Override
    protected IOperationUIDelegate<? super IActiveWorkloadDefinition> getOperationUIDelegate() throws AbstractPerformOperationActionDelegate.CICSObjectActionException {
        return new DefaultOperationUIDelegate((IOperationExecutionDelegate)new DiscardActiveWorkloadRuleExecutionDelegate(), (ILabelProvider)new CICSObjectLabelProvider());
    }

    @Override
    protected List<? extends IActiveWorkloadDefinition> getTargets(ISelection selection) {
        if (((StructuredSelection)selection).getFirstElement() instanceof WLMRuleAdapter) {
            return this.getRuleListFromSelection(selection);
        }
        return ((StructuredSelection)selection).toList();
    }

    private List<? extends IActiveWorkloadDefinition> getRuleListFromSelection(ISelection selection) {
        ArrayList<IActiveWorkloadDefinition> workloads = new ArrayList<IActiveWorkloadDefinition>();
        for (Object object : ((StructuredSelection)selection).toList()) {
            workloads.add(((WLMRuleAdapter)object).getAdaptedRule());
        }
        return workloads;
    }

    private class DiscardActiveWorkloadRuleExecutionDelegate
    implements IOperationExecutionDelegate<IActiveWorkloadDefinition> {
        public void execute(IActiveWorkloadDefinition rule) throws ExecutionFailedException {
            try {
                ((ICoreObject)rule).getCPSM().discard((ICICSObject)rule);
            }
            catch (CICSSystemManagerException e) {
                IStatus errorMessage = ExceptionMessageHelper.getStatus((CICSActionException)e, rule.getObjectType(), 2);
                throw new ExecutionFailedException(errorMessage);
            }
        }

        public String getOperationName() {
            return SystemManagerActions.Discard.getActionName();
        }

        public String getOperationDescription(IActiveWorkloadDefinition target) {
            return Messages.getString("operation.perform.description", this.getOperationName(), ExceptionMessageHelper.getObjectTypeDescription((ICICSObject)target), target.getName(), ExceptionMessageHelper.getContextOrScopeNameFor((ICoreObject)target));
        }

        public int getID() {
            return 605;
        }
    }
}

