/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.adapters;

import com.ibm.cics.core.model.CICSRegionGroupDefinitionType;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.ICoreObject;
import com.ibm.cics.core.model.mutable.IMutableCoreObject;
import com.ibm.cics.core.ui.Debug;
import com.ibm.cics.core.ui.UIPlugin;
import com.ibm.cics.core.ui.properties.CICSObjectPropertyDescriptor;
import com.ibm.cics.core.ui.properties.CICSObjectPropertySource;
import com.ibm.cics.model.IBundle;
import com.ibm.cics.model.ICICSAttribute;
import com.ibm.cics.model.ICICSDefinition;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICICSRegionGroupDefinition;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.model.IDefinition;
import com.ibm.cics.model.IIPICConnection;
import com.ibm.cics.model.IManagedRegion;
import com.ibm.cics.model.IProgram;
import com.ibm.cics.model.ITaskAssociation;
import com.ibm.cics.model.IWorkload;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.sm.comm.ContextHelper;
import com.ibm.cics.sm.comm.IApplicationContext;
import com.ibm.cics.sm.comm.ICICSAction;
import com.ibm.cics.sm.comm.ICICSOperation;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.IDefinitionContext;
import com.ibm.cics.sm.comm.IPrimaryKey;
import com.ibm.cics.sm.comm.SystemManagerActions;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.ui.IActionFilter;

public class ActionFilterAdapterFactory
implements IAdapterFactory {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(ActionFilterAdapterFactory.class.getPackage().getName());
    private IActionFilter cicsObjectActionFilter = new IActionFilter(){

        public boolean testAttribute(Object target, String name, String value) {
            Debug.enter((Logger)logger, (String)ActionFilterAdapterFactory.class.getName(), (String)"testAttribute", (Object)this, (Object)target, (Object)name, (Object)value);
            boolean result = false;
            if (name.equals("mutable")) {
                result = this.existsMutableDefinition((ICoreObject)target);
            } else if (name.equals("update") && target instanceof ICICSObject) {
                boolean permitted;
                ICICSObject object = (ICICSObject)target;
                ICPSM cpsm = ((ICoreObject)object).getCPSM();
                result = permitted = cpsm.checkPermission(ICICSOperation.UPDATE, object);
            } else if (name.equals("remove")) {
                if (target instanceof IWorkload) {
                    ICPSM cpsm = ((ICoreObject)target).getCPSM();
                    result = cpsm.checkPermission((ICICSOperation)SystemManagerActions.Remove, (ICICSType)CICSRegionGroupDefinitionType.getInstance());
                } else if (target instanceof ICICSDefinition) {
                    ICICSDefinition object = (ICICSDefinition)target;
                    ICPSM cpsm = ((ICoreObject)object).getCPSM();
                    boolean permitted = cpsm.checkPermission((ICICSOperation)SystemManagerActions.Remove, (ICICSObject)object);
                    result = permitted && this.isGroupSelected();
                }
            } else if (name.equals("install") && target instanceof IDefinition) {
                ICICSObject object = (ICICSObject)target;
                ICPSM cpsm = ((ICoreObject)target).getCPSM();
                result = cpsm.checkPermission((ICICSOperation)SystemManagerActions.Install, object);
            } else if (name.equals("delete") && target instanceof ICICSObject) {
                ICICSObject object = (ICICSObject)target;
                ICPSM cpsm = ((ICoreObject)object).getCPSM();
                result = cpsm.checkPermission(ICICSOperation.DELETE, object);
            } else if (name.equals("installedByBundle") && target instanceof ICICSObject) {
                ICICSObject object = (ICICSObject)target;
                result = ActionFilterAdapterFactory.isInstalledByBundle(object);
                if (!"true".equals(value)) {
                    result = !result;
                }
            } else if (name.equals("perform") && value.equals("EventProcessing") && target instanceof IManagedRegion) {
                ICICSObject object = (ICICSObject)target;
                ICPSM cpsm = ((ICoreObject)target).getCPSM();
                result = cpsm.checkPermission((ICICSOperation)SystemManagerActions.EventProcessing, object);
            } else if (name.equals("perform") && target instanceof ICICSObject) {
                ICICSAction action = this.getActionFor(value);
                if (action != null) {
                    ICICSObject object = (ICICSObject)target;
                    ICPSM cpsm = ((ICoreObject)object).getCPSM();
                    result = cpsm.checkPermission((ICICSOperation)action, object);
                }
            } else if (name.equals("bundleHasAvailability") && target instanceof IBundle) {
                IBundle bundle = (IBundle)target;
                result = ActionFilterAdapterFactory.canBundleBeMadeAvailable(bundle);
                if (!"true".equals(value)) {
                    result = !result;
                }
            } else {
                if (name.equals("lockedByPlatform")) {
                    if (value == null) {
                        value = "true";
                    }
                    boolean expected = Boolean.parseBoolean(value);
                    if (target instanceof ICICSRegionGroupDefinition) {
                        ICICSRegionGroupDefinition groupDef = (ICICSRegionGroupDefinition)target;
                        String platdef = groupDef.getPlatdef();
                        if (platdef != null && !platdef.equals(CICSRegionGroupDefinitionType.PLATDEF.getUnsupportedValue()) && !platdef.isEmpty()) {
                            return expected;
                        }
                        return !expected;
                    }
                    return !expected;
                }
                if (target instanceof ICICSRegionGroupDefinition) {
                    ICICSRegionGroupDefinition group = (ICICSRegionGroupDefinition)target;
                    if (name.equals("isRegionType")) {
                        String regiontype = group.getRegiontype();
                        if (value.equals("true")) {
                            return !regiontype.equals(CICSRegionGroupDefinitionType.REGIONTYPE.getUnsupportedValue()) && regiontype.length() > 0;
                        }
                        return regiontype.equals(CICSRegionGroupDefinitionType.REGIONTYPE.getUnsupportedValue()) || regiontype.length() == 0;
                    }
                } else if (name.equals("originIpIs0000")) {
                    boolean expected = Boolean.parseBoolean(value);
                    String sourceIP = null;
                    if (target instanceof ITaskAssociation) {
                        sourceIP = ((ITaskAssociation)target).getOriginIPAddress();
                    } else if (target instanceof IIPICConnection) {
                        sourceIP = ((IIPICConnection)target).getIpresolved();
                    }
                    result = "0.0.0.0".equals(sourceIP) == expected;
                } else if (target instanceof ICICSObject) {
                    result = this.attributeExistsFor((ICICSObject)target, name, value);
                }
            }
            Debug.exit((Logger)logger, (String)ActionFilterAdapterFactory.class.getName(), (String)"testAttribute", (Object)result);
            return result;
        }

        private boolean attributeExistsFor(ICICSObject cicsObject, String name, String valueToTest) {
            Debug.enter((Logger)logger, (String)ActionFilterAdapterFactory.class.getName(), (String)"attributeExistsFor", (Object)cicsObject, (Object)name, (Object)valueToTest);
            boolean exists = false;
            CICSObjectPropertySource propertySource = new CICSObjectPropertySource(cicsObject);
            CICSObjectPropertyDescriptor propertyDescriptor = (CICSObjectPropertyDescriptor)propertySource.getPropertyDescriptor(name);
            if (propertyDescriptor != null) {
                ICICSAttribute<?> attribute = propertyDescriptor.getAttribute();
                Object propertyValue = propertySource.getPropertyValue(propertyDescriptor.getId());
                String valueToRetrieve = String.valueOf(propertyValue);
                Debug.event((Logger)logger, (String)ActionFilterAdapterFactory.class.getName(), (String)"attributeExistsFor", (Object)propertyValue);
                exists = valueToTest.equals("!=null") ? this.valueNotNull(attribute, propertyValue, valueToRetrieve) : (valueToTest.equals("N/A") ? this.isNotSupported(attribute, propertyValue) : (valueToTest.startsWith("!=") ? this.isNotEqualIgnoreCaseTo(valueToTest, valueToRetrieve) : this.isEqualIgnoreCaseTo(valueToTest, valueToRetrieve)));
            }
            Debug.exit((Logger)logger, (String)ActionFilterAdapterFactory.class.getName(), (String)"attributeExistsFor", (Object)exists);
            return exists;
        }

        private boolean isEqualIgnoreCaseTo(String valueToTest, String valueToRetrieve) {
            return valueToTest.equalsIgnoreCase(valueToRetrieve);
        }

        private boolean isNotEqualIgnoreCaseTo(String valueToTest, String valueToRetrieve) {
            return !valueToTest.substring(2).equalsIgnoreCase(valueToRetrieve);
        }

        private boolean isNotSupported(ICICSAttribute attribute, Object propertyValue) {
            return attribute.getUnsupportedValue() == propertyValue;
        }

        private boolean valueNotNull(ICICSAttribute attribute, Object propertyValue, String valueToRetrieve) {
            return valueToRetrieve.length() > 0 && attribute.getUnsupportedValue() != propertyValue;
        }

        private boolean existsMutableDefinition(ICoreObject coreObject) {
            IMutableCoreObject mutable = (IMutableCoreObject)coreObject.getAdapter(IMutableCoreObject.class);
            return mutable != null;
        }

        private ICICSAction getActionFor(String actionName) {
            ICICSAction action;
            try {
                action = (ICICSAction)SystemManagerActions.class.getField(actionName).get(null);
            }
            catch (Exception ex) {
                Debug.warning((Logger)logger, (String)ActionFilterAdapterFactory.class.getName(), (String)"getActionFor", (String)actionName, (Throwable)ex);
                action = null;
            }
            return action;
        }

        private boolean isGroupSelected() {
            IContext context = UIPlugin.getDefault().getContext();
            return context instanceof IDefinitionContext;
        }

        public String toString() {
            return "IActionFilter[cicsObjectActionFilter]";
        }
    };

    public ActionFilterAdapterFactory() {
        if (Debug.DEBUG_ADAPTERS) {
            Debug.event((Logger)logger, (String)ActionFilterAdapterFactory.class.getName(), (String)"ActionFilterAdapterFactory", (Object)"- ActionFilterAdapterFactory.<init>()");
        }
    }

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        if (Debug.DEBUG_ADAPTERS) {
            Debug.enter((Logger)logger, (String)ActionFilterAdapterFactory.class.getName(), (String)"getAdapter", (Object)("object=" + adaptableObject + ", type=" + adapterType));
        }
        IActionFilter adapter = null;
        if (adapterType == IActionFilter.class && adaptableObject instanceof ICICSObject) {
            adapter = this.cicsObjectActionFilter;
        }
        if (Debug.DEBUG_ADAPTERS) {
            Debug.exit((Logger)logger, (String)ActionFilterAdapterFactory.class.getName(), (String)"getAdapter", (Object)("adapter=" + adapter));
        }
        return adapter;
    }

    public Class[] getAdapterList() {
        return new Class[]{IActionFilter.class};
    }

    public static boolean canBundleBeMadeAvailable(IBundle bundle) {
        IBundle.AvailabilityValue availability = bundle.getAvailability();
        return !IBundle.AvailabilityValue.NONE.equals((Object)availability) && !IBundle.AvailabilityValue._UNSUPPORTED.equals((Object)availability);
    }

    public static boolean isInstalledByBundle(ICICSObject object) {
        IProgram program;
        String operationName;
        Object installAgent;
        ICICSAttribute attribute = object.getObjectType().findAttributeByCicsName("INSTALLAGENT");
        if (attribute != null && (installAgent = object.getAttributeValue((IAttribute)attribute)) instanceof Enum && "BUNDLE".equals(((Enum)installAgent).name())) {
            return true;
        }
        IPrimaryKey primaryKey = (IPrimaryKey)((ICoreObject)object).getAdapter(IPrimaryKey.class);
        IApplicationContext applicationContext = (IApplicationContext)ContextHelper.getContextFrom((IContext)primaryKey, IApplicationContext.class);
        if (applicationContext != null) {
            return true;
        }
        return object instanceof IProgram && (operationName = (program = (IProgram)object).getOperationName()).length() > 0;
    }
}

