/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.adapters;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.model.CICSRegionGroupDefinitionType;
import com.ibm.cics.core.model.CICSSystemManagerException;
import com.ibm.cics.core.model.Context;
import com.ibm.cics.core.model.FilteredContext;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.ICoreObject;
import com.ibm.cics.core.model.WorkloadTargetType;
import com.ibm.cics.core.model.extra.IWLMActiveRuleEditorSource;
import com.ibm.cics.core.ui.UIPlugin;
import com.ibm.cics.core.ui.internal.cloud.ErrorWrapper;
import com.ibm.cics.model.AttributeValue;
import com.ibm.cics.model.CICSActionException;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICICSRegionGroupDefinition;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.model.IGroupSystemGroupEntry;
import com.ibm.cics.model.ISystemSystemGroupEntry;
import com.ibm.cics.model.IWorkload;
import com.ibm.cics.model.IWorkloadTarget;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.IPrimaryKey;
import com.ibm.cics.sm.comm.SystemManagerConnectionException;
import com.ibm.cics.sm.comm.context.WorkloadContext;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;

public abstract class WLMAbstractRuleRelatedAdapter
implements IWLMActiveRuleEditorSource {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug DEBUG = new Debug(WLMAbstractRuleRelatedAdapter.class);
    private static final String WORKLOAD_TARGET_DUMPING = " DUMPING";
    private static final String WORKLOAD_TARGET_SHORT_ON_STORAGE = " SOS";
    private static final String WORKLOAD_TARGET_AT_MAXTASKS = " MAXTASKS";
    private static final String WORKLOAD_TARGET_STALLED = " STALLED";
    protected final IWorkload activeWorkload;
    protected final ICPSM cpsm;
    protected final IContext baseContext;

    public WLMAbstractRuleRelatedAdapter(IWorkload wlmActiveWorkload) {
        this.activeWorkload = wlmActiveWorkload;
        this.cpsm = WLMAbstractRuleRelatedAdapter.getWorkloadCPSM(this.activeWorkload);
        this.baseContext = WLMAbstractRuleRelatedAdapter.getWorkloadBaseContext(this.activeWorkload);
    }

    public static ICPSM getWorkloadCPSM(IWorkload workload) {
        return ((ICoreObject)workload).getCPSM();
    }

    public static Context getWorkloadBaseContext(IWorkload workload) {
        ICoreObject coreObject = (ICoreObject)workload;
        IPrimaryKey primaryKey = (IPrimaryKey)coreObject.getAdapter(IPrimaryKey.class);
        return new Context(primaryKey.getContext());
    }

    public ImageDescriptor getImageDescriptor(Object object) {
        return UIPlugin.IMGD_SYSTEM_GROUP_DEFINITION;
    }

    public ICICSObject getAdaptedWorkload() {
        return this.activeWorkload;
    }

    protected Object[] getTargetsForScope(String scope) {
        DEBUG.enter("getTargetsForScope", (Object)this, (Object)scope);
        ArrayList<IWorkloadTarget> workloadTargets = new ArrayList<IWorkloadTarget>();
        try {
            ICICSRegionGroupDefinition scopeRegionGroup = this.getRegionGroupByName(scope);
            if (scopeRegionGroup != null) {
                this.getWorkloadTargetsForRegionGroup(scopeRegionGroup, workloadTargets);
            } else {
                workloadTargets.add(this.getWorkloadTargetByName(scope));
            }
        }
        catch (Exception e) {
            if (e.getCause() != null && !(e.getCause() instanceof SystemManagerConnectionException)) {
                DEBUG.event("getTargetsForScope", (Object)e);
                return new Object[]{new ErrorWrapper(e.getCause())};
            }
            DEBUG.error("getTargetsForScope", (Throwable)e);
        }
        Object[] result = workloadTargets.toArray();
        DEBUG.exit("getTargetsForScope", (Object)result);
        return result;
    }

    private ICICSRegionGroupDefinition getRegionGroupByName(String name) throws CICSSystemManagerException {
        DEBUG.enter("getRegionGroupByName", (Object)this, (Object)name);
        FilteredContext filteredContext = new FilteredContext(this.baseContext, new AttributeValue[]{new AttributeValue(CICSRegionGroupDefinitionType.GROUP, (Object)name)});
        ICICSRegionGroupDefinition scopeRegionGroup = null;
        ICICSObject[] regionGroups = this.cpsm.getDefinitions2((ICICSType)CICSRegionGroupDefinitionType.getInstance(), (IContext)filteredContext);
        if (regionGroups.length == 1 && regionGroups[0] instanceof ICICSRegionGroupDefinition) {
            scopeRegionGroup = (ICICSRegionGroupDefinition)regionGroups[0];
        }
        DEBUG.exit("getRegionGroupByName", scopeRegionGroup);
        return scopeRegionGroup;
    }

    private void getWorkloadTargetsForRegionGroup(ICICSRegionGroupDefinition scopeRegionGroup, List<IWorkloadTarget> workloadTargets) throws CICSActionException {
        DEBUG.enter("getRegionsForRegionGroup", (Object)this, (Object)scopeRegionGroup);
        List groupsInGroup = scopeRegionGroup.getGroupsInGroup().get();
        for (IGroupSystemGroupEntry groupEntry : groupsInGroup) {
            ICICSRegionGroupDefinition subGroup = this.getRegionGroupByName(groupEntry.getCICSObjectReference().getGroupName());
            if (subGroup == null) continue;
            this.getWorkloadTargetsForRegionGroup(subGroup, workloadTargets);
        }
        List systemEntriesForThisGroup = scopeRegionGroup.getSystemsInGroup().get();
        for (ISystemSystemGroupEntry entry : systemEntriesForThisGroup) {
            if (this.isTargetRegionAlreadyKnown(entry.getSystemName(), workloadTargets)) continue;
            workloadTargets.add(this.getWorkloadTargetByName(entry.getSystemName()));
        }
        DEBUG.exit("getRegionsForRegionGroup", workloadTargets);
    }

    private boolean isTargetRegionAlreadyKnown(String targetRegion, List<IWorkloadTarget> workloadTargets) {
        for (IWorkloadTarget target : workloadTargets) {
            if (!target.getTargetRegion().equals(targetRegion)) continue;
            return true;
        }
        return false;
    }

    private IWorkloadTarget getWorkloadTargetByName(String name) throws CICSSystemManagerException {
        DEBUG.enter("getWorkloadTargetByName", (Object)this, (Object)name);
        WorkloadContext workloadContext = new WorkloadContext(this.baseContext, this.activeWorkload.getName());
        FilteredContext filteredContext = new FilteredContext((IContext)workloadContext, new AttributeValue[]{new AttributeValue(WorkloadTargetType.TARGET_REGION, (Object)name)});
        IWorkloadTarget workloadTarget = null;
        ICICSObject[] workloadTargets = this.cpsm.getDefinitions2((ICICSType)WorkloadTargetType.getInstance(), (IContext)filteredContext);
        if (workloadTargets.length != 1 || !(workloadTargets[0] instanceof IWorkloadTarget)) {
            throw new RuntimeException("Failed to get workload target");
        }
        workloadTarget = (IWorkloadTarget)workloadTargets[0];
        DEBUG.exit("getWorkloadTargetByName", (Object)workloadTarget);
        return workloadTarget;
    }

    public String getEditorOpeningPage() {
        return "wlm.activeWorkloadDefinitionTargets";
    }

    public String getDecorationForTarget(IWorkloadTarget target) {
        StringBuilder sb = new StringBuilder();
        sb.append(target.getStatus());
        if (target.getHealthDump() == IWorkloadTarget.HealthDumpValue.YES) {
            sb.append(WORKLOAD_TARGET_DUMPING);
        }
        if (target.getHealthShortOnStorage() == IWorkloadTarget.HealthShortOnStorageValue.YES) {
            sb.append(WORKLOAD_TARGET_SHORT_ON_STORAGE);
        }
        if (target.getHealthMaxtasks() == IWorkloadTarget.HealthMaxtasksValue.YES) {
            sb.append(WORKLOAD_TARGET_AT_MAXTASKS);
        }
        if (target.getHealthStall() == IWorkloadTarget.HealthStallValue.YES) {
            sb.append(WORKLOAD_TARGET_STALLED);
        }
        return sb.toString();
    }
}

