/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.flhsupport;

import com.ibm.cics.core.ui.Debug;
import com.ibm.cics.core.ui.UIPlugin;
import com.ibm.cics.core.ui.flhsupport.FLHelpSynchronization;
import java.util.logging.Logger;
import org.eclipse.ui.PlatformUI;

public class FLHSupport {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(FLHSupport.class.getPackage().getName());
    private static final String PREFERENCE_FLHSUPPORT_IS_SYNCHRONIZED = "FLHSupport.isSynchronized";
    static FLHelpSynchronization synchronizationInstance = new FLHelpSynchronization();

    static {
        synchronizationInstance.setEnabled(FLHSupport.isEnabled());
    }

    public static void showHelp(String helpContextId) {
        PlatformUI.getWorkbench().getHelpSystem().displayHelp(helpContextId);
    }

    public static void requestSynchronizeShownHelp(String helpContextId) {
        if (Debug.DEBUG_SELECTION) {
            Debug.event((Logger)logger, (String)FLHSupport.class.getName(), (String)"requestSynchronizeShownHelp", (Object)("helpContextId =" + helpContextId + " synchronizationInstance=" + synchronizationInstance));
        }
        if (synchronizationInstance.isEnabled()) {
            synchronizationInstance.requestWorkbenchHelpSystemDisplayHelp(helpContextId);
        }
    }

    public static boolean isEnabled() {
        boolean enabled = UIPlugin.getDefault().getPreferenceStore().getBoolean(PREFERENCE_FLHSUPPORT_IS_SYNCHRONIZED);
        if (Debug.DEBUG_SELECTION) {
            Debug.event((Logger)logger, (String)FLHSupport.class.getName(), (String)"isEnabled", (Object)("isEnabled =" + enabled + " synchronizationInstance=" + synchronizationInstance));
        }
        return enabled;
    }

    static boolean toggleEnabled() {
        boolean newEnabledValue;
        boolean oldEnabledValue = FLHSupport.isEnabled();
        boolean bl = newEnabledValue = !oldEnabledValue;
        if (Debug.DEBUG_SELECTION) {
            Debug.event((Logger)logger, (String)FLHSupport.class.getName(), (String)"toggleEnabled", (Object)("newEnabledValue =" + newEnabledValue + " synchronizationInstance=" + synchronizationInstance));
        }
        UIPlugin.getDefault().getPreferenceStore().setValue(PREFERENCE_FLHSUPPORT_IS_SYNCHRONIZED, newEnabledValue);
        if (synchronizationInstance != null) {
            synchronizationInstance.setEnabled(newEnabledValue);
        }
        return newEnabledValue;
    }
}

