/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.properties;

import com.ibm.cics.core.ui.properties.CICSAttributeDecoratedLabelProvider;
import com.ibm.cics.core.ui.properties.CICSAttributeLabelProvider;
import com.ibm.cics.core.ui.properties.ICICSObjectPropertyDescriptor;
import com.ibm.cics.core.ui.properties.IDescriptionProvider;
import com.ibm.cics.model.ICICSAttribute;
import com.ibm.cics.model.ICICSType;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.IPropertyDescriptor;

public class CICSObjectPropertyDescriptor
implements ICICSObjectPropertyDescriptor {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private String id;
    private ICICSAttribute<?> attribute;
    private String description;
    private String displayName;
    private String category;
    private String helpContextId;
    private LabelProvider labelProvider;

    public CICSObjectPropertyDescriptor(ICICSType<?> cicsType, ICICSAttribute<?> cicsAttribute, String simpleClassName, IDescriptionProvider descriptionProvider) {
        this.id = cicsAttribute.getPropertyId();
        this.attribute = cicsAttribute;
        String textKey = String.valueOf(simpleClassName) + ".column." + this.id;
        String toolTipKey = String.valueOf(simpleClassName) + ".column." + "toolTip." + this.id;
        String categoryKey = "category." + this.attribute.getCategoryId();
        this.displayName = descriptionProvider.getString(textKey);
        this.description = descriptionProvider.getString(toolTipKey);
        this.category = descriptionProvider.getString(categoryKey);
        this.labelProvider = new CICSAttributeLabelProvider(cicsAttribute);
        this.helpContextId = String.valueOf(descriptionProvider.getHelpContextIdPrefix()) + ".property_" + cicsType.getResourceTableName() + "_" + cicsAttribute.getCicsName();
    }

    @Override
    public void setDecorateImage(boolean aBoolean) {
        this.labelProvider = new CICSAttributeDecoratedLabelProvider(this.attribute);
    }

    public CellEditor createPropertyEditor(Composite parent) {
        return null;
    }

    public String getCategory() {
        return this.category;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String[] getFilterFlags() {
        return null;
    }

    public Object getHelpContextIds() {
        return this.helpContextId;
    }

    public Object getId() {
        return this.id;
    }

    public ILabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    public boolean isCompatibleWith(IPropertyDescriptor anotherProperty) {
        return false;
    }

    public boolean equals(Object o) {
        if (o instanceof CICSObjectPropertyDescriptor) {
            return this.equals((CICSObjectPropertyDescriptor)o);
        }
        return super.equals(o);
    }

    public boolean equals(CICSObjectPropertyDescriptor descriptor) {
        return this.attribute.equals(descriptor.attribute);
    }

    public int hashCode() {
        return this.attribute.hashCode();
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + "[" + this.attribute + "]";
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    @Override
    public ICICSAttribute<?> getAttribute() {
        return this.attribute;
    }
}

