/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.properties;

import com.ibm.cics.core.ui.CICSTypePropertySource;
import com.ibm.cics.core.ui.Debug;
import com.ibm.cics.core.ui.properties.AttributePropertyHelper;
import com.ibm.cics.core.ui.properties.CICSObjectPropertySource;
import com.ibm.cics.core.ui.properties.ICICSObjectPropertyDescriptor;
import com.ibm.cics.core.ui.properties.MutableCICSObjectPropertyDescriptor;
import com.ibm.cics.model.ICICSAttribute;
import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.model.ICICSType;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.model.meta.IType;
import java.util.logging.Logger;

public class MutableCICSObjectPropertySource
extends CICSObjectPropertySource {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Logger logger = Logger.getLogger(MutableCICSObjectPropertySource.class.getPackage().getName());

    public MutableCICSObjectPropertySource(ICICSObject cicsObject) {
        super(cicsObject, cicsObject.getObjectType().getMutableInterface());
    }

    @Override
    public void setPropertyValue(Object id, Object value) {
        if (Debug.DEBUG_PROPERTIES) {
            Debug.enter((Logger)logger, (String)MutableCICSObjectPropertySource.class.getName(), (String)"setPropertyValue", (Object)(this + ", id=" + id + ", value=" + value));
        }
        this.setPropertyValueImpl(id, value);
        if (Debug.DEBUG_PROPERTIES) {
            Debug.exit((Logger)logger, (String)MutableCICSObjectPropertySource.class.getName(), (String)"setPropertyValue");
        }
    }

    @Override
    protected AttributePropertyHelper createHelper(IType<?> objectType, Class<?> interfaceType) {
        return new CICSTypePropertySource((ICICSType)objectType, interfaceType){

            @Override
            protected ICICSObjectPropertyDescriptor createPropertyDescriptor(IType<?> cicsType, IAttribute<?> cicsAttribute, String simpleClassName, boolean mutable) {
                MutableCICSObjectPropertyDescriptor descriptor = new MutableCICSObjectPropertyDescriptor((ICICSType)cicsType, (ICICSAttribute)cicsAttribute, simpleClassName, this.getDescriptionProvider(), mutable);
                return descriptor;
            }
        };
    }
}

