/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.views;

import com.ibm.cics.core.connections.ConnectionServiceListener;
import com.ibm.cics.core.connections.IConnectionService;
import com.ibm.cics.core.connections.internal.ConnectedState;
import com.ibm.cics.core.ui.views.BaseContextProvider;
import com.ibm.cics.core.ui.views.IBaseContextProvider;
import com.ibm.cics.core.ui.views.Messages;
import com.ibm.cics.sm.comm.IContext;

public class ConnectionStateContextProvider
extends BaseContextProvider {
    private static final String DISCONNECTED_DESCRIPTION = Messages.getString("ResourcesView.status.disconnected", new Object[0]);
    private boolean connected;
    private final IBaseContextProvider decorated;
    private final ConnectionServiceListener connectionServiceListener;
    private IBaseContextProvider.Listener decoratedListener;

    public ConnectionStateContextProvider(String connectionCategoryId, IConnectionService connectionService, IBaseContextProvider pdecorated) {
        this.decorated = pdecorated;
        this.connected = connectionService.getConnectionState(connectionCategoryId) instanceof ConnectedState;
        this.connectionServiceListener = new ConnectionStateContextConnectionServiceListener(this, connectionCategoryId);
        connectionService.addConnectionServiceListener(this.connectionServiceListener);
        this.decoratedListener = new IBaseContextProvider.Listener(){

            public void event(IBaseContextProvider.Event event) {
                if (ConnectionStateContextProvider.this.connected) {
                    ConnectionStateContextProvider.this.eventManager.notifyListeners((Object)event);
                }
            }
        };
        this.decorated.addListener(this.decoratedListener);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.connectionServiceListener.makeStale();
        this.decoratedListener.makeStale();
        this.decorated.dispose();
    }

    @Override
    public IContext getContext() {
        if (this.connected) {
            return this.decorated.getContext();
        }
        return null;
    }

    @Override
    public String getDescription() {
        if (this.connected) {
            return this.decorated.getDescription();
        }
        return DISCONNECTED_DESCRIPTION;
    }

    private static class ConnectionStateContextConnectionServiceListener
    extends ConnectionServiceListener {
        private final String connectionCategoryId;
        private ConnectionStateContextProvider connectionStateContextProvider;

        private ConnectionStateContextConnectionServiceListener(ConnectionStateContextProvider connectionStateContextProvider, String connectionCategoryId) {
            this.connectionStateContextProvider = connectionStateContextProvider;
            this.connectionCategoryId = connectionCategoryId;
        }

        public void event(ConnectionServiceListener.ConnectionServiceEvent event) {
            if (this.connectionCategoryId.equals(event.getConnectionCategoryId())) {
                if (event instanceof ConnectionServiceListener.ConnectedEvent) {
                    this.connectionStateContextProvider.connected = true;
                    this.connectionStateContextProvider.eventManager.notifyListeners((Object)new IBaseContextProvider.ContextChangedEvent(this.connectionStateContextProvider.decorated.getContext(), this.connectionStateContextProvider.decorated.getDescription()));
                } else if (event instanceof ConnectionServiceListener.DisconnectedEvent) {
                    this.connectionStateContextProvider.connected = false;
                    this.connectionStateContextProvider.eventManager.notifyListeners((Object)new IBaseContextProvider.ContextChangedEvent(null, DISCONNECTED_DESCRIPTION));
                }
            }
        }

        public synchronized void makeStale() {
            this.connectionStateContextProvider = null;
            super.makeStale();
        }
    }
}

