/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.ui.views;

import com.ibm.cics.common.util.Debug;
import com.ibm.cics.core.model.Context;
import com.ibm.cics.core.model.IContextProvider;
import com.ibm.cics.core.model.IStrategicContextProvider;
import com.ibm.cics.core.ui.views.IElementTypeService;
import com.ibm.cics.core.ui.views.SelectionContextProvider;
import com.ibm.cics.model.IApplication;
import com.ibm.cics.model.ICICSRegionGroupDefinition;
import com.ibm.cics.model.ICICSResource;
import com.ibm.cics.model.IPlatform;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.IDefinitionContext;
import org.eclipse.core.runtime.Platform;

public class DefaultSelectionContextAdapter
implements SelectionContextProvider.IContextProviderAdapter {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2013, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final Debug debug = new Debug(DefaultSelectionContextAdapter.class);
    private final IElementTypeService elementTypeService;

    public DefaultSelectionContextAdapter(IElementTypeService elementTypeService) {
        this.elementTypeService = elementTypeService;
    }

    @Override
    public IContext getContextFor(Object element) {
        debug.enter("getContextFor", element);
        IContext context = null;
        if (element != null) {
            context = this.adapt(element);
        }
        debug.exit("getContextFor", (Object)context);
        return context;
    }

    private boolean cicsRegionGroupDefinitionFilter(Object element) {
        if (element instanceof ICICSRegionGroupDefinition || element instanceof IPlatform || element instanceof IApplication) {
            return !ICICSResource.class.isAssignableFrom(this.elementTypeService.getElementType().getInterfaceType());
        }
        return false;
    }

    private IContext adapt(Object element) {
        IStrategicContextProvider provider;
        if (this.cicsRegionGroupDefinitionFilter(element)) {
            return null;
        }
        IContext elementContext = null;
        String adapterTypeName = IContextProvider.class.getName();
        IContextProvider adapter = (IContextProvider)Platform.getAdapterManager().loadAdapter(element, adapterTypeName);
        if (adapter != null) {
            elementContext = adapter instanceof IStrategicContextProvider ? ((IStrategicContextProvider)adapter).getStrategicIContext(this.elementTypeService.getElementType()) : adapter.getIContext();
        } else if (element instanceof IStrategicContextProvider) {
            provider = (IStrategicContextProvider)element;
            elementContext = provider.getStrategicIContext(this.elementTypeService.getElementType());
        } else if (element instanceof IContextProvider) {
            provider = (IContextProvider)element;
            elementContext = provider.getIContext();
        }
        if (elementContext != null && elementContext instanceof IDefinitionContext && !this.elementTypeService.getElementType().isDefinition()) {
            Context context = new Context(elementContext.getContext());
            debug.event("getAppropriateContextFor", (Object)this, (Object)context);
            return context;
        }
        return elementContext;
    }
}

