/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.model;

import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class Descriptions {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2011 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String MISSING_KEY_MARKER = "!";
    private static final String BUNDLE_NAME_PREFIX = "com.ibm.cics.model.descriptions";
    private static final String CUSTOM_BUNDLE_NAME = "com.ibm.cics.model.descriptions";
    private static final ResourceBundle CUSTOM_BUNDLE = ResourceBundle.getBundle("com.ibm.cics.model.descriptions");
    private static Map<String, ResourceBundle> resourceBundles = new HashMap<String, ResourceBundle>();

    private Descriptions() {
    }

    private static ResourceBundle getResourceBundle(String bundleName) {
        ResourceBundle resourceBundle = resourceBundles.get(bundleName);
        if (resourceBundle == null) {
            try {
                try {
                    resourceBundle = ResourceBundle.getBundle("com.ibm.cics.model.descriptions_" + bundleName);
                }
                catch (MissingResourceException missingResourceException) {
                    resourceBundle = CUSTOM_BUNDLE;
                    resourceBundles.put(bundleName, resourceBundle);
                }
            }
            finally {
                resourceBundles.put(bundleName, resourceBundle);
            }
        }
        return resourceBundle;
    }

    private static String getString(ResourceBundle resourceBundle, String key) {
        String value;
        try {
            value = CUSTOM_BUNDLE.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            try {
                value = resourceBundle.getString(key);
            }
            catch (MissingResourceException missingResourceException2) {
                value = Descriptions.getMissingString(key);
            }
        }
        return value;
    }

    public static String getTrimmedString(String key) {
        ResourceBundle resourceBundle = null;
        if (key != null) {
            String keyPrefix = null;
            if (key.indexOf(46) > -1) {
                keyPrefix = key.substring(0, key.indexOf(46));
            }
            resourceBundle = Descriptions.getResourceBundle(keyPrefix);
            return Descriptions.getString(resourceBundle, key).trim();
        }
        return Descriptions.getMissingString(key);
    }

    public static final String getMissingString(String key) {
        return MISSING_KEY_MARKER + key + MISSING_KEY_MARKER;
    }
}

