/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.IPICConnectionReference;
import com.ibm.cics.core.model.IPICConnectionType;
import com.ibm.cics.core.model.internal.MutableCICSResource;
import com.ibm.cics.core.model.internal.MutableSMRecord;
import com.ibm.cics.model.ICICSResource;
import com.ibm.cics.model.IIPICConnection;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.model.mutable.IMutableIPICConnection;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import java.util.Date;

public class MutableIPICConnection
extends MutableCICSResource
implements IMutableIPICConnection {
    private IIPICConnection delegate;
    private MutableSMRecord record;

    public MutableIPICConnection(ICPSM cpsm, IContext context, IIPICConnection cicsObject) {
        super(cpsm, context, (ICICSResource)cicsObject);
        this.delegate = cicsObject;
        this.record = new MutableSMRecord("IPCONN");
    }

    @Override
    public SMConnectionRecord getRecord() {
        MutableSMRecord result = new MutableSMRecord(this.record);
        result.setKeyValueFrom(this);
        return result;
    }

    @Override
    public boolean isDirty() {
        return this.record.size() != 0;
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    public String getApplID() {
        return this.delegate.getApplID();
    }

    public IIPICConnection.AutoconnectValue getAutoconnect() {
        return this.delegate.getAutoconnect();
    }

    public IIPICConnection.ConnectionStatusValue getConnectionStatus() {
        String result = this.record.get("CONNSTATUS");
        if (result == null) {
            return this.delegate.getConnectionStatus();
        }
        return (IIPICConnection.ConnectionStatusValue)((CICSAttribute)IPICConnectionType.CONNECTION_STATUS).get(result, this.record.getNormalizers());
    }

    public String getHost() {
        return this.delegate.getHost();
    }

    public Long getMaxqtime() {
        return this.delegate.getMaxqtime();
    }

    public IIPICConnection.PendstatusValue getPendstatus() {
        String result = this.record.get("PENDSTATUS");
        if (result == null) {
            return this.delegate.getPendstatus();
        }
        return (IIPICConnection.PendstatusValue)((CICSAttribute)IPICConnectionType.PENDSTATUS).get(result, this.record.getNormalizers());
    }

    public Long getPort() {
        return this.delegate.getPort();
    }

    public Long getQueuelimit() {
        return this.delegate.getQueuelimit();
    }

    public Long getReceivecount() {
        return this.delegate.getReceivecount();
    }

    public IIPICConnection.RecovstatusValue getRecovstatus() {
        String result = this.record.get("RECOVSTATUS");
        if (result == null) {
            return this.delegate.getRecovstatus();
        }
        return (IIPICConnection.RecovstatusValue)((CICSAttribute)IPICConnectionType.RECOVSTATUS).get(result, this.record.getNormalizers());
    }

    public Long getSendcount() {
        return this.delegate.getSendcount();
    }

    public IIPICConnection.ServiceStatusValue getServiceStatus() {
        String result = this.record.get("SERVSTATUS");
        if (result == null) {
            return this.delegate.getServiceStatus();
        }
        return (IIPICConnection.ServiceStatusValue)((CICSAttribute)IPICConnectionType.SERVICE_STATUS).get(result, this.record.getNormalizers());
    }

    public String getTcpipService() {
        return this.delegate.getTcpipService();
    }

    public String getNetworkid() {
        return this.delegate.getNetworkid();
    }

    public IIPICConnection.LinkauthValue getLinkauth() {
        return this.delegate.getLinkauth();
    }

    public IIPICConnection.PurgetypeValue getPurgetype() {
        String result = this.record.get("PURGETYPE");
        if (result == null) {
            return this.delegate.getPurgetype();
        }
        return (IIPICConnection.PurgetypeValue)((CICSAttribute)IPICConnectionType.PURGETYPE).get(result, this.record.getNormalizers());
    }

    public IIPICConnection.UowactionValue getUowaction() {
        String result = this.record.get("UOWACTION");
        if (result == null) {
            return this.delegate.getUowaction();
        }
        return (IIPICConnection.UowactionValue)((CICSAttribute)IPICConnectionType.UOWACTION).get(result, this.record.getNormalizers());
    }

    public Long getFspcbytesent() {
        return this.delegate.getFspcbytesent();
    }

    public Long getFspcbyterecd() {
        return this.delegate.getFspcbyterecd();
    }

    public String getLocctime() {
        return this.delegate.getLocctime();
    }

    public String getLocdtime() {
        return this.delegate.getLocdtime();
    }

    public String getGmtctime() {
        return this.delegate.getGmtctime();
    }

    public String getGmtdtime() {
        return this.delegate.getGmtdtime();
    }

    public Long getCsendsess() {
        return this.delegate.getCsendsess();
    }

    public Long getPsendsess() {
        return this.delegate.getPsendsess();
    }

    public Long getCrecvsess() {
        return this.delegate.getCrecvsess();
    }

    public Long getPrecvsess() {
        return this.delegate.getPrecvsess();
    }

    public Long getTotalloc() {
        return this.delegate.getTotalloc();
    }

    public Long getCurrqueued() {
        return this.delegate.getCurrqueued();
    }

    public Long getPeakqueued() {
        return this.delegate.getPeakqueued();
    }

    public Long getAllcfaillink() {
        return this.delegate.getAllcfaillink();
    }

    public Long getAllcfailoth() {
        return this.delegate.getAllcfailoth();
    }

    public Long getQlimallocrej() {
        return this.delegate.getQlimallocrej();
    }

    public Long getMqtallqpurg() {
        return this.delegate.getMqtallqpurg();
    }

    public Long getMqtallpurg() {
        return this.delegate.getMqtallpurg();
    }

    public Long getExitallcrej() {
        return this.delegate.getExitallcrej();
    }

    public Long getExitallcqpur() {
        return this.delegate.getExitallcqpur();
    }

    public Long getExitallcpur() {
        return this.delegate.getExitallcpur();
    }

    public Long getTransattch() {
        return this.delegate.getTransattch();
    }

    public Long getFspgreqs() {
        return this.delegate.getFspgreqs();
    }

    public IIPICConnection.SsltypeValue getSsltype() {
        return this.delegate.getSsltype();
    }

    public IIPICConnection.UserauthValue getUserauth() {
        return this.delegate.getUserauth();
    }

    public String getCertificate() {
        return this.delegate.getCertificate();
    }

    public Long getNumciphers() {
        return this.delegate.getNumciphers();
    }

    public String getCiphers() {
        return this.delegate.getCiphers();
    }

    public String getSecurityname() {
        return this.delegate.getSecurityname();
    }

    public IIPICConnection.ChangeAgentValue getChangeAgent() {
        return this.delegate.getChangeAgent();
    }

    public String getChangeUserID() {
        return this.delegate.getChangeUserID();
    }

    public String getChangeAgentRelease() {
        return this.delegate.getChangeAgentRelease();
    }

    public Date getChangeTime() {
        return this.delegate.getChangeTime();
    }

    public String getDefineSource() {
        return this.delegate.getDefineSource();
    }

    public Date getDefineTime() {
        return this.delegate.getDefineTime();
    }

    public String getInstallUserID() {
        return this.delegate.getInstallUserID();
    }

    public Date getInstallTime() {
        return this.delegate.getInstallTime();
    }

    public IIPICConnection.InstallAgentValue getInstallAgent() {
        return this.delegate.getInstallAgent();
    }

    public Long getBasdefinever() {
        return this.delegate.getBasdefinever();
    }

    public String getClientloc() {
        return this.delegate.getClientloc();
    }

    public String getPartner() {
        return this.delegate.getPartner();
    }

    public String getIpresolved() {
        return this.delegate.getIpresolved();
    }

    public IIPICConnection.IpfamilyValue getIpfamily() {
        return this.delegate.getIpfamily();
    }

    public IIPICConnection.HosttypeValue getHosttype() {
        return this.delegate.getHosttype();
    }

    public Long getTrreqs() {
        return this.delegate.getTrreqs();
    }

    public Long getTrbytesent() {
        return this.delegate.getTrbytesent();
    }

    public Long getTrbyterecd() {
        return this.delegate.getTrbyterecd();
    }

    public Long getFsicreqs() {
        return this.delegate.getFsicreqs();
    }

    public Long getFsicbytesent() {
        return this.delegate.getFsicbytesent();
    }

    public Long getFsicbyterecd() {
        return this.delegate.getFsicbyterecd();
    }

    public IIPICConnection.IdpropValue getIdprop() {
        return this.delegate.getIdprop();
    }

    public Long getRemtrmstrt() {
        return this.delegate.getRemtrmstrt();
    }

    public IIPICConnection.MirrorlifeValue getMirrorlife() {
        return this.delegate.getMirrorlife();
    }

    public Long getFsfcreqs() {
        return this.delegate.getFsfcreqs();
    }

    public Long getFsfcbytesent() {
        return this.delegate.getFsfcbytesent();
    }

    public Long getFsfcbyterecd() {
        return this.delegate.getFsfcbyterecd();
    }

    public Long getFstdreqs() {
        return this.delegate.getFstdreqs();
    }

    public Long getFstdbytesent() {
        return this.delegate.getFstdbytesent();
    }

    public Long getFstdbyterecd() {
        return this.delegate.getFstdbyterecd();
    }

    public Long getFstsreqs() {
        return this.delegate.getFstsreqs();
    }

    public Long getFstsbytesent() {
        return this.delegate.getFstsbytesent();
    }

    public Long getFstsbyterecd() {
        return this.delegate.getFstsbyterecd();
    }

    public Long getUnsupreqs() {
        return this.delegate.getUnsupreqs();
    }

    public IIPICConnection.HighAvailabilityStatusValue getHighAvailabilityStatus() {
        return this.delegate.getHighAvailabilityStatus();
    }

    public void setConnectionStatus(IIPICConnection.ConnectionStatusValue _connectionStatus) {
        if (_connectionStatus.equals((Object)this.delegate.getConnectionStatus())) {
            this.record.set("CONNSTATUS", null);
        } else {
            IPICConnectionType.CONNECTION_STATUS.validate((Object)_connectionStatus);
            String connectionSpecificExternalValue = ((CICSAttribute)IPICConnectionType.CONNECTION_STATUS).set(_connectionStatus, this.record.getNormalizers());
            this.record.set("CONNSTATUS", connectionSpecificExternalValue);
        }
    }

    public void setPendstatus(IIPICConnection.PendstatusValue _pendstatus) {
        if (_pendstatus.equals((Object)this.delegate.getPendstatus())) {
            this.record.set("PENDSTATUS", null);
        } else {
            IPICConnectionType.PENDSTATUS.validate((Object)_pendstatus);
            String connectionSpecificExternalValue = ((CICSAttribute)IPICConnectionType.PENDSTATUS).set(_pendstatus, this.record.getNormalizers());
            this.record.set("PENDSTATUS", connectionSpecificExternalValue);
        }
    }

    public void setRecovstatus(IIPICConnection.RecovstatusValue _recovstatus) {
        if (_recovstatus.equals((Object)this.delegate.getRecovstatus())) {
            this.record.set("RECOVSTATUS", null);
        } else {
            IPICConnectionType.RECOVSTATUS.validate((Object)_recovstatus);
            String connectionSpecificExternalValue = ((CICSAttribute)IPICConnectionType.RECOVSTATUS).set(_recovstatus, this.record.getNormalizers());
            this.record.set("RECOVSTATUS", connectionSpecificExternalValue);
        }
    }

    public void setServiceStatus(IIPICConnection.ServiceStatusValue _serviceStatus) {
        if (_serviceStatus.equals((Object)this.delegate.getServiceStatus())) {
            this.record.set("SERVSTATUS", null);
        } else {
            IPICConnectionType.SERVICE_STATUS.validate((Object)_serviceStatus);
            String connectionSpecificExternalValue = ((CICSAttribute)IPICConnectionType.SERVICE_STATUS).set(_serviceStatus, this.record.getNormalizers());
            this.record.set("SERVSTATUS", connectionSpecificExternalValue);
        }
    }

    public void setPurgetype(IIPICConnection.PurgetypeValue _purgetype) {
        if (_purgetype.equals((Object)this.delegate.getPurgetype())) {
            this.record.set("PURGETYPE", null);
        } else {
            IPICConnectionType.PURGETYPE.validate((Object)_purgetype);
            String connectionSpecificExternalValue = ((CICSAttribute)IPICConnectionType.PURGETYPE).set(_purgetype, this.record.getNormalizers());
            this.record.set("PURGETYPE", connectionSpecificExternalValue);
        }
    }

    public void setUowaction(IIPICConnection.UowactionValue _uowaction) {
        if (_uowaction.equals((Object)this.delegate.getUowaction())) {
            this.record.set("UOWACTION", null);
        } else {
            IPICConnectionType.UOWACTION.validate((Object)_uowaction);
            String connectionSpecificExternalValue = ((CICSAttribute)IPICConnectionType.UOWACTION).set(_uowaction, this.record.getNormalizers());
            this.record.set("UOWACTION", connectionSpecificExternalValue);
        }
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == IPICConnectionType.NAME) {
            return (V)this.getName();
        }
        if (attribute == IPICConnectionType.APPL_ID) {
            return (V)this.getApplID();
        }
        if (attribute == IPICConnectionType.AUTOCONNECT) {
            return (V)this.getAutoconnect();
        }
        if (attribute == IPICConnectionType.CONNECTION_STATUS) {
            return (V)this.getConnectionStatus();
        }
        if (attribute == IPICConnectionType.HOST) {
            return (V)this.getHost();
        }
        if (attribute == IPICConnectionType.MAXQTIME) {
            return (V)this.getMaxqtime();
        }
        if (attribute == IPICConnectionType.PENDSTATUS) {
            return (V)this.getPendstatus();
        }
        if (attribute == IPICConnectionType.PORT) {
            return (V)this.getPort();
        }
        if (attribute == IPICConnectionType.QUEUELIMIT) {
            return (V)this.getQueuelimit();
        }
        if (attribute == IPICConnectionType.RECEIVECOUNT) {
            return (V)this.getReceivecount();
        }
        if (attribute == IPICConnectionType.RECOVSTATUS) {
            return (V)this.getRecovstatus();
        }
        if (attribute == IPICConnectionType.SENDCOUNT) {
            return (V)this.getSendcount();
        }
        if (attribute == IPICConnectionType.SERVICE_STATUS) {
            return (V)this.getServiceStatus();
        }
        if (attribute == IPICConnectionType.TCPIP_SERVICE) {
            return (V)this.getTcpipService();
        }
        if (attribute == IPICConnectionType.NETWORKID) {
            return (V)this.getNetworkid();
        }
        if (attribute == IPICConnectionType.LINKAUTH) {
            return (V)this.getLinkauth();
        }
        if (attribute == IPICConnectionType.PURGETYPE) {
            return (V)this.getPurgetype();
        }
        if (attribute == IPICConnectionType.UOWACTION) {
            return (V)this.getUowaction();
        }
        if (attribute == IPICConnectionType.FSPCBYTESENT) {
            return (V)this.getFspcbytesent();
        }
        if (attribute == IPICConnectionType.FSPCBYTERECD) {
            return (V)this.getFspcbyterecd();
        }
        if (attribute == IPICConnectionType.LOCCTIME) {
            return (V)this.getLocctime();
        }
        if (attribute == IPICConnectionType.LOCDTIME) {
            return (V)this.getLocdtime();
        }
        if (attribute == IPICConnectionType.GMTCTIME) {
            return (V)this.getGmtctime();
        }
        if (attribute == IPICConnectionType.GMTDTIME) {
            return (V)this.getGmtdtime();
        }
        if (attribute == IPICConnectionType.CSENDSESS) {
            return (V)this.getCsendsess();
        }
        if (attribute == IPICConnectionType.PSENDSESS) {
            return (V)this.getPsendsess();
        }
        if (attribute == IPICConnectionType.CRECVSESS) {
            return (V)this.getCrecvsess();
        }
        if (attribute == IPICConnectionType.PRECVSESS) {
            return (V)this.getPrecvsess();
        }
        if (attribute == IPICConnectionType.TOTALLOC) {
            return (V)this.getTotalloc();
        }
        if (attribute == IPICConnectionType.CURRQUEUED) {
            return (V)this.getCurrqueued();
        }
        if (attribute == IPICConnectionType.PEAKQUEUED) {
            return (V)this.getPeakqueued();
        }
        if (attribute == IPICConnectionType.ALLCFAILLINK) {
            return (V)this.getAllcfaillink();
        }
        if (attribute == IPICConnectionType.ALLCFAILOTH) {
            return (V)this.getAllcfailoth();
        }
        if (attribute == IPICConnectionType.QLIMALLOCREJ) {
            return (V)this.getQlimallocrej();
        }
        if (attribute == IPICConnectionType.MQTALLQPURG) {
            return (V)this.getMqtallqpurg();
        }
        if (attribute == IPICConnectionType.MQTALLPURG) {
            return (V)this.getMqtallpurg();
        }
        if (attribute == IPICConnectionType.EXITALLCREJ) {
            return (V)this.getExitallcrej();
        }
        if (attribute == IPICConnectionType.EXITALLCQPUR) {
            return (V)this.getExitallcqpur();
        }
        if (attribute == IPICConnectionType.EXITALLCPUR) {
            return (V)this.getExitallcpur();
        }
        if (attribute == IPICConnectionType.TRANSATTCH) {
            return (V)this.getTransattch();
        }
        if (attribute == IPICConnectionType.FSPGREQS) {
            return (V)this.getFspgreqs();
        }
        if (attribute == IPICConnectionType.SSLTYPE) {
            return (V)this.getSsltype();
        }
        if (attribute == IPICConnectionType.USERAUTH) {
            return (V)this.getUserauth();
        }
        if (attribute == IPICConnectionType.CERTIFICATE) {
            return (V)this.getCertificate();
        }
        if (attribute == IPICConnectionType.NUMCIPHERS) {
            return (V)this.getNumciphers();
        }
        if (attribute == IPICConnectionType.CIPHERS) {
            return (V)this.getCiphers();
        }
        if (attribute == IPICConnectionType.SECURITYNAME) {
            return (V)this.getSecurityname();
        }
        if (attribute == IPICConnectionType.CHANGE_AGENT) {
            return (V)this.getChangeAgent();
        }
        if (attribute == IPICConnectionType.CHANGE_USER_ID) {
            return (V)this.getChangeUserID();
        }
        if (attribute == IPICConnectionType.CHANGE_AGENT_RELEASE) {
            return (V)this.getChangeAgentRelease();
        }
        if (attribute == IPICConnectionType.CHANGE_TIME) {
            return (V)this.getChangeTime();
        }
        if (attribute == IPICConnectionType.DEFINE_SOURCE) {
            return (V)this.getDefineSource();
        }
        if (attribute == IPICConnectionType.DEFINE_TIME) {
            return (V)this.getDefineTime();
        }
        if (attribute == IPICConnectionType.INSTALL_USER_ID) {
            return (V)this.getInstallUserID();
        }
        if (attribute == IPICConnectionType.INSTALL_TIME) {
            return (V)this.getInstallTime();
        }
        if (attribute == IPICConnectionType.INSTALL_AGENT) {
            return (V)this.getInstallAgent();
        }
        if (attribute == IPICConnectionType.BASDEFINEVER) {
            return (V)this.getBasdefinever();
        }
        if (attribute == IPICConnectionType.CLIENTLOC) {
            return (V)this.getClientloc();
        }
        if (attribute == IPICConnectionType.PARTNER) {
            return (V)this.getPartner();
        }
        if (attribute == IPICConnectionType.IPRESOLVED) {
            return (V)this.getIpresolved();
        }
        if (attribute == IPICConnectionType.IPFAMILY) {
            return (V)this.getIpfamily();
        }
        if (attribute == IPICConnectionType.HOSTTYPE) {
            return (V)this.getHosttype();
        }
        if (attribute == IPICConnectionType.TRREQS) {
            return (V)this.getTrreqs();
        }
        if (attribute == IPICConnectionType.TRBYTESENT) {
            return (V)this.getTrbytesent();
        }
        if (attribute == IPICConnectionType.TRBYTERECD) {
            return (V)this.getTrbyterecd();
        }
        if (attribute == IPICConnectionType.FSICREQS) {
            return (V)this.getFsicreqs();
        }
        if (attribute == IPICConnectionType.FSICBYTESENT) {
            return (V)this.getFsicbytesent();
        }
        if (attribute == IPICConnectionType.FSICBYTERECD) {
            return (V)this.getFsicbyterecd();
        }
        if (attribute == IPICConnectionType.IDPROP) {
            return (V)this.getIdprop();
        }
        if (attribute == IPICConnectionType.REMTRMSTRT) {
            return (V)this.getRemtrmstrt();
        }
        if (attribute == IPICConnectionType.MIRRORLIFE) {
            return (V)this.getMirrorlife();
        }
        if (attribute == IPICConnectionType.FSFCREQS) {
            return (V)this.getFsfcreqs();
        }
        if (attribute == IPICConnectionType.FSFCBYTESENT) {
            return (V)this.getFsfcbytesent();
        }
        if (attribute == IPICConnectionType.FSFCBYTERECD) {
            return (V)this.getFsfcbyterecd();
        }
        if (attribute == IPICConnectionType.FSTDREQS) {
            return (V)this.getFstdreqs();
        }
        if (attribute == IPICConnectionType.FSTDBYTESENT) {
            return (V)this.getFstdbytesent();
        }
        if (attribute == IPICConnectionType.FSTDBYTERECD) {
            return (V)this.getFstdbyterecd();
        }
        if (attribute == IPICConnectionType.FSTSREQS) {
            return (V)this.getFstsreqs();
        }
        if (attribute == IPICConnectionType.FSTSBYTESENT) {
            return (V)this.getFstsbytesent();
        }
        if (attribute == IPICConnectionType.FSTSBYTERECD) {
            return (V)this.getFstsbyterecd();
        }
        if (attribute == IPICConnectionType.UNSUPREQS) {
            return (V)this.getUnsupreqs();
        }
        if (attribute == IPICConnectionType.HIGH_AVAILABILITY_STATUS) {
            return (V)this.getHighAvailabilityStatus();
        }
        return super.getAttributeValue(attribute);
    }

    public IPICConnectionType getObjectType() {
        return IPICConnectionType.getInstance();
    }

    @Override
    public IPICConnectionReference getCICSObjectReference() {
        return new IPICConnectionReference(this.getCICSContainer(), this.getName());
    }
}

