/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model;

import com.ibm.cics.common.CICSRelease;
import com.ibm.cics.core.model.CICSSystemManagerException;
import com.ibm.cics.core.model.CombinedSITParameters;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.SITParametersType;
import com.ibm.cics.core.model.SystemParameterAttribute;
import com.ibm.cics.core.model.SystemParameterType;
import com.ibm.cics.core.model.SystemParameterValue;
import com.ibm.cics.model.ICICSAttribute;
import com.ibm.cics.model.ICombinedSITParameters;
import com.ibm.cics.model.ISystemParameter;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.IScopedContext;
import com.ibm.cics.sm.comm.context.SystemParameterContext;
import java.util.Comparator;
import java.util.HashMap;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SITParametersHelper {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2013 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static Logger logger = Logger.getLogger("com.ibm.cics.core.model");

    public static boolean isSupportedRelease(CICSRelease cicsRelease) {
        return cicsRelease == null || cicsRelease.compareTo((Enum)CICSRelease.e660) >= 0;
    }

    public static ICombinedSITParameters getSITParameters(IScopedContext context, ISystemParameter.SourceValue source, ICPSM cpsm) throws CICSSystemManagerException {
        ISystemParameter[] systemParameters = SITParametersHelper.getSystemParameters(context, source, cpsm);
        return SITParametersHelper.createSITParameters(systemParameters);
    }

    public static ISystemParameter[] getSystemParameters(IScopedContext context, ISystemParameter.SourceValue source, ICPSM cpsm) throws CICSSystemManagerException {
        SystemParameterContext systemParameterContext = new SystemParameterContext((IContext)context, ISystemParameter.TypeValue.SIT.toString(), source.toString());
        return (ISystemParameter[])cpsm.getDefinitions2(SystemParameterType.getInstance(), (IContext)systemParameterContext);
    }

    public static ICombinedSITParameters createSITParameters(ISystemParameter[] systemParametersArray) {
        HashMap<ICICSAttribute, TreeSet<ISystemParameter>> parametersByAttribute = new HashMap<ICICSAttribute, TreeSet<ISystemParameter>>();
        HashMap<String, ICICSAttribute> attributesByCICSName = new HashMap<String, ICICSAttribute>();
        IAttribute[] iAttributeArray = SITParametersType.getInstance().attributes();
        int n = iAttributeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAttribute attribute = iAttributeArray[n2];
            ICICSAttribute cicsAttribute = (ICICSAttribute)attribute;
            attributesByCICSName.put(cicsAttribute.getCicsName(), cicsAttribute);
            ++n2;
        }
        iAttributeArray = systemParametersArray;
        n = systemParametersArray.length;
        n2 = 0;
        while (n2 < n) {
            IAttribute systemParameter = iAttributeArray[n2];
            ICICSAttribute attribute = (ICICSAttribute)attributesByCICSName.get(systemParameter.getKeyword());
            if (attribute != null) {
                TreeSet<ISystemParameter> sortedSet = (TreeSet<ISystemParameter>)parametersByAttribute.get(attribute);
                if (sortedSet == null) {
                    sortedSet = new TreeSet<ISystemParameter>(new Comparator<ISystemParameter>(){

                        @Override
                        public int compare(ISystemParameter object1, ISystemParameter object2) {
                            if (object1 == null) {
                                return object2 == null ? 0 : -1;
                            }
                            if (object2 == null) {
                                return 1;
                            }
                            return object1.getSegnum().compareTo(object2.getSegnum());
                        }
                    });
                    parametersByAttribute.put(attribute, sortedSet);
                }
                sortedSet.add((ISystemParameter)systemParameter);
            } else {
                logger.logp(Level.WARNING, SITParametersHelper.class.getName(), "createSITParameters", "Unrecognized SIT parameter: " + systemParameter);
            }
            ++n2;
        }
        CombinedSITParameters sitParameters = new CombinedSITParameters();
        for (ICICSAttribute attribute : attributesByCICSName.values()) {
            if (!parametersByAttribute.containsKey(attribute)) continue;
            SortedSet systemParameters = (SortedSet)parametersByAttribute.get(attribute);
            StringBuilder stringBuilder = new StringBuilder();
            ISystemParameter.SourceValue sourceValue = null;
            for (ISystemParameter systemParameter : systemParameters) {
                stringBuilder.append(systemParameter.getValue());
                if (sourceValue == null) {
                    sourceValue = systemParameter.getSource();
                    continue;
                }
                if (sourceValue == systemParameter.getSource()) continue;
                sourceValue = ISystemParameter.SourceValue.COMBINED;
            }
            sitParameters.setAttributeValue((IAttribute)new SystemParameterAttribute(attribute), new SystemParameterValue(sourceValue, stringBuilder.toString()));
        }
        return sitParameters;
    }
}

