/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.CICSAttribute;
import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.ProgramReference;
import com.ibm.cics.core.model.ProgramType;
import com.ibm.cics.core.model.internal.MutableCICSResource;
import com.ibm.cics.core.model.internal.MutableSMRecord;
import com.ibm.cics.model.ICICSEnums;
import com.ibm.cics.model.ICICSResource;
import com.ibm.cics.model.IProgram;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.model.mutable.IMutableProgram;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import java.util.Date;

public class MutableProgram
extends MutableCICSResource
implements IMutableProgram {
    private IProgram delegate;
    private MutableSMRecord record;

    public MutableProgram(ICPSM cpsm, IContext context, IProgram cicsObject) {
        super(cpsm, context, (ICICSResource)cicsObject);
        this.delegate = cicsObject;
        this.record = new MutableSMRecord("PROGRAM");
    }

    @Override
    public SMConnectionRecord getRecord() {
        MutableSMRecord result = new MutableSMRecord(this.record);
        result.setKeyValueFrom(this);
        return result;
    }

    @Override
    public boolean isDirty() {
        return this.record.size() != 0;
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    public IProgram.LanguageValue getLanguage() {
        return this.delegate.getLanguage();
    }

    public Long getNewcopyCount() {
        return this.delegate.getNewcopyCount();
    }

    public Long getUseCount() {
        return this.delegate.getUseCount();
    }

    public Long getIntervalUseCount() {
        return this.delegate.getIntervalUseCount();
    }

    public Long getConcurrentUseCount() {
        return this.delegate.getConcurrentUseCount();
    }

    public Long getFetchCount() {
        return this.delegate.getFetchCount();
    }

    public ICICSEnums.EnablementValue getStatus() {
        String result = this.record.get("STATUS");
        if (result == null) {
            return this.delegate.getStatus();
        }
        return (ICICSEnums.EnablementValue)((CICSAttribute)ProgramType.STATUS).get(result, this.record.getNormalizers());
    }

    public IProgram.HoldStatusValue getHoldStatus() {
        return this.delegate.getHoldStatus();
    }

    public IProgram.ShareStatusValue getShareStatus() {
        String result = this.record.get("SHARESTATUS");
        if (result == null) {
            return this.delegate.getShareStatus();
        }
        return (IProgram.ShareStatusValue)((CICSAttribute)ProgramType.SHARE_STATUS).get(result, this.record.getNormalizers());
    }

    public Long getLength() {
        return this.delegate.getLength();
    }

    public Long getRPLNumber() {
        return this.delegate.getRPLNumber();
    }

    public IProgram.LPAStatusValue getLPAStatus() {
        return this.delegate.getLPAStatus();
    }

    public IProgram.CEDFStatusValue getCEDFStatus() {
        String result = this.record.get("CEDFSTATUS");
        if (result == null) {
            return this.delegate.getCEDFStatus();
        }
        return (IProgram.CEDFStatusValue)((CICSAttribute)ProgramType.CEDF_STATUS).get(result, this.record.getNormalizers());
    }

    public IProgram.ProgramTypeValue getProgramType() {
        return this.delegate.getProgramType();
    }

    public IProgram.DataLocationValue getDataLocation() {
        return this.delegate.getDataLocation();
    }

    public String getFetchTime() {
        return this.delegate.getFetchTime();
    }

    public Long getRemoveCount() {
        return this.delegate.getRemoveCount();
    }

    public IProgram.ExecutionKeyValue getExecutionKey() {
        return this.delegate.getExecutionKey();
    }

    public IProgram.ExecutionSetValue getExecutionSet() {
        String result = this.record.get("EXECUTIONSET");
        if (result == null) {
            return this.delegate.getExecutionSet();
        }
        return (IProgram.ExecutionSetValue)((CICSAttribute)ProgramType.EXECUTION_SET).get(result, this.record.getNormalizers());
    }

    public String getEntryPoint() {
        return this.delegate.getEntryPoint();
    }

    public String getLoadPoint() {
        return this.delegate.getLoadPoint();
    }

    public IProgram.COBOLTypeValue getCOBOLType() {
        return this.delegate.getCOBOLType();
    }

    public String getRemoteName() {
        return this.delegate.getRemoteName();
    }

    public String getRemoteSystem() {
        return this.delegate.getRemoteSystem();
    }

    public String getMirrorTransaction() {
        return this.delegate.getMirrorTransaction();
    }

    public IProgram.CurrentLocationValue getCurrentLocation() {
        return this.delegate.getCurrentLocation();
    }

    public IProgram.NewcopyStatusValue getNewcopyStatus() {
        String result = this.record.get("COPY");
        if (result == null) {
            return this.delegate.getNewcopyStatus();
        }
        return (IProgram.NewcopyStatusValue)((CICSAttribute)ProgramType.NEWCOPY_STATUS).get(result, this.record.getNormalizers());
    }

    public IProgram.RoutingTypeValue getRoutingType() {
        return this.delegate.getRoutingType();
    }

    public IProgram.ConcurrencyValue getConcurrency() {
        return this.delegate.getConcurrency();
    }

    public IProgram.RuntimeValue getRuntime() {
        String result = this.record.get("RUNTIME");
        if (result == null) {
            return this.delegate.getRuntime();
        }
        return (IProgram.RuntimeValue)((CICSAttribute)ProgramType.RUNTIME).get(result, this.record.getNormalizers());
    }

    public String getJVMClass() {
        String result = this.record.get("JVMCLASS");
        if (result == null) {
            return this.delegate.getJVMClass();
        }
        return (String)((CICSAttribute)ProgramType.JVM_CLASS).get(result, this.record.getNormalizers());
    }

    public IProgram.HotPoolingValue getHotPooling() {
        String result = this.record.get("HOTPOOLING");
        if (result == null) {
            return this.delegate.getHotPooling();
        }
        return (IProgram.HotPoolingValue)((CICSAttribute)ProgramType.HOT_POOLING).get(result, this.record.getNormalizers());
    }

    public String getJVMProfile() {
        String result = this.record.get("JVMPROFILE");
        if (result == null) {
            return this.delegate.getJVMProfile();
        }
        return (String)((CICSAttribute)ProgramType.JVM_PROFILE).get(result, this.record.getNormalizers());
    }

    public String getAverageLoadTime() {
        return this.delegate.getAverageLoadTime();
    }

    public String getUsesPerFetch() {
        return this.delegate.getUsesPerFetch();
    }

    public String getLoadingRate() {
        return this.delegate.getLoadingRate();
    }

    public String getRemovalRate() {
        return this.delegate.getRemovalRate();
    }

    public String getUseRate() {
        return this.delegate.getUseRate();
    }

    public Long getJVMUseCount() {
        return this.delegate.getJVMUseCount();
    }

    public IProgram.APIStatusValue getAPIStatus() {
        return this.delegate.getAPIStatus();
    }

    public String getLibrary() {
        return this.delegate.getLibrary();
    }

    public String getDSName() {
        return this.delegate.getDSName();
    }

    public String getChangeUserID() {
        return this.delegate.getChangeUserID();
    }

    public IProgram.ChangeAgentValue getChangeAgent() {
        return this.delegate.getChangeAgent();
    }

    public String getChangeAgentRelease() {
        return this.delegate.getChangeAgentRelease();
    }

    public IProgram.InstallAgentValue getInstallAgent() {
        return this.delegate.getInstallAgent();
    }

    public Date getChangeTime() {
        return this.delegate.getChangeTime();
    }

    public String getDefineSource() {
        return this.delegate.getDefineSource();
    }

    public Date getDefineTime() {
        return this.delegate.getDefineTime();
    }

    public String getInstallUserID() {
        return this.delegate.getInstallUserID();
    }

    public Date getInstallTime() {
        return this.delegate.getInstallTime();
    }

    public Long getBasdefinever() {
        return this.delegate.getBasdefinever();
    }

    public String getJvmserver() {
        return this.delegate.getJvmserver();
    }

    public String getApplicationName() {
        return this.delegate.getApplicationName();
    }

    public String getPlatformName() {
        return this.delegate.getPlatformName();
    }

    public String getOperationName() {
        String result = this.record.get("OPERATION");
        if (result == null) {
            return this.delegate.getOperationName();
        }
        return (String)((CICSAttribute)ProgramType.OPERATION_NAME).get(result, this.record.getNormalizers());
    }

    public Long getMajorVersion() {
        return this.delegate.getMajorVersion();
    }

    public Long getMinorVersion() {
        return this.delegate.getMinorVersion();
    }

    public Long getMicroVersion() {
        return this.delegate.getMicroVersion();
    }

    public IProgram.ResidencyValue getResidency() {
        return this.delegate.getResidency();
    }

    public void setStatus(ICICSEnums.EnablementValue _status) {
        if (_status.equals((Object)this.delegate.getStatus())) {
            this.record.set("STATUS", null);
        } else {
            ProgramType.STATUS.validate((Object)_status);
            String connectionSpecificExternalValue = ((CICSAttribute)ProgramType.STATUS).set(_status, this.record.getNormalizers());
            this.record.set("STATUS", connectionSpecificExternalValue);
        }
    }

    public void setShareStatus(IProgram.ShareStatusValue _shareStatus) {
        if (_shareStatus.equals((Object)this.delegate.getShareStatus())) {
            this.record.set("SHARESTATUS", null);
        } else {
            ProgramType.SHARE_STATUS.validate((Object)_shareStatus);
            String connectionSpecificExternalValue = ((CICSAttribute)ProgramType.SHARE_STATUS).set(_shareStatus, this.record.getNormalizers());
            this.record.set("SHARESTATUS", connectionSpecificExternalValue);
        }
    }

    public void setCEDFStatus(IProgram.CEDFStatusValue _CEDFStatus) {
        if (_CEDFStatus.equals((Object)this.delegate.getCEDFStatus())) {
            this.record.set("CEDFSTATUS", null);
        } else {
            ProgramType.CEDF_STATUS.validate((Object)_CEDFStatus);
            String connectionSpecificExternalValue = ((CICSAttribute)ProgramType.CEDF_STATUS).set(_CEDFStatus, this.record.getNormalizers());
            this.record.set("CEDFSTATUS", connectionSpecificExternalValue);
        }
    }

    public void setExecutionSet(IProgram.ExecutionSetValue _executionSet) {
        if (_executionSet.equals((Object)this.delegate.getExecutionSet())) {
            this.record.set("EXECUTIONSET", null);
        } else {
            ProgramType.EXECUTION_SET.validate((Object)_executionSet);
            String connectionSpecificExternalValue = ((CICSAttribute)ProgramType.EXECUTION_SET).set(_executionSet, this.record.getNormalizers());
            this.record.set("EXECUTIONSET", connectionSpecificExternalValue);
        }
    }

    public void setNewcopyStatus(IProgram.NewcopyStatusValue _newcopyStatus) {
        if (_newcopyStatus.equals((Object)this.delegate.getNewcopyStatus())) {
            this.record.set("COPY", null);
        } else {
            ProgramType.NEWCOPY_STATUS.validate((Object)_newcopyStatus);
            String connectionSpecificExternalValue = ((CICSAttribute)ProgramType.NEWCOPY_STATUS).set(_newcopyStatus, this.record.getNormalizers());
            this.record.set("COPY", connectionSpecificExternalValue);
        }
    }

    public void setRuntime(IProgram.RuntimeValue _runtime) {
        if (_runtime.equals((Object)this.delegate.getRuntime())) {
            this.record.set("RUNTIME", null);
        } else {
            ProgramType.RUNTIME.validate((Object)_runtime);
            String connectionSpecificExternalValue = ((CICSAttribute)ProgramType.RUNTIME).set(_runtime, this.record.getNormalizers());
            this.record.set("RUNTIME", connectionSpecificExternalValue);
        }
    }

    public void setJVMClass(String _JVMClass) {
        if (_JVMClass.equals(this.delegate.getJVMClass())) {
            this.record.set("JVMCLASS", null);
        } else {
            ProgramType.JVM_CLASS.validate((Object)_JVMClass);
            String connectionSpecificExternalValue = ((CICSAttribute)ProgramType.JVM_CLASS).set(_JVMClass, this.record.getNormalizers());
            this.record.set("JVMCLASS", connectionSpecificExternalValue);
        }
    }

    public void setHotPooling(IProgram.HotPoolingValue _hotPooling) {
        if (_hotPooling.equals((Object)this.delegate.getHotPooling())) {
            this.record.set("HOTPOOLING", null);
        } else {
            ProgramType.HOT_POOLING.validate((Object)_hotPooling);
            String connectionSpecificExternalValue = ((CICSAttribute)ProgramType.HOT_POOLING).set(_hotPooling, this.record.getNormalizers());
            this.record.set("HOTPOOLING", connectionSpecificExternalValue);
        }
    }

    public void setJVMProfile(String _JVMProfile) {
        if (_JVMProfile.equals(this.delegate.getJVMProfile())) {
            this.record.set("JVMPROFILE", null);
        } else {
            ProgramType.JVM_PROFILE.validate((Object)_JVMProfile);
            String connectionSpecificExternalValue = ((CICSAttribute)ProgramType.JVM_PROFILE).set(_JVMProfile, this.record.getNormalizers());
            this.record.set("JVMPROFILE", connectionSpecificExternalValue);
        }
    }

    public void setOperationName(String _operationName) {
        if (_operationName.equals(this.delegate.getOperationName())) {
            this.record.set("OPERATION", null);
        } else {
            ProgramType.OPERATION_NAME.validate((Object)_operationName);
            String connectionSpecificExternalValue = ((CICSAttribute)ProgramType.OPERATION_NAME).set(_operationName, this.record.getNormalizers());
            this.record.set("OPERATION", connectionSpecificExternalValue);
        }
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == ProgramType.NAME) {
            return (V)this.getName();
        }
        if (attribute == ProgramType.LANGUAGE) {
            return (V)this.getLanguage();
        }
        if (attribute == ProgramType.NEWCOPY_COUNT) {
            return (V)this.getNewcopyCount();
        }
        if (attribute == ProgramType.USE_COUNT) {
            return (V)this.getUseCount();
        }
        if (attribute == ProgramType.INTERVAL_USE_COUNT) {
            return (V)this.getIntervalUseCount();
        }
        if (attribute == ProgramType.CONCURRENT_USE_COUNT) {
            return (V)this.getConcurrentUseCount();
        }
        if (attribute == ProgramType.FETCH_COUNT) {
            return (V)this.getFetchCount();
        }
        if (attribute == ProgramType.STATUS) {
            return (V)this.getStatus();
        }
        if (attribute == ProgramType.HOLD_STATUS) {
            return (V)this.getHoldStatus();
        }
        if (attribute == ProgramType.SHARE_STATUS) {
            return (V)this.getShareStatus();
        }
        if (attribute == ProgramType.LENGTH) {
            return (V)this.getLength();
        }
        if (attribute == ProgramType.RPL_NUMBER) {
            return (V)this.getRPLNumber();
        }
        if (attribute == ProgramType.LPA_STATUS) {
            return (V)this.getLPAStatus();
        }
        if (attribute == ProgramType.CEDF_STATUS) {
            return (V)this.getCEDFStatus();
        }
        if (attribute == ProgramType.PROGRAM_TYPE) {
            return (V)this.getProgramType();
        }
        if (attribute == ProgramType.DATA_LOCATION) {
            return (V)this.getDataLocation();
        }
        if (attribute == ProgramType.FETCH_TIME) {
            return (V)this.getFetchTime();
        }
        if (attribute == ProgramType.REMOVE_COUNT) {
            return (V)this.getRemoveCount();
        }
        if (attribute == ProgramType.EXECUTION_KEY) {
            return (V)this.getExecutionKey();
        }
        if (attribute == ProgramType.EXECUTION_SET) {
            return (V)this.getExecutionSet();
        }
        if (attribute == ProgramType.ENTRY_POINT) {
            return (V)this.getEntryPoint();
        }
        if (attribute == ProgramType.LOAD_POINT) {
            return (V)this.getLoadPoint();
        }
        if (attribute == ProgramType.COBOL_TYPE) {
            return (V)this.getCOBOLType();
        }
        if (attribute == ProgramType.REMOTE_NAME) {
            return (V)this.getRemoteName();
        }
        if (attribute == ProgramType.REMOTE_SYSTEM) {
            return (V)this.getRemoteSystem();
        }
        if (attribute == ProgramType.MIRROR_TRANSACTION) {
            return (V)this.getMirrorTransaction();
        }
        if (attribute == ProgramType.CURRENT_LOCATION) {
            return (V)this.getCurrentLocation();
        }
        if (attribute == ProgramType.NEWCOPY_STATUS) {
            return (V)this.getNewcopyStatus();
        }
        if (attribute == ProgramType.ROUTING_TYPE) {
            return (V)this.getRoutingType();
        }
        if (attribute == ProgramType.CONCURRENCY) {
            return (V)this.getConcurrency();
        }
        if (attribute == ProgramType.RUNTIME) {
            return (V)this.getRuntime();
        }
        if (attribute == ProgramType.JVM_CLASS) {
            return (V)this.getJVMClass();
        }
        if (attribute == ProgramType.HOT_POOLING) {
            return (V)this.getHotPooling();
        }
        if (attribute == ProgramType.JVM_PROFILE) {
            return (V)this.getJVMProfile();
        }
        if (attribute == ProgramType.AVERAGE_LOAD_TIME) {
            return (V)this.getAverageLoadTime();
        }
        if (attribute == ProgramType.USES_PER_FETCH) {
            return (V)this.getUsesPerFetch();
        }
        if (attribute == ProgramType.LOADING_RATE) {
            return (V)this.getLoadingRate();
        }
        if (attribute == ProgramType.REMOVAL_RATE) {
            return (V)this.getRemovalRate();
        }
        if (attribute == ProgramType.USE_RATE) {
            return (V)this.getUseRate();
        }
        if (attribute == ProgramType.JVM_USE_COUNT) {
            return (V)this.getJVMUseCount();
        }
        if (attribute == ProgramType.API_STATUS) {
            return (V)this.getAPIStatus();
        }
        if (attribute == ProgramType.LIBRARY) {
            return (V)this.getLibrary();
        }
        if (attribute == ProgramType.DS_NAME) {
            return (V)this.getDSName();
        }
        if (attribute == ProgramType.CHANGE_USER_ID) {
            return (V)this.getChangeUserID();
        }
        if (attribute == ProgramType.CHANGE_AGENT) {
            return (V)this.getChangeAgent();
        }
        if (attribute == ProgramType.CHANGE_AGENT_RELEASE) {
            return (V)this.getChangeAgentRelease();
        }
        if (attribute == ProgramType.INSTALL_AGENT) {
            return (V)this.getInstallAgent();
        }
        if (attribute == ProgramType.CHANGE_TIME) {
            return (V)this.getChangeTime();
        }
        if (attribute == ProgramType.DEFINE_SOURCE) {
            return (V)this.getDefineSource();
        }
        if (attribute == ProgramType.DEFINE_TIME) {
            return (V)this.getDefineTime();
        }
        if (attribute == ProgramType.INSTALL_USER_ID) {
            return (V)this.getInstallUserID();
        }
        if (attribute == ProgramType.INSTALL_TIME) {
            return (V)this.getInstallTime();
        }
        if (attribute == ProgramType.BASDEFINEVER) {
            return (V)this.getBasdefinever();
        }
        if (attribute == ProgramType.JVMSERVER) {
            return (V)this.getJvmserver();
        }
        if (attribute == ProgramType.APPLICATION_NAME) {
            return (V)this.getApplicationName();
        }
        if (attribute == ProgramType.PLATFORM_NAME) {
            return (V)this.getPlatformName();
        }
        if (attribute == ProgramType.OPERATION_NAME) {
            return (V)this.getOperationName();
        }
        if (attribute == ProgramType.MAJOR_VERSION) {
            return (V)this.getMajorVersion();
        }
        if (attribute == ProgramType.MINOR_VERSION) {
            return (V)this.getMinorVersion();
        }
        if (attribute == ProgramType.MICRO_VERSION) {
            return (V)this.getMicroVersion();
        }
        if (attribute == ProgramType.RESIDENCY) {
            return (V)this.getResidency();
        }
        return super.getAttributeValue(attribute);
    }

    public ProgramType getObjectType() {
        return ProgramType.getInstance();
    }

    @Override
    public ProgramReference getCICSObjectReference() {
        return new ProgramReference(this.getCICSContainer(), this.getName());
    }
}

