/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.model.ICICSObject;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.IMutableSMConnectionRecord;
import com.ibm.cics.sm.comm.INormalizer;
import com.ibm.cics.sm.comm.SMConnectionRecord;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class MutableSMRecord
extends SMConnectionRecord
implements IMutableSMConnectionRecord {
    static final String COPYRIGHT = "Licensed Materials - Property of IBM 5655-Y04 (c) Copyright IBM Corp. 2009, 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private Map fields;
    public static final String datetimeRESTfulPattern = "MM/dd/yyyy-HH:mm:ss";
    private static final Map<String, INormalizer> NORMALIZERS = new HashMap<String, INormalizer>();

    static {
        NORMALIZERS.put("DATE_NORMALIZER_KEY", (INormalizer)new SMConnectionRecord.GenericDateNormalizer(datetimeRESTfulPattern));
    }

    public MutableSMRecord(String resourceType) {
        super(resourceType, IContext.NULL_CONTEXT);
        this.fields = new HashMap();
    }

    public MutableSMRecord(String resourceType, IContext context) {
        super(resourceType, context);
        this.fields = new HashMap();
    }

    public MutableSMRecord(MutableSMRecord record) {
        super(record.getResourceType(), record.context);
        this.fields = new HashMap(record.fields);
    }

    public void setKeyValueFrom(ICICSObject cicsObject) {
    }

    public String get(String attribute) {
        String value = (String)this.fields.get(attribute);
        return value;
    }

    public String toExternalForm() {
        return this.fields.toString();
    }

    public Map<String, INormalizer> getNormalizers() {
        return NORMALIZERS;
    }

    public void set(String attribute, String value) {
        if (value != null) {
            this.fields.put(attribute, value);
        } else {
            this.fields.remove(attribute);
        }
    }

    public int size() {
        return this.fields.size();
    }

    public Iterator iterator() {
        return this.fields.keySet().iterator();
    }
}

