/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cics.core.model.internal;

import com.ibm.cics.core.model.ICPSM;
import com.ibm.cics.core.model.WorkloadRouterReference;
import com.ibm.cics.core.model.WorkloadRouterType;
import com.ibm.cics.core.model.internal.MutableCPSMManager;
import com.ibm.cics.core.model.internal.MutableSMRecord;
import com.ibm.cics.model.ICPSMManager;
import com.ibm.cics.model.IWorkloadRouter;
import com.ibm.cics.model.meta.IAttribute;
import com.ibm.cics.model.mutable.IMutableWorkloadRouter;
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.SMConnectionRecord;

public class MutableWorkloadRouter
extends MutableCPSMManager
implements IMutableWorkloadRouter {
    private IWorkloadRouter delegate;
    private MutableSMRecord record;

    public MutableWorkloadRouter(ICPSM cpsm, IContext context, IWorkloadRouter cicsObject) {
        super(cpsm, context, (ICPSMManager)cicsObject);
        this.delegate = cicsObject;
        this.record = new MutableSMRecord("WLMAWTOR");
    }

    @Override
    public SMConnectionRecord getRecord() {
        MutableSMRecord result = new MutableSMRecord(this.record);
        result.setKeyValueFrom(this);
        return result;
    }

    @Override
    public boolean isDirty() {
        return this.record.size() != 0;
    }

    public String getWorkload() {
        return this.delegate.getWorkload();
    }

    public String getRoutingRegion() {
        return this.delegate.getRoutingRegion();
    }

    public IWorkloadRouter.ContactStatusValue getContactStatus() {
        return this.delegate.getContactStatus();
    }

    public String getWorkloadOwner() {
        return this.delegate.getWorkloadOwner();
    }

    public String getCmasOwner() {
        return this.delegate.getCmasOwner();
    }

    public IWorkloadRouter.OptimizationStatusValue getOptimizationStatus() {
        return this.delegate.getOptimizationStatus();
    }

    public <V> V getAttributeValue(IAttribute<V> attribute) {
        if (attribute == WorkloadRouterType.WORKLOAD) {
            return (V)this.getWorkload();
        }
        if (attribute == WorkloadRouterType.ROUTING_REGION) {
            return (V)this.getRoutingRegion();
        }
        if (attribute == WorkloadRouterType.CONTACT_STATUS) {
            return (V)this.getContactStatus();
        }
        if (attribute == WorkloadRouterType.WORKLOAD_OWNER) {
            return (V)this.getWorkloadOwner();
        }
        if (attribute == WorkloadRouterType.CMAS_OWNER) {
            return (V)this.getCmasOwner();
        }
        if (attribute == WorkloadRouterType.OPTIMIZATION_STATUS) {
            return (V)this.getOptimizationStatus();
        }
        return super.getAttributeValue(attribute);
    }

    public WorkloadRouterType getObjectType() {
        return WorkloadRouterType.getInstance();
    }

    @Override
    public WorkloadRouterReference getCICSObjectReference() {
        return new WorkloadRouterReference(this.getCICSContainer(), this.getWorkload(), this.getWorkloadOwner(), this.getRoutingRegion());
    }
}

