/* <copyright                                       */
/* notice="cics-lm-source-program"                  */
/* pids="CA0U"                                      */
/* years="2014"                                     */
/* crc="1569743332" >                               */
/* 	Licensed Materials - Property of IBM            */
/* 	CA0U                                            */
/* 	(C) Copyright IBM Corp. 2014 All Rights Reserved. */
/* 	US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp. */
/* </copyright>                                     */
package com.ibm.cics.ucd.steps;

import com.ibm.cics.ucd.JuliToLog4jHandler;
import com.urbancode.air.AirPluginTool;

import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.logging.Handler;
import java.util.logging.Level;

abstract class Step {
// <copyright 
// notice="cics-lm-java-class" 
// pids="CA0U" 
// years="2014" 
// crc="1569743332" > 
	static final String COPYRIGHT = "Licensed Materials - Property of IBM CA0U (c) Copyright IBM Corp. 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp."; //$NON-NLS-1$
// </copyright> 
	
	protected AirPluginTool apTool;
	
	// Hold the Logger to avoid garbage-collection
	private Logger comIbmCicsLogger;
	private Handler activeHandler

	public Step(String inputPropertyFile, String outputPropertyFile) {
		apTool = new AirPluginTool(inputPropertyFile, outputPropertyFile);
	}

	/*
	 * Constructor for unit testing
	 */
	Step(AirPluginTool apTool) {
		this.apTool = apTool;
	}

		
	public void before() {
		
		Logger rootLogger = LogManager.getLogManager().getLogger("");
		// Remove any old handlers
		for (Handler handler : rootLogger.getHandlers()) {
			rootLogger.removeHandler(handler);
		}
		
		// Create our own logger
		comIbmCicsLogger = Logger.getLogger("com.ibm.cics");
		comIbmCicsLogger.setUseParentHandlers(false);
		
		// Pass all events on
		Level handlerLevel = Level.ALL;
		Level rootLevel = Level.ALL;
		
		// Add our own handler to JUL
		activeHandler = new JuliToLog4jHandler();
		activeHandler.setLevel(handlerLevel);
		comIbmCicsLogger.addHandler(activeHandler);
		rootLogger.setLevel(rootLevel);
	}

	public void after() {
		comIbmCicsLogger.removeHandler(activeHandler)
	}
	
	protected abstract void runStep();
	
	public void run() {
		try {
			before();
			runStep();
		} finally {
			after();
		}
	}
	
}
