/* <copyright                                       */
/* notice="cics-lm-source-program"                  */
/* pids="CA0U"                                      */
/* years="2014"                                     */
/* crc="3514276934" >                               */
/* 	Licensed Materials - Property of IBM            */
/* 	CA0U                                            */
/* 	(C) Copyright IBM Corp. 2014 All Rights Reserved. */
/* 	US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp. */
/* </copyright>                                     */
package com.ibm.cics.ucd.steps

import com.ibm.cics.core.model.CICSCore;
import com.ibm.cics.core.model.FilteredContext
import com.ibm.cics.core.model.GenTypeClasses
import com.ibm.cics.core.model.ICPSM
import com.ibm.cics.core.model.ProgramType
import com.ibm.cics.model.ICICSObject
import com.ibm.cics.model.ICICSType
import com.ibm.cics.sm.comm.IContext
import com.ibm.cics.sm.comm.SystemManagerActions
import com.ibm.cics.ucd.CPSMHelper
import com.ibm.cics.ucd.properties.IntegerProperty;
import com.ibm.cics.ucd.properties.ResourceNameListPropertySupportWildCard
import com.urbancode.air.AirPluginTool;
import com.ibm.cics.ucd.exceptions.StepFailedException
import com.ibm.cics.ucd.msg.CICSUCDMessage
import java.text.MessageFormat

class PhaseinProgramStep extends CICSStep {
// <copyright 
// notice="cics-lm-java-class" 
// pids="CA0U" 
// years="2014" 
// crc="3514276934" > 
	static final String COPYRIGHT = "Licensed Materials - Property of IBM CA0U (c) Copyright IBM Corp. 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp."; //$NON-NLS-1$
// </copyright> 

	public PhaseinProgramStep(String inputPropertyFile, String outputPropertyFile) {
		this(inputPropertyFile, outputPropertyFile, CICSCore.getCPSM())
	}
	
	public PhaseinProgramStep(AirPluginTool apTool) {
		this(apTool, CICSCore.getCPSM())
	}

	/**
	 * Primarily to support unit testing
	 * @param cpsm
	 */
	PhaseinProgramStep(String inputPropertyFile, String outputPropertyFile, ICPSM cpsm) {
		super(inputPropertyFile, outputPropertyFile)
		this.cpsm = cpsm
	}
	
	PhaseinProgramStep(AirPluginTool apTool, ICPSM cpsm) {
		super(apTool)
		this.cpsm = cpsm
	}
	
	@Override
	protected void runCICSStep(ICPSM cpsm, IContext context) {
		Class<? extends ICICSType<ICICSObject>> typeClass = GenTypeClasses.getCICSTypeClassForResourceTableName("PROGRAM")
		ICICSType<?> type = typeClass.invokeMethod("getInstance", null)
		
		def props = apTool.getStepProperties()
		
		def programList = new ResourceNameListPropertySupportWildCard("Programs", ",", true).parse(props['programList']).getValue()
		
		System.out.println("\nPerform PHASEIN:\n")
		
		boolean stepFail = false
		int successCount = 0
		int failCount = 0
			
		//iterate to perform action on each program
		programList.each {
			
			def program = it
			FilteredContext filteredContext = new FilteredContext(context)
			filteredContext.setAttributeValue(ProgramType.NAME, program)
			def cpsmHelper = new CPSMHelper()
			boolean success = cpsmHelper.perform(cpsm, SystemManagerActions.PhaseIn, type, filteredContext, program, 0, 0)
			if (success)
				successCount++
			else {
				failCount++
				stepFail = true
			}
		}
		
	   System.out.println(MessageFormat.format(CICSUCDMessage.resultSummary, CICSUCDMessage.phasein, Integer.toString(successCount), Integer.toString(failCount)))
		
		if (stepFail) {
			throw new StepFailedException("Step failed.");
		}
		
	}

}
