/* <copyright                                       */
/* notice="cics-lm-source-program"                  */
/* pids="CA0U"                                      */
/* years="2014"                                     */
/* crc="1281828460" >                               */
/* 	Licensed Materials - Property of IBM            */
/* 	CA0U                                            */
/* 	(C) Copyright IBM Corp. 2014 All Rights Reserved. */
/* 	US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp. */
/* </copyright>                                     */
package com.ibm.cics.ucd.steps

import com.ibm.cics.core.model.CICSCore
import com.ibm.cics.core.model.FilteredContext
import com.ibm.cics.core.model.ICPSM
import com.ibm.cics.sm.comm.IContext;
import com.ibm.cics.sm.comm.ISystemManagerConnection
import com.ibm.cics.sm.comm.sm.SMConnection
import com.ibm.cics.ucd.CMCIConnectionHelper
import com.ibm.cics.ucd.properties.PropertyException;
import com.urbancode.air.AirPluginTool;

abstract class CICSStep extends Step {
// <copyright 
// notice="cics-lm-java-class" 
// pids="CA0U" 
// years="2014" 
// crc="1281828460" > 
	static final String COPYRIGHT = "Licensed Materials - Property of IBM CA0U (c) Copyright IBM Corp. 2014 All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp."; //$NON-NLS-1$
// </copyright> 

	protected ICPSM cpsm
	
	public CICSStep(String inputPropertyFile, String outputPropertyFile) {
		this(inputPropertyFile, outputPropertyFile, CICSCore.getCPSM())
	}
	
	public CICSStep(AirPluginTool apTool) {
		this(apTool, CICSCore.getCPSM())
	}

	/**
	 * Primarily to support unit testing
	 * @param cpsm
	 */
	CICSStep(String inputPropertyFile, String outputPropertyFile, ICPSM cpsm) {
		super(inputPropertyFile, outputPropertyFile)
		this.cpsm = cpsm
	}
	
	CICSStep(AirPluginTool apTool, ICPSM cpsm) {
		super(apTool)
		this.cpsm = cpsm
	}

		
	@Override
	protected void runStep() {
		def CMCIConnectionHelper connHelper = createCMCIConnectionHelper()
		ISystemManagerConnection conn = connHelper.establishCMCIConnection()
		cpsm.setConnection(conn)
		IContext context = connHelper.getContext(conn)
		
		runCICSStep(cpsm, context)
	}
	
	protected CMCIConnectionHelper createCMCIConnectionHelper() throws PropertyException {
		return new CMCIConnectionHelper(apTool.getStepProperties())
	}
	
	protected abstract void runCICSStep(ICPSM cpsm, IContext context);
}
